% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_validate_configuration_settings}
\alias{elasticbeanstalk_validate_configuration_settings}
\title{Takes a set of configuration settings and either a configuration
template or environment, and determines whether those values are valid}
\usage{
elasticbeanstalk_validate_configuration_settings(ApplicationName,
  TemplateName, EnvironmentName, OptionSettings)
}
\arguments{
\item{ApplicationName}{[required] The name of the application that the configuration template or
environment belongs to.}

\item{TemplateName}{The name of the configuration template to validate the settings against.

Condition: You cannot specify both this and an environment name.}

\item{EnvironmentName}{The name of the environment to validate the settings against.

Condition: You cannot specify both this and a configuration template
name.}

\item{OptionSettings}{[required] A list of the options and desired values to evaluate.}
}
\description{
Takes a set of configuration settings and either a configuration
template or environment, and determines whether those values are valid.

This action returns a list of messages indicating any errors or warnings
associated with the selection of option values.
}
\section{Request syntax}{
\preformatted{svc$validate_configuration_settings(
  ApplicationName = "string",
  TemplateName = "string",
  EnvironmentName = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# The following operation validates a CloudWatch custom metrics config
# document:
svc$validate_configuration_settings(
  ApplicationName = "my-app",
  EnvironmentName = "my-env",
  OptionSettings = list(
    list(
      Namespace = "aws:elasticbeanstalk:healthreporting:system",
      OptionName = "ConfigDocument",
      Value = "\{\"CloudWatchMetrics\": \{\"Environment\": \{\"ApplicationLatencyP99.9\": null,..."
    )
  )
)
}

}
\keyword{internal}
