% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_list_functions}
\alias{lambda_list_functions}
\title{Returns a list of Lambda functions, with the version-specific
configuration of each}
\usage{
lambda_list_functions(MasterRegion, FunctionVersion, Marker, MaxItems)
}
\arguments{
\item{MasterRegion}{For Lambda@Edge functions, the AWS Region of the master function. For
example, \code{us-east-1} filters the list of functions to only include
Lambda@Edge functions replicated from a master function in US East (N.
Virginia). If specified, you must set \code{FunctionVersion} to \code{ALL}.}

\item{FunctionVersion}{Set to \code{ALL} to include entries for all published versions of each
function.}

\item{Marker}{Specify the pagination token that's returned by a previous request to
retrieve the next page of results.}

\item{MaxItems}{The maximum number of functions to return.}
}
\description{
Returns a list of Lambda functions, with the version-specific
configuration of each. Lambda returns up to 50 functions per call.

Set \code{FunctionVersion} to \code{ALL} to include all published versions of each
function in addition to the unpublished version. To get more information
about a function or version, use GetFunction.
}
\section{Request syntax}{
\preformatted{svc$list_functions(
  MasterRegion = "string",
  FunctionVersion = "ALL",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# This operation returns a list of Lambda functions.
svc$list_functions()
}

}
\keyword{internal}
