% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_domain}
\alias{lightsail_create_domain}
\title{Creates a domain resource for the specified domain (e}
\usage{
lightsail_create_domain(domainName, tags)
}
\arguments{
\item{domainName}{[required] The domain name to manage (e.g., \code{example.com}).

You cannot register a new domain name using Lightsail. You must register
a domain name using Amazon Route 53 or another domain name registrar. If
you have already registered your domain, you can enter its name in this
parameter to manage the DNS records for that domain.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{TagResource} action to tag a resource after it's created.}
}
\description{
Creates a domain resource for the specified domain (e.g., example.com).

The \verb{create domain} operation supports tag-based access control via
request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_domain(
  domainName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
