% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_key_pair}
\alias{lightsail_create_key_pair}
\title{Creates an SSH key pair}
\usage{
lightsail_create_key_pair(keyPairName, tags)
}
\arguments{
\item{keyPairName}{[required] The name for your new key pair.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{TagResource} action to tag a resource after it's created.}
}
\description{
Creates an SSH key pair.

The \verb{create key pair} operation supports tag-based access control via
request tags. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_key_pair(
  keyPairName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
