% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_list_tags_for_resource}
\alias{elasticbeanstalk_list_tags_for_resource}
\title{Returns the tags applied to an AWS Elastic Beanstalk resource}
\usage{
elasticbeanstalk_list_tags_for_resource(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resouce for which a tag list is
requested.

Must be the ARN of an Elastic Beanstalk environment.}
}
\description{
Returns the tags applied to an AWS Elastic Beanstalk resource. The
response contains a list of tag key-value pairs.
}
\details{
Currently, Elastic Beanstalk only supports tagging of Elastic Beanstalk
environments. For details about environment tagging, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/using-features.tagging.html}{Tagging Resources in Your Elastic Beanstalk Environment}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resource(
  ResourceArn = "string"
)
}
}

\keyword{internal}
