% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_aggregate_id_format}
\alias{ec2_describe_aggregate_id_format}
\title{Describes the longer ID format settings for all resource types in a
specific Region}
\usage{
ec2_describe_aggregate_id_format(DryRun)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the longer ID format settings for all resource types in a
specific Region. This request is useful for performing a quick audit to
determine whether a specific Region is fully opted in for longer IDs
(17-character IDs).
}
\details{
This request only returns information about resource types that support
longer IDs.

The following resource types support longer IDs: \code{bundle} \|
\code{conversion-task} \| \code{customer-gateway} \| \code{dhcp-options} \|
\code{elastic-ip-allocation} \| \code{elastic-ip-association} \| \code{export-task} \|
\code{flow-log} \| \code{image} \| \code{import-task} \| \code{instance} \|
\code{internet-gateway} \| \code{network-acl} \| \code{network-acl-association} \|
\code{network-interface} \| \code{network-interface-attachment} \| \code{prefix-list}
\| \code{reservation} \| \code{route-table} \| \code{route-table-association} \|
\code{security-group} \| \code{snapshot} \| \code{subnet} \|
\code{subnet-cidr-block-association} \| \code{volume} \| \code{vpc} \|
\code{vpc-cidr-block-association} \| \code{vpc-endpoint} \|
\code{vpc-peering-connection} \| \code{vpn-connection} \| \code{vpn-gateway}.
}
\section{Request syntax}{
\preformatted{svc$describe_aggregate_id_format(
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
