% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_restart_app_server}
\alias{elasticbeanstalk_restart_app_server}
\title{Causes the environment to restart the application container server
running on each Amazon EC2 instance}
\usage{
elasticbeanstalk_restart_app_server(EnvironmentId, EnvironmentName)
}
\arguments{
\item{EnvironmentId}{The ID of the environment to restart the server for.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment to restart the server for.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}
}
\description{
Causes the environment to restart the application container server
running on each Amazon EC2 instance.
}
\section{Request syntax}{
\preformatted{svc$restart_app_server(
  EnvironmentId = "string",
  EnvironmentName = "string"
)
}
}

\examples{
# The following operation restarts application servers on all instances in
# an environment named my-env:
\dontrun{svc$restart_app_server(
  EnvironmentName = "my-env"
)}

}
\keyword{internal}
