% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_purchase_host_reservation}
\alias{ec2_purchase_host_reservation}
\title{Purchase a reservation with configurations that match those of your
Dedicated Host}
\usage{
ec2_purchase_host_reservation(ClientToken, CurrencyCode, HostIdSet,
  LimitPrice, OfferingId, TagSpecifications)
}
\arguments{
\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{CurrencyCode}{The currency in which the \code{totalUpfrontPrice}, \code{LimitPrice}, and
\code{totalHourlyPrice} amounts are specified. At this time, the only
supported currency is \code{USD}.}

\item{HostIdSet}{[required] The IDs of the Dedicated Hosts with which the reservation will be
associated.}

\item{LimitPrice}{The specified limit is checked against the total upfront cost of the
reservation (calculated as the offering\'s upfront cost multiplied by
the host count). If the total upfront cost is greater than the specified
price limit, the request fails. This is used to ensure that the purchase
does not exceed the expected upfront cost of the purchase. At this time,
the only supported currency is \code{USD}. For example, to indicate a limit
price of USD 100, specify 100.00.}

\item{OfferingId}{[required] The ID of the offering.}

\item{TagSpecifications}{The tags to apply to the Dedicated Host Reservation during purchase.}
}
\description{
Purchase a reservation with configurations that match those of your
Dedicated Host. You must have active Dedicated Hosts in your account
before you purchase a reservation. This action results in the specified
reservation being purchased and charged to your account.
}
\section{Request syntax}{
\preformatted{svc$purchase_host_reservation(
  ClientToken = "string",
  CurrencyCode = "USD",
  HostIdSet = list(
    "string"
  ),
  LimitPrice = "string",
  OfferingId = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
