% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_hosts}
\alias{ec2_modify_hosts}
\title{Modify the auto-placement setting of a Dedicated Host}
\usage{
ec2_modify_hosts(
  AutoPlacement = NULL,
  HostIds,
  HostRecovery = NULL,
  InstanceType = NULL,
  InstanceFamily = NULL,
  HostMaintenance = NULL
)
}
\arguments{
\item{AutoPlacement}{Specify whether to enable or disable auto-placement.}

\item{HostIds}{[required] The IDs of the Dedicated Hosts to modify.}

\item{HostRecovery}{Indicates whether to enable or disable host recovery for the Dedicated
Host. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host recovery}
in the \emph{Amazon EC2 User Guide}.}

\item{InstanceType}{Specifies the instance type to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support only a
specific instance type.

If you want to modify a Dedicated Host to support multiple instance
types in its current instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.}

\item{InstanceFamily}{Specifies the instance family to be supported by the Dedicated Host.
Specify this parameter to modify a Dedicated Host to support multiple
instance types within its current instance family.

If you want to modify a Dedicated Host to support a specific instance
type only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.}

\item{HostMaintenance}{Indicates whether to enable or disable host maintenance for the
Dedicated Host. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-maintenance.html}{Host maintenance}
in the \emph{Amazon EC2 User Guide}.}
}
\description{
Modify the auto-placement setting of a Dedicated Host. When auto-placement is enabled, any instances that you launch with a tenancy of \code{host} but without a specific host ID are placed onto any available Dedicated Host in your account that has auto-placement enabled. When auto-placement is disabled, you need to provide a host ID to have the instance launch onto a specific host. If no host ID is provided, the instance is launched onto a suitable host with auto-placement enabled.

See \url{https://www.paws-r-sdk.com/docs/ec2_modify_hosts/} for full documentation.
}
\keyword{internal}
