% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_list_images_in_recycle_bin}
\alias{ec2_list_images_in_recycle_bin}
\title{Lists one or more AMIs that are currently in the Recycle Bin}
\usage{
ec2_list_images_in_recycle_bin(
  ImageIds = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL
)
}
\arguments{
\item{ImageIds}{The IDs of the AMIs to list. Omit this parameter to list all of the AMIs
that are in the Recycle Bin. You can specify up to 20 IDs in a single
request.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Lists one or more AMIs that are currently in the Recycle Bin. For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/recycle-bin.html}{Recycle Bin} in the \emph{Amazon EC2 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_list_images_in_recycle_bin/} for full documentation.
}
\keyword{internal}
