% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagebuilder_operations.R
\name{imagebuilder_create_infrastructure_configuration}
\alias{imagebuilder_create_infrastructure_configuration}
\title{Creates a new infrastructure configuration}
\usage{
imagebuilder_create_infrastructure_configuration(
  name,
  description = NULL,
  instanceTypes = NULL,
  instanceProfileName,
  securityGroupIds = NULL,
  subnetId = NULL,
  logging = NULL,
  keyPair = NULL,
  terminateInstanceOnFailure = NULL,
  snsTopicArn = NULL,
  resourceTags = NULL,
  instanceMetadataOptions = NULL,
  tags = NULL,
  clientToken
)
}
\arguments{
\item{name}{[required] The name of the infrastructure configuration.}

\item{description}{The description of the infrastructure configuration.}

\item{instanceTypes}{The instance types of the infrastructure configuration. You can specify
one or more instance types to use for this build. The service will pick
one of these instance types based on availability.}

\item{instanceProfileName}{[required] The instance profile to associate with the instance used to customize
your Amazon EC2 AMI.}

\item{securityGroupIds}{The security group IDs to associate with the instance used to customize
your Amazon EC2 AMI.}

\item{subnetId}{The subnet ID in which to place the instance used to customize your
Amazon EC2 AMI.}

\item{logging}{The logging configuration of the infrastructure configuration.}

\item{keyPair}{The key pair of the infrastructure configuration. You can use this to
log on to and debug the instance used to create your image.}

\item{terminateInstanceOnFailure}{The terminate instance on failure setting of the infrastructure
configuration. Set to false if you want Image Builder to retain the
instance used to configure your AMI if the build or test phase of your
workflow fails.}

\item{snsTopicArn}{The Amazon Resource Name (ARN) for the SNS topic to which we send image
build event notifications.

EC2 Image Builder is unable to send notifications to SNS topics that are
encrypted using keys from other accounts. The key that is used to
encrypt the SNS topic must reside in the account that the Image Builder
service runs under.}

\item{resourceTags}{The tags attached to the resource created by Image Builder.}

\item{instanceMetadataOptions}{The instance metadata options that you can set for the HTTP requests
that pipeline builds use to launch EC2 build and test instances.}

\item{tags}{The tags of the infrastructure configuration.}

\item{clientToken}{[required] Unique, case-sensitive identifier you provide to ensure idempotency of
the request. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}
in the \emph{Amazon EC2 API Reference}.}
}
\description{
Creates a new infrastructure configuration. An infrastructure configuration defines the environment in which your image will be built and tested.

See \url{https://www.paws-r-sdk.com/docs/imagebuilder_create_infrastructure_configuration/} for full documentation.
}
\keyword{internal}
