% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_replace_route_table_association}
\alias{ec2_replace_route_table_association}
\title{Changes the route table associated with a given subnet, internet
gateway, or virtual private gateway in a VPC}
\usage{
ec2_replace_route_table_association(DryRun = NULL, AssociationId, RouteTableId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{AssociationId}{[required] The association ID.}

\item{RouteTableId}{[required] The ID of the new route table to associate with the subnet.}
}
\description{
Changes the route table associated with a given subnet, internet gateway, or virtual private gateway in a VPC. After the operation completes, the subnet or gateway uses the routes in the new route table. For more information about route tables, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html}{Route tables} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_replace_route_table_association/} for full documentation.
}
\keyword{internal}
