# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include budgets_service.R
NULL

#' Creates a budget and, if included, notifications and subscribers
#'
#' Creates a budget and, if included, notifications and subscribers.
#'
#' @usage
#' budgets_create_budget(AccountId, Budget, NotificationsWithSubscribers)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget.
#' @param Budget &#91;required&#93; The budget object that you want to create.
#' @param NotificationsWithSubscribers A notification that you want to associate with a budget. A budget can
#' have up to five notifications, and each notification can have one SNS
#' subscriber and up to 10 email subscribers. If you include notifications
#' and subscribers in your `CreateBudget` call, AWS creates the
#' notifications and subscribers for you.
#'
#' @section Request syntax:
#' ```
#' svc$create_budget(
#'   AccountId = "string",
#'   Budget = list(
#'     BudgetName = "string",
#'     BudgetLimit = list(
#'       Amount = "string",
#'       Unit = "string"
#'     ),
#'     CostFilters = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     CostTypes = list(
#'       IncludeTax = TRUE|FALSE,
#'       IncludeSubscription = TRUE|FALSE,
#'       UseBlended = TRUE|FALSE,
#'       IncludeRefund = TRUE|FALSE,
#'       IncludeCredit = TRUE|FALSE,
#'       IncludeUpfront = TRUE|FALSE,
#'       IncludeRecurring = TRUE|FALSE,
#'       IncludeOtherSubscription = TRUE|FALSE,
#'       IncludeSupport = TRUE|FALSE,
#'       IncludeDiscount = TRUE|FALSE,
#'       UseAmortized = TRUE|FALSE
#'     ),
#'     TimeUnit = "DAILY"|"MONTHLY"|"QUARTERLY"|"ANNUALLY",
#'     TimePeriod = list(
#'       Start = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       End = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     CalculatedSpend = list(
#'       ActualSpend = list(
#'         Amount = "string",
#'         Unit = "string"
#'       ),
#'       ForecastedSpend = list(
#'         Amount = "string",
#'         Unit = "string"
#'       )
#'     ),
#'     BudgetType = "USAGE"|"COST"|"RI_UTILIZATION"|"RI_COVERAGE",
#'     LastUpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   NotificationsWithSubscribers = list(
#'     list(
#'       Notification = list(
#'         NotificationType = "ACTUAL"|"FORECASTED",
#'         ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'         Threshold = 123.0,
#'         ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'         NotificationState = "OK"|"ALARM"
#'       ),
#'       Subscribers = list(
#'         list(
#'           SubscriptionType = "SNS"|"EMAIL",
#'           Address = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_create_budget
budgets_create_budget <- function(AccountId, Budget, NotificationsWithSubscribers = NULL) {
  op <- new_operation(
    name = "CreateBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_budget_input(AccountId = AccountId, Budget = Budget, NotificationsWithSubscribers = NotificationsWithSubscribers)
  output <- .budgets$create_budget_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_budget <- budgets_create_budget

#' Creates a notification
#'
#' Creates a notification. You must create the budget before you create the
#' associated notification.
#'
#' @usage
#' budgets_create_notification(AccountId, BudgetName, Notification,
#'   Subscribers)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' create a notification for.
#' @param BudgetName &#91;required&#93; The name of the budget that you want AWS to notify you about. Budget
#' names must be unique within an account.
#' @param Notification &#91;required&#93; The notification that you want to create.
#' @param Subscribers &#91;required&#93; A list of subscribers that you want to associate with the notification.
#' Each notification can have one SNS subscriber and up to 10 email
#' subscribers.
#'
#' @section Request syntax:
#' ```
#' svc$create_notification(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   Subscribers = list(
#'     list(
#'       SubscriptionType = "SNS"|"EMAIL",
#'       Address = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_create_notification
budgets_create_notification <- function(AccountId, BudgetName, Notification, Subscribers) {
  op <- new_operation(
    name = "CreateNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscribers = Subscribers)
  output <- .budgets$create_notification_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_notification <- budgets_create_notification

#' Creates a subscriber
#'
#' Creates a subscriber. You must create the associated budget and
#' notification before you create the subscriber.
#'
#' @usage
#' budgets_create_subscriber(AccountId, BudgetName, Notification,
#'   Subscriber)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' create a subscriber for.
#' @param BudgetName &#91;required&#93; The name of the budget that you want to subscribe to. Budget names must
#' be unique within an account.
#' @param Notification &#91;required&#93; The notification that you want to create a subscriber for.
#' @param Subscriber &#91;required&#93; The subscriber that you want to associate with a budget notification.
#'
#' @section Request syntax:
#' ```
#' svc$create_subscriber(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   Subscriber = list(
#'     SubscriptionType = "SNS"|"EMAIL",
#'     Address = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_create_subscriber
budgets_create_subscriber <- function(AccountId, BudgetName, Notification, Subscriber) {
  op <- new_operation(
    name = "CreateSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$create_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscriber = Subscriber)
  output <- .budgets$create_subscriber_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$create_subscriber <- budgets_create_subscriber

#' Deletes a budget
#'
#' Deletes a budget. You can delete your budget at any time.
#' 
#' Deleting a budget also deletes the notifications and subscribers that
#' are associated with that budget.
#'
#' @usage
#' budgets_delete_budget(AccountId, BudgetName)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' delete.
#' @param BudgetName &#91;required&#93; The name of the budget that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_budget(
#'   AccountId = "string",
#'   BudgetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_delete_budget
budgets_delete_budget <- function(AccountId, BudgetName) {
  op <- new_operation(
    name = "DeleteBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_budget_input(AccountId = AccountId, BudgetName = BudgetName)
  output <- .budgets$delete_budget_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_budget <- budgets_delete_budget

#' Deletes a notification
#'
#' Deletes a notification.
#' 
#' Deleting a notification also deletes the subscribers that are associated
#' with the notification.
#'
#' @usage
#' budgets_delete_notification(AccountId, BudgetName, Notification)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notification
#' you want to delete.
#' @param BudgetName &#91;required&#93; The name of the budget whose notification you want to delete.
#' @param Notification &#91;required&#93; The notification that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notification(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_delete_notification
budgets_delete_notification <- function(AccountId, BudgetName, Notification) {
  op <- new_operation(
    name = "DeleteNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification)
  output <- .budgets$delete_notification_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_notification <- budgets_delete_notification

#' Deletes a subscriber
#'
#' Deletes a subscriber.
#' 
#' Deleting the last subscriber to a notification also deletes the
#' notification.
#'
#' @usage
#' budgets_delete_subscriber(AccountId, BudgetName, Notification,
#'   Subscriber)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscriber you
#' want to delete.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscriber you want to delete.
#' @param Notification &#91;required&#93; The notification whose subscriber you want to delete.
#' @param Subscriber &#91;required&#93; The subscriber that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_subscriber(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   Subscriber = list(
#'     SubscriptionType = "SNS"|"EMAIL",
#'     Address = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_delete_subscriber
budgets_delete_subscriber <- function(AccountId, BudgetName, Notification, Subscriber) {
  op <- new_operation(
    name = "DeleteSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$delete_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, Subscriber = Subscriber)
  output <- .budgets$delete_subscriber_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$delete_subscriber <- budgets_delete_subscriber

#' Describes a budget
#'
#' Describes a budget.
#'
#' @usage
#' budgets_describe_budget(AccountId, BudgetName)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want a
#' description of.
#' @param BudgetName &#91;required&#93; The name of the budget that you want a description of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_budget(
#'   AccountId = "string",
#'   BudgetName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget
budgets_describe_budget <- function(AccountId, BudgetName) {
  op <- new_operation(
    name = "DescribeBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_budget_input(AccountId = AccountId, BudgetName = BudgetName)
  output <- .budgets$describe_budget_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget <- budgets_describe_budget

#' Describes the history for DAILY, MONTHLY, and QUARTERLY budgets
#'
#' Describes the history for `DAILY`, `MONTHLY`, and `QUARTERLY` budgets.
#' Budget history isn\'t available for `ANNUAL` budgets.
#'
#' @usage
#' budgets_describe_budget_performance_history(AccountId, BudgetName,
#'   TimePeriod, MaxResults, NextToken)
#'
#' @param AccountId &#91;required&#93; 
#' @param BudgetName &#91;required&#93; 
#' @param TimePeriod Retrieves how often the budget went into an `ALARM` state for the
#' specified time period.
#' @param MaxResults 
#' @param NextToken 
#'
#' @section Request syntax:
#' ```
#' svc$describe_budget_performance_history(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   TimePeriod = list(
#'     Start = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     End = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budget_performance_history
budgets_describe_budget_performance_history <- function(AccountId, BudgetName, TimePeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgetPerformanceHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_budget_performance_history_input(AccountId = AccountId, BudgetName = BudgetName, TimePeriod = TimePeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budget_performance_history_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budget_performance_history <- budgets_describe_budget_performance_history

#' Lists the budgets that are associated with an account
#'
#' Lists the budgets that are associated with an account.
#'
#' @usage
#' budgets_describe_budgets(AccountId, MaxResults, NextToken)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budgets that you want
#' descriptions of.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_budgets(
#'   AccountId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_describe_budgets
budgets_describe_budgets <- function(AccountId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBudgets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_budgets_input(AccountId = AccountId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_budgets_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_budgets <- budgets_describe_budgets

#' Lists the notifications that are associated with a budget
#'
#' Lists the notifications that are associated with a budget.
#'
#' @usage
#' budgets_describe_notifications_for_budget(AccountId, BudgetName,
#'   MaxResults, NextToken)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notifications
#' you want descriptions of.
#' @param BudgetName &#91;required&#93; The name of the budget whose notifications you want descriptions of.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notifications_for_budget(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_describe_notifications_for_budget
budgets_describe_notifications_for_budget <- function(AccountId, BudgetName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNotificationsForBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_notifications_for_budget_input(AccountId = AccountId, BudgetName = BudgetName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_notifications_for_budget_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_notifications_for_budget <- budgets_describe_notifications_for_budget

#' Lists the subscribers that are associated with a notification
#'
#' Lists the subscribers that are associated with a notification.
#'
#' @usage
#' budgets_describe_subscribers_for_notification(AccountId, BudgetName,
#'   Notification, MaxResults, NextToken)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscribers you
#' want descriptions of.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscribers you want descriptions of.
#' @param Notification &#91;required&#93; The notification whose subscribers you want to list.
#' @param MaxResults An optional integer that represents how many entries a paginated
#' response contains. The maximum is 100.
#' @param NextToken The pagination token that you include in your request to indicate the
#' next set of results that you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subscribers_for_notification(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_describe_subscribers_for_notification
budgets_describe_subscribers_for_notification <- function(AccountId, BudgetName, Notification, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeSubscribersForNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$describe_subscribers_for_notification_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, MaxResults = MaxResults, NextToken = NextToken)
  output <- .budgets$describe_subscribers_for_notification_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$describe_subscribers_for_notification <- budgets_describe_subscribers_for_notification

#' Updates a budget
#'
#' Updates a budget. You can change every part of a budget except for the
#' `budgetName` and the `calculatedSpend`. When you modify a budget, the
#' `calculatedSpend` drops to zero until AWS has new usage data to use for
#' forecasting.
#'
#' @usage
#' budgets_update_budget(AccountId, NewBudget)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget that you want to
#' update.
#' @param NewBudget &#91;required&#93; The budget that you want to update your budget to.
#'
#' @section Request syntax:
#' ```
#' svc$update_budget(
#'   AccountId = "string",
#'   NewBudget = list(
#'     BudgetName = "string",
#'     BudgetLimit = list(
#'       Amount = "string",
#'       Unit = "string"
#'     ),
#'     CostFilters = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     CostTypes = list(
#'       IncludeTax = TRUE|FALSE,
#'       IncludeSubscription = TRUE|FALSE,
#'       UseBlended = TRUE|FALSE,
#'       IncludeRefund = TRUE|FALSE,
#'       IncludeCredit = TRUE|FALSE,
#'       IncludeUpfront = TRUE|FALSE,
#'       IncludeRecurring = TRUE|FALSE,
#'       IncludeOtherSubscription = TRUE|FALSE,
#'       IncludeSupport = TRUE|FALSE,
#'       IncludeDiscount = TRUE|FALSE,
#'       UseAmortized = TRUE|FALSE
#'     ),
#'     TimeUnit = "DAILY"|"MONTHLY"|"QUARTERLY"|"ANNUALLY",
#'     TimePeriod = list(
#'       Start = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       End = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     CalculatedSpend = list(
#'       ActualSpend = list(
#'         Amount = "string",
#'         Unit = "string"
#'       ),
#'       ForecastedSpend = list(
#'         Amount = "string",
#'         Unit = "string"
#'       )
#'     ),
#'     BudgetType = "USAGE"|"COST"|"RI_UTILIZATION"|"RI_COVERAGE",
#'     LastUpdatedTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_update_budget
budgets_update_budget <- function(AccountId, NewBudget) {
  op <- new_operation(
    name = "UpdateBudget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_budget_input(AccountId = AccountId, NewBudget = NewBudget)
  output <- .budgets$update_budget_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_budget <- budgets_update_budget

#' Updates a notification
#'
#' Updates a notification.
#'
#' @usage
#' budgets_update_notification(AccountId, BudgetName, OldNotification,
#'   NewNotification)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose notification
#' you want to update.
#' @param BudgetName &#91;required&#93; The name of the budget whose notification you want to update.
#' @param OldNotification &#91;required&#93; The previous notification that is associated with a budget.
#' @param NewNotification &#91;required&#93; The updated notification to be associated with a budget.
#'
#' @section Request syntax:
#' ```
#' svc$update_notification(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   OldNotification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   NewNotification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_update_notification
budgets_update_notification <- function(AccountId, BudgetName, OldNotification, NewNotification) {
  op <- new_operation(
    name = "UpdateNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_notification_input(AccountId = AccountId, BudgetName = BudgetName, OldNotification = OldNotification, NewNotification = NewNotification)
  output <- .budgets$update_notification_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_notification <- budgets_update_notification

#' Updates a subscriber
#'
#' Updates a subscriber.
#'
#' @usage
#' budgets_update_subscriber(AccountId, BudgetName, Notification,
#'   OldSubscriber, NewSubscriber)
#'
#' @param AccountId &#91;required&#93; The `accountId` that is associated with the budget whose subscriber you
#' want to update.
#' @param BudgetName &#91;required&#93; The name of the budget whose subscriber you want to update.
#' @param Notification &#91;required&#93; The notification whose subscriber you want to update.
#' @param OldSubscriber &#91;required&#93; The previous subscriber that is associated with a budget notification.
#' @param NewSubscriber &#91;required&#93; The updated subscriber that is associated with a budget notification.
#'
#' @section Request syntax:
#' ```
#' svc$update_subscriber(
#'   AccountId = "string",
#'   BudgetName = "string",
#'   Notification = list(
#'     NotificationType = "ACTUAL"|"FORECASTED",
#'     ComparisonOperator = "GREATER_THAN"|"LESS_THAN"|"EQUAL_TO",
#'     Threshold = 123.0,
#'     ThresholdType = "PERCENTAGE"|"ABSOLUTE_VALUE",
#'     NotificationState = "OK"|"ALARM"
#'   ),
#'   OldSubscriber = list(
#'     SubscriptionType = "SNS"|"EMAIL",
#'     Address = "string"
#'   ),
#'   NewSubscriber = list(
#'     SubscriptionType = "SNS"|"EMAIL",
#'     Address = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname budgets_update_subscriber
budgets_update_subscriber <- function(AccountId, BudgetName, Notification, OldSubscriber, NewSubscriber) {
  op <- new_operation(
    name = "UpdateSubscriber",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .budgets$update_subscriber_input(AccountId = AccountId, BudgetName = BudgetName, Notification = Notification, OldSubscriber = OldSubscriber, NewSubscriber = NewSubscriber)
  output <- .budgets$update_subscriber_output()
  svc <- .budgets$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.budgets$operations$update_subscriber <- budgets_update_subscriber
