% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_rightsizing_recommendation}
\alias{costexplorer_get_rightsizing_recommendation}
\title{Creates recommendations that helps you save cost by identifying idle and
underutilized Amazon EC2 instances}
\usage{
costexplorer_get_rightsizing_recommendation(Filter, Service, PageSize,
  NextPageToken)
}
\arguments{
\item{Filter}{}

\item{Service}{[required] The specific service that you want recommendations for. The only valid
value for \code{GetRightsizingRecommendation} is \"\code{AmazonEC2}\".}

\item{PageSize}{The number of recommendations that you want returned in a single
response object.}

\item{NextPageToken}{The pagination token that indicates the next set of results that you
want to retrieve.}
}
\description{
Creates recommendations that helps you save cost by identifying idle and
underutilized Amazon EC2 instances.
}
\details{
Recommendations are generated to either downsize or terminate instances,
along with providing savings detail and metrics. For details on
calculation and function, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/ce-what-is.html}{Optimizing Your Cost with Rightsizing Recommendations}.
}
\section{Request syntax}{
\preformatted{svc$get_rightsizing_recommendation(
  Filter = list(
    Or = list(
      list()
    ),
    And = list(
      list()
    ),
    Not = list(),
    Dimensions = list(
      Key = "AZ"|"INSTANCE_TYPE"|"LINKED_ACCOUNT"|"OPERATION"|"PURCHASE_TYPE"|"REGION"|"SERVICE"|"USAGE_TYPE"|"USAGE_TYPE_GROUP"|"RECORD_TYPE"|"OPERATING_SYSTEM"|"TENANCY"|"SCOPE"|"PLATFORM"|"SUBSCRIPTION_ID"|"LEGAL_ENTITY_NAME"|"DEPLOYMENT_OPTION"|"DATABASE_ENGINE"|"CACHE_ENGINE"|"INSTANCE_TYPE_FAMILY"|"BILLING_ENTITY"|"RESERVATION_ID"|"RESOURCE_ID"|"RIGHTSIZING_TYPE"|"SAVINGS_PLANS_TYPE"|"SAVINGS_PLAN_ARN"|"PAYMENT_OPTION",
      Values = list(
        "string"
      )
    ),
    Tags = list(
      Key = "string",
      Values = list(
        "string"
      )
    ),
    CostCategories = list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  Service = "string",
  PageSize = 123,
  NextPageToken = "string"
)
}
}

\keyword{internal}
