# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include marketplacecatalog_service.R
NULL

#' Used to cancel an open change request
#'
#' @description
#' Used to cancel an open change request. Must be sent before the status of the request changes to `APPLYING`, the final stage of completing your change request. You can describe a change during the 60-day request history retention period for API calls.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/cancel_change_set.html](https://paws-r.github.io/docs/marketplacecatalog/cancel_change_set.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`.
#' @param ChangeSetId &#91;required&#93; Required. The unique identifier of the
#' [`start_change_set`][marketplacecatalog_start_change_set] request that
#' you want to cancel.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_cancel_change_set
marketplacecatalog_cancel_change_set <- function(Catalog, ChangeSetId) {
  op <- new_operation(
    name = "CancelChangeSet",
    http_method = "PATCH",
    http_path = "/CancelChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$cancel_change_set_input(Catalog = Catalog, ChangeSetId = ChangeSetId)
  output <- .marketplacecatalog$cancel_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$cancel_change_set <- marketplacecatalog_cancel_change_set

#' Provides information about a given change set
#'
#' @description
#' Provides information about a given change set.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/describe_change_set.html](https://paws-r.github.io/docs/marketplacecatalog/describe_change_set.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`
#' @param ChangeSetId &#91;required&#93; Required. The unique identifier for the
#' [`start_change_set`][marketplacecatalog_start_change_set] request that
#' you want to describe the details for.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_describe_change_set
marketplacecatalog_describe_change_set <- function(Catalog, ChangeSetId) {
  op <- new_operation(
    name = "DescribeChangeSet",
    http_method = "GET",
    http_path = "/DescribeChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$describe_change_set_input(Catalog = Catalog, ChangeSetId = ChangeSetId)
  output <- .marketplacecatalog$describe_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$describe_change_set <- marketplacecatalog_describe_change_set

#' Returns the metadata and content of the entity
#'
#' @description
#' Returns the metadata and content of the entity.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/describe_entity.html](https://paws-r.github.io/docs/marketplacecatalog/describe_entity.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; Required. The catalog related to the request. Fixed value:
#' `AWSMarketplace`
#' @param EntityId &#91;required&#93; Required. The unique ID of the entity to describe.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_describe_entity
marketplacecatalog_describe_entity <- function(Catalog, EntityId) {
  op <- new_operation(
    name = "DescribeEntity",
    http_method = "GET",
    http_path = "/DescribeEntity",
    paginator = list()
  )
  input <- .marketplacecatalog$describe_entity_input(Catalog = Catalog, EntityId = EntityId)
  output <- .marketplacecatalog$describe_entity_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$describe_entity <- marketplacecatalog_describe_entity

#' Returns the list of change sets owned by the account being used to make
#' the call
#'
#' @description
#' Returns the list of change sets owned by the account being used to make the call. You can filter this list by providing any combination of `entityId`, `ChangeSetName`, and status. If you provide more than one filter, the API operation applies a logical AND between the filters.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/list_change_sets.html](https://paws-r.github.io/docs/marketplacecatalog/list_change_sets.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param FilterList An array of filter objects.
#' @param Sort An object that contains two attributes, `SortBy` and `SortOrder`.
#' @param MaxResults The maximum number of results returned by a single call. This value must
#' be provided in the next call to retrieve the next set of results. By
#' default, this value is 20.
#' @param NextToken The token value retrieved from a previous call to access the next page
#' of results.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_list_change_sets
marketplacecatalog_list_change_sets <- function(Catalog, FilterList = NULL, Sort = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListChangeSets",
    http_method = "POST",
    http_path = "/ListChangeSets",
    paginator = list()
  )
  input <- .marketplacecatalog$list_change_sets_input(Catalog = Catalog, FilterList = FilterList, Sort = Sort, MaxResults = MaxResults, NextToken = NextToken)
  output <- .marketplacecatalog$list_change_sets_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$list_change_sets <- marketplacecatalog_list_change_sets

#' Provides the list of entities of a given type
#'
#' @description
#' Provides the list of entities of a given type.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/list_entities.html](https://paws-r.github.io/docs/marketplacecatalog/list_entities.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param EntityType &#91;required&#93; The type of entities to retrieve.
#' @param FilterList An array of filter objects. Each filter object contains two attributes,
#' `filterName` and `filterValues`.
#' @param Sort An object that contains two attributes, `SortBy` and `SortOrder`.
#' @param NextToken The value of the next token, if it exists. Null if there are no more
#' results.
#' @param MaxResults Specifies the upper limit of the elements on a single page. If a value
#' isn't provided, the default value is 20.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_list_entities
marketplacecatalog_list_entities <- function(Catalog, EntityType, FilterList = NULL, Sort = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntities",
    http_method = "POST",
    http_path = "/ListEntities",
    paginator = list()
  )
  input <- .marketplacecatalog$list_entities_input(Catalog = Catalog, EntityType = EntityType, FilterList = FilterList, Sort = Sort, NextToken = NextToken, MaxResults = MaxResults)
  output <- .marketplacecatalog$list_entities_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$list_entities <- marketplacecatalog_list_entities

#' This operation allows you to request changes for your entities
#'
#' @description
#' This operation allows you to request changes for your entities. Within a single ChangeSet, you cannot start the same change type against the same entity multiple times. Additionally, when a ChangeSet is running, all the entities targeted by the different changes are locked until the ChangeSet has completed (either succeeded, cancelled, or failed). If you try to start a ChangeSet containing a change against an entity that is already locked, you will receive a `ResourceInUseException`.
#'
#' See [https://paws-r.github.io/docs/marketplacecatalog/start_change_set.html](https://paws-r.github.io/docs/marketplacecatalog/start_change_set.html) for full documentation.
#'
#' @param Catalog &#91;required&#93; The catalog related to the request. Fixed value: `AWSMarketplace`
#' @param ChangeSet &#91;required&#93; Array of `change` object.
#' @param ChangeSetName Optional case sensitive string of up to 100 ASCII characters. The change
#' set name can be used to filter the list of change sets.
#' @param ClientRequestToken A unique token to identify the request to ensure idempotency.
#'
#' @keywords internal
#'
#' @rdname marketplacecatalog_start_change_set
marketplacecatalog_start_change_set <- function(Catalog, ChangeSet, ChangeSetName = NULL, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "StartChangeSet",
    http_method = "POST",
    http_path = "/StartChangeSet",
    paginator = list()
  )
  input <- .marketplacecatalog$start_change_set_input(Catalog = Catalog, ChangeSet = ChangeSet, ChangeSetName = ChangeSetName, ClientRequestToken = ClientRequestToken)
  output <- .marketplacecatalog$start_change_set_output()
  config <- get_config()
  svc <- .marketplacecatalog$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.marketplacecatalog$operations$start_change_set <- marketplacecatalog_start_change_set
