% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_update_application_settings}
\alias{pinpoint_update_application_settings}
\title{Updates the settings for an application}
\usage{
pinpoint_update_application_settings(ApplicationId,
  WriteApplicationSettingsRequest)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}

\item{WriteApplicationSettingsRequest}{[required]}
}
\description{
Updates the settings for an application.
}
\section{Request syntax}{
\preformatted{svc$update_application_settings(
  ApplicationId = "string",
  WriteApplicationSettingsRequest = list(
    CampaignHook = list(
      LambdaFunctionName = "string",
      Mode = "DELIVERY"|"FILTER",
      WebUrl = "string"
    ),
    CloudWatchMetricsEnabled = TRUE|FALSE,
    EventTaggingEnabled = TRUE|FALSE,
    Limits = list(
      Daily = 123,
      MaximumDuration = 123,
      MessagesPerSecond = 123,
      Total = 123
    ),
    QuietTime = list(
      End = "string",
      Start = "string"
    )
  )
)
}
}

\keyword{internal}
