% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_update_routing_profile_queues}
\alias{connect_update_routing_profile_queues}
\title{Updates the properties associated with a set of queues for a routing
profile}
\usage{
connect_update_routing_profile_queues(InstanceId, RoutingProfileId,
  QueueConfigs)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{RoutingProfileId}{[required] The identifier of the routing profile.}

\item{QueueConfigs}{[required] The queues to be updated for this routing profile. Queues must first be
associated to the routing profile. You can do this using
AssociateRoutingProfileQueues.}
}
\value{
An empty list.
}
\description{
Updates the properties associated with a set of queues for a routing
profile.
}
\section{Request syntax}{
\preformatted{svc$update_routing_profile_queues(
  InstanceId = "string",
  RoutingProfileId = "string",
  QueueConfigs = list(
    list(
      QueueReference = list(
        QueueId = "string",
        Channel = "VOICE"|"CHAT"|"TASK"
      ),
      Priority = 123,
      Delay = 123
    )
  )
)
}
}

\keyword{internal}
