% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_get_identity_notification_attributes}
\alias{ses_get_identity_notification_attributes}
\title{Given a list of verified identities (email addresses and/or domains),
returns a structure describing identity notification attributes}
\usage{
ses_get_identity_notification_attributes(Identities)
}
\arguments{
\item{Identities}{[required] A list of one or more identities. You can specify an identity by using
its name or by using its Amazon Resource Name (ARN). Examples:
\code{user@example.com}, \code{example.com},
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}.}
}
\description{
Given a list of verified identities (email addresses and/or domains),
returns a structure describing identity notification attributes.
}
\details{
This operation is throttled at one request per second and can only get
notification attributes for up to 100 identities at a time.

For more information about using notifications with Amazon SES, see the
\href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html}{Amazon SES Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_identity_notification_attributes(
  Identities = list(
    "string"
  )
)
}
}

\examples{
# The following example returns the notification attributes for an
# identity:
\donttest{svc$get_identity_notification_attributes(
  Identities = list(
    "example.com"
  )
)}

}
\keyword{internal}
