% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_update_configuration_set_sending_enabled}
\alias{ses_update_configuration_set_sending_enabled}
\title{Enables or disables email sending for messages sent using a specific
configuration set in a given AWS Region}
\usage{
ses_update_configuration_set_sending_enabled(ConfigurationSetName,
  Enabled)
}
\arguments{
\item{ConfigurationSetName}{[required] The name of the configuration set that you want to update.}

\item{Enabled}{[required] Describes whether email sending is enabled or disabled for the
configuration set.}
}
\description{
Enables or disables email sending for messages sent using a specific
configuration set in a given AWS Region. You can use this operation in
conjunction with Amazon CloudWatch alarms to temporarily pause email
sending for a configuration set when the reputation metrics for that
configuration set (such as your bounce on complaint rate) exceed certain
thresholds.
}
\details{
You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$update_configuration_set_sending_enabled(
  ConfigurationSetName = "string",
  Enabled = TRUE|FALSE
)
}
}

\examples{
# Set the sending enabled flag for a specific configuration set.
\dontrun{svc$update_configuration_set_sending_enabled(
  ConfigurationSetName = "foo",
  Enabled = TRUE
)}

}
\keyword{internal}
