% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_delete_receipt_filter}
\alias{ses_delete_receipt_filter}
\title{Deletes the specified IP address filter}
\usage{
ses_delete_receipt_filter(FilterName)
}
\arguments{
\item{FilterName}{[required] The name of the IP address filter to delete.}
}
\description{
Deletes the specified IP address filter.
}
\details{
For information about managing IP address filters, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-ip-filters.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$delete_receipt_filter(
  FilterName = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes an IP address filter:
svc$delete_receipt_filter(
  FilterName = "MyFilter"
)
}

}
\keyword{internal}
