% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_vocabulary}
\alias{connect_create_vocabulary}
\title{Creates a custom vocabulary associated with your Amazon Connect instance}
\usage{
connect_create_vocabulary(
  ClientToken = NULL,
  InstanceId,
  VocabularyName,
  LanguageCode,
  Content,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If a create request is received more than
once with same client token, subsequent requests return the previous
response without creating a vocabulary again.}

\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can find the
instanceId in the ARN of the instance.}

\item{VocabularyName}{[required] A unique name of the custom vocabulary.}

\item{LanguageCode}{[required] The language code of the vocabulary entries. For a list of languages and
their corresponding language codes, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/what-is.html}{What is Amazon Transcribe?}}

\item{Content}{[required] The content of the custom vocabulary in plain-text format with a table
of values. Each row in the table represents a word or a phrase,
described with \code{Phrase}, \code{IPA}, \code{SoundsLike}, and \code{DisplayAs} fields.
Separate the fields with TAB characters. The size limit is 50KB. For
more information, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table}{Create a custom vocabulary using a table}.}

\item{Tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.

See \url{https://paws-r.github.io/docs/connect/create_vocabulary.html} for full documentation.
}
\keyword{internal}
