% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointemail_operations.R
\name{pinpointemail_list_email_identities}
\alias{pinpointemail_list_email_identities}
\title{Returns a list of all of the email identities that are associated with
your Amazon Pinpoint account}
\usage{
pinpointemail_list_email_identities(NextToken = NULL, PageSize = NULL)
}
\arguments{
\item{NextToken}{A token returned from a previous call to
\code{\link[=pinpointemail_list_email_identities]{list_email_identities}} to
indicate the position in the list of identities.}

\item{PageSize}{The number of results to show in a single call to
\code{\link[=pinpointemail_list_email_identities]{list_email_identities}}. If the
number of results is larger than the number you specified in this
parameter, then the response includes a \code{NextToken} element, which you
can use to obtain additional results.

The value you specify has to be at least 0, and can be no more than
1000.}
}
\description{
Returns a list of all of the email identities that are associated with your Amazon Pinpoint account. An identity can be either an email address or a domain. This operation returns identities that are verified as well as those that aren't.

See \url{https://paws-r.github.io/docs/pinpointemail/list_email_identities.html} for full documentation.
}
\keyword{internal}
