# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connectcases_service.R
NULL

#' Returns the description for the list of fields in the request parameters
#'
#' @description
#' Returns the description for the list of fields in the request parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_batch_get_field/](https://www.paws-r-sdk.com/docs/connectcases_batch_get_field/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fields &#91;required&#93; A list of unique field identifiers.
#'
#' @keywords internal
#'
#' @rdname connectcases_batch_get_field
connectcases_batch_get_field <- function(domainId, fields) {
  op <- new_operation(
    name = "BatchGetField",
    http_method = "POST",
    http_path = "/domains/{domainId}/fields-batch",
    paginator = list()
  )
  input <- .connectcases$batch_get_field_input(domainId = domainId, fields = fields)
  output <- .connectcases$batch_get_field_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$batch_get_field <- connectcases_batch_get_field

#' Creates and updates a set of field options for a single select field in
#' a Cases domain
#'
#' @description
#' Creates and updates a set of field options for a single select field in a Cases domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_batch_put_field_options/](https://www.paws-r-sdk.com/docs/connectcases_batch_put_field_options/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fieldId &#91;required&#93; The unique identifier of a field.
#' @param options &#91;required&#93; A list of `FieldOption` objects.
#'
#' @keywords internal
#'
#' @rdname connectcases_batch_put_field_options
connectcases_batch_put_field_options <- function(domainId, fieldId, options) {
  op <- new_operation(
    name = "BatchPutFieldOptions",
    http_method = "PUT",
    http_path = "/domains/{domainId}/fields/{fieldId}/options",
    paginator = list()
  )
  input <- .connectcases$batch_put_field_options_input(domainId = domainId, fieldId = fieldId, options = options)
  output <- .connectcases$batch_put_field_options_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$batch_put_field_options <- connectcases_batch_put_field_options

#' Creates a case in the specified Cases domain
#'
#' @description
#' Creates a case in the specified Cases domain. Case system and custom fields are taken as an array id/value pairs with a declared data types.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_case/](https://www.paws-r-sdk.com/docs/connectcases_create_case/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. If not provided, the Amazon Web Services SDK
#' populates this field. For more information about idempotency, see
#' [Making retries safe with idempotent
#' APIs](https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fields &#91;required&#93; An array of objects with field ID (matching ListFields/DescribeField)
#' and value union data.
#' @param templateId &#91;required&#93; A unique identifier of a template.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_case
connectcases_create_case <- function(clientToken = NULL, domainId, fields, templateId) {
  op <- new_operation(
    name = "CreateCase",
    http_method = "POST",
    http_path = "/domains/{domainId}/cases",
    paginator = list()
  )
  input <- .connectcases$create_case_input(clientToken = clientToken, domainId = domainId, fields = fields, templateId = templateId)
  output <- .connectcases$create_case_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_case <- connectcases_create_case

#' Creates a domain, which is a container for all case data, such as cases,
#' fields, templates and layouts
#'
#' @description
#' Creates a domain, which is a container for all case data, such as cases, fields, templates and layouts. Each Amazon Connect instance can be associated with only one Cases domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_domain/](https://www.paws-r-sdk.com/docs/connectcases_create_domain/) for full documentation.
#'
#' @param name &#91;required&#93; The name for your Cases domain. It must be unique for your Amazon Web
#' Services account.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_domain
connectcases_create_domain <- function(name) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/domains",
    paginator = list()
  )
  input <- .connectcases$create_domain_input(name = name)
  output <- .connectcases$create_domain_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_domain <- connectcases_create_domain

#' Creates a field in the Cases domain
#'
#' @description
#' Creates a field in the Cases domain. This field is used to define the case object model (that is, defines what data can be captured on cases) in a Cases domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_field/](https://www.paws-r-sdk.com/docs/connectcases_create_field/) for full documentation.
#'
#' @param description The description of the field.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param name &#91;required&#93; The name of the field.
#' @param type &#91;required&#93; Defines the data type, some system constraints, and default display of
#' the field.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_field
connectcases_create_field <- function(description = NULL, domainId, name, type) {
  op <- new_operation(
    name = "CreateField",
    http_method = "POST",
    http_path = "/domains/{domainId}/fields",
    paginator = list()
  )
  input <- .connectcases$create_field_input(description = description, domainId = domainId, name = name, type = type)
  output <- .connectcases$create_field_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_field <- connectcases_create_field

#' Creates a layout in the Cases domain
#'
#' @description
#' Creates a layout in the Cases domain. Layouts define the following configuration in the top section and More Info tab of the Cases user interface:
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_layout/](https://www.paws-r-sdk.com/docs/connectcases_create_layout/) for full documentation.
#'
#' @param content &#91;required&#93; Information about which fields will be present in the layout, and
#' information about the order of the fields.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param name &#91;required&#93; The name of the layout. It must be unique for the Cases domain.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_layout
connectcases_create_layout <- function(content, domainId, name) {
  op <- new_operation(
    name = "CreateLayout",
    http_method = "POST",
    http_path = "/domains/{domainId}/layouts",
    paginator = list()
  )
  input <- .connectcases$create_layout_input(content = content, domainId = domainId, name = name)
  output <- .connectcases$create_layout_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_layout <- connectcases_create_layout

#' Creates a related item (comments, tasks, and contacts) and associates it
#' with a case
#'
#' @description
#' Creates a related item (comments, tasks, and contacts) and associates it with a case.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_related_item/](https://www.paws-r-sdk.com/docs/connectcases_create_related_item/) for full documentation.
#'
#' @param caseId &#91;required&#93; A unique identifier of the case.
#' @param content &#91;required&#93; The content of a related item to be created.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param performedBy Represents the creator of the related item.
#' @param type &#91;required&#93; The type of a related item.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_related_item
connectcases_create_related_item <- function(caseId, content, domainId, performedBy = NULL, type) {
  op <- new_operation(
    name = "CreateRelatedItem",
    http_method = "POST",
    http_path = "/domains/{domainId}/cases/{caseId}/related-items/",
    paginator = list()
  )
  input <- .connectcases$create_related_item_input(caseId = caseId, content = content, domainId = domainId, performedBy = performedBy, type = type)
  output <- .connectcases$create_related_item_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_related_item <- connectcases_create_related_item

#' Creates a template in the Cases domain
#'
#' @description
#' Creates a template in the Cases domain. This template is used to define the case object model (that is, to define what data can be captured on cases) in a Cases domain. A template must have a unique name within a domain, and it must reference existing field IDs and layout IDs. Additionally, multiple fields with same IDs are not allowed within the same Template. A template can be either Active or Inactive, as indicated by its status. Inactive templates cannot be used to create cases.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_create_template/](https://www.paws-r-sdk.com/docs/connectcases_create_template/) for full documentation.
#'
#' @param description A brief description of the template.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param layoutConfiguration Configuration of layouts associated to the template.
#' @param name &#91;required&#93; A name for the template. It must be unique per domain.
#' @param requiredFields A list of fields that must contain a value for a case to be successfully
#' created with this template.
#' @param status The status of the template.
#'
#' @keywords internal
#'
#' @rdname connectcases_create_template
connectcases_create_template <- function(description = NULL, domainId, layoutConfiguration = NULL, name, requiredFields = NULL, status = NULL) {
  op <- new_operation(
    name = "CreateTemplate",
    http_method = "POST",
    http_path = "/domains/{domainId}/templates",
    paginator = list()
  )
  input <- .connectcases$create_template_input(description = description, domainId = domainId, layoutConfiguration = layoutConfiguration, name = name, requiredFields = requiredFields, status = status)
  output <- .connectcases$create_template_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$create_template <- connectcases_create_template

#' Deletes a Cases domain
#'
#' @description
#' Deletes a Cases domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_delete_domain/](https://www.paws-r-sdk.com/docs/connectcases_delete_domain/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#'
#' @keywords internal
#'
#' @rdname connectcases_delete_domain
connectcases_delete_domain <- function(domainId) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/domains/{domainId}",
    paginator = list()
  )
  input <- .connectcases$delete_domain_input(domainId = domainId)
  output <- .connectcases$delete_domain_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$delete_domain <- connectcases_delete_domain

#' Returns information about a specific case if it exists
#'
#' @description
#' Returns information about a specific case if it exists.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_get_case/](https://www.paws-r-sdk.com/docs/connectcases_get_case/) for full documentation.
#'
#' @param caseId &#91;required&#93; A unique identifier of the case.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fields &#91;required&#93; A list of unique field identifiers.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_get_case
connectcases_get_case <- function(caseId, domainId, fields, nextToken = NULL) {
  op <- new_operation(
    name = "GetCase",
    http_method = "POST",
    http_path = "/domains/{domainId}/cases/{caseId}",
    paginator = list(input_token = "nextToken", output_token = "nextToken")
  )
  input <- .connectcases$get_case_input(caseId = caseId, domainId = domainId, fields = fields, nextToken = nextToken)
  output <- .connectcases$get_case_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$get_case <- connectcases_get_case

#' Returns the case event publishing configuration
#'
#' @description
#' Returns the case event publishing configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_get_case_event_configuration/](https://www.paws-r-sdk.com/docs/connectcases_get_case_event_configuration/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#'
#' @keywords internal
#'
#' @rdname connectcases_get_case_event_configuration
connectcases_get_case_event_configuration <- function(domainId) {
  op <- new_operation(
    name = "GetCaseEventConfiguration",
    http_method = "POST",
    http_path = "/domains/{domainId}/case-event-configuration",
    paginator = list()
  )
  input <- .connectcases$get_case_event_configuration_input(domainId = domainId)
  output <- .connectcases$get_case_event_configuration_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$get_case_event_configuration <- connectcases_get_case_event_configuration

#' Returns information about a specific domain if it exists
#'
#' @description
#' Returns information about a specific domain if it exists.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_get_domain/](https://www.paws-r-sdk.com/docs/connectcases_get_domain/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#'
#' @keywords internal
#'
#' @rdname connectcases_get_domain
connectcases_get_domain <- function(domainId) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "POST",
    http_path = "/domains/{domainId}",
    paginator = list()
  )
  input <- .connectcases$get_domain_input(domainId = domainId)
  output <- .connectcases$get_domain_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$get_domain <- connectcases_get_domain

#' Returns the details for the requested layout
#'
#' @description
#' Returns the details for the requested layout.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_get_layout/](https://www.paws-r-sdk.com/docs/connectcases_get_layout/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param layoutId &#91;required&#93; The unique identifier of the layout.
#'
#' @keywords internal
#'
#' @rdname connectcases_get_layout
connectcases_get_layout <- function(domainId, layoutId) {
  op <- new_operation(
    name = "GetLayout",
    http_method = "POST",
    http_path = "/domains/{domainId}/layouts/{layoutId}",
    paginator = list()
  )
  input <- .connectcases$get_layout_input(domainId = domainId, layoutId = layoutId)
  output <- .connectcases$get_layout_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$get_layout <- connectcases_get_layout

#' Returns the details for the requested template
#'
#' @description
#' Returns the details for the requested template.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_get_template/](https://www.paws-r-sdk.com/docs/connectcases_get_template/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param templateId &#91;required&#93; A unique identifier of a template.
#'
#' @keywords internal
#'
#' @rdname connectcases_get_template
connectcases_get_template <- function(domainId, templateId) {
  op <- new_operation(
    name = "GetTemplate",
    http_method = "POST",
    http_path = "/domains/{domainId}/templates/{templateId}",
    paginator = list()
  )
  input <- .connectcases$get_template_input(domainId = domainId, templateId = templateId)
  output <- .connectcases$get_template_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$get_template <- connectcases_get_template

#' Lists cases for a given contact
#'
#' @description
#' Lists cases for a given contact.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_cases_for_contact/](https://www.paws-r-sdk.com/docs/connectcases_list_cases_for_contact/) for full documentation.
#'
#' @param contactArn &#91;required&#93; A unique identifier of a contact in Amazon Connect.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_list_cases_for_contact
connectcases_list_cases_for_contact <- function(contactArn, domainId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCasesForContact",
    http_method = "POST",
    http_path = "/domains/{domainId}/list-cases-for-contact",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_cases_for_contact_input(contactArn = contactArn, domainId = domainId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectcases$list_cases_for_contact_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_cases_for_contact <- connectcases_list_cases_for_contact

#' Lists all cases domains in the Amazon Web Services account
#'
#' @description
#' Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_domains/](https://www.paws-r-sdk.com/docs/connectcases_list_domains/) for full documentation.
#'
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_list_domains
connectcases_list_domains <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "POST",
    http_path = "/domains-list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_domains_input(maxResults = maxResults, nextToken = nextToken)
  output <- .connectcases$list_domains_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_domains <- connectcases_list_domains

#' Lists all of the field options for a field identifier in the domain
#'
#' @description
#' Lists all of the field options for a field identifier in the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_field_options/](https://www.paws-r-sdk.com/docs/connectcases_list_field_options/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fieldId &#91;required&#93; The unique identifier of a field.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param values A list of `FieldOption` values to filter on for
#' [`list_field_options`][connectcases_list_field_options].
#'
#' @keywords internal
#'
#' @rdname connectcases_list_field_options
connectcases_list_field_options <- function(domainId, fieldId, maxResults = NULL, nextToken = NULL, values = NULL) {
  op <- new_operation(
    name = "ListFieldOptions",
    http_method = "POST",
    http_path = "/domains/{domainId}/fields/{fieldId}/options-list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_field_options_input(domainId = domainId, fieldId = fieldId, maxResults = maxResults, nextToken = nextToken, values = values)
  output <- .connectcases$list_field_options_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_field_options <- connectcases_list_field_options

#' Lists all fields in a Cases domain
#'
#' @description
#' Lists all fields in a Cases domain.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_fields/](https://www.paws-r-sdk.com/docs/connectcases_list_fields/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_list_fields
connectcases_list_fields <- function(domainId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFields",
    http_method = "POST",
    http_path = "/domains/{domainId}/fields-list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_fields_input(domainId = domainId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectcases$list_fields_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_fields <- connectcases_list_fields

#' Lists all layouts in the given cases domain
#'
#' @description
#' Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_layouts/](https://www.paws-r-sdk.com/docs/connectcases_list_layouts/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_list_layouts
connectcases_list_layouts <- function(domainId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListLayouts",
    http_method = "POST",
    http_path = "/domains/{domainId}/layouts-list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_layouts_input(domainId = domainId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectcases$list_layouts_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_layouts <- connectcases_list_layouts

#' Lists tags for a resource
#'
#' @description
#' Lists tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/connectcases_list_tags_for_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN)
#'
#' @keywords internal
#'
#' @rdname connectcases_list_tags_for_resource
connectcases_list_tags_for_resource <- function(arn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{arn}",
    paginator = list()
  )
  input <- .connectcases$list_tags_for_resource_input(arn = arn)
  output <- .connectcases$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_tags_for_resource <- connectcases_list_tags_for_resource

#' Lists all of the templates in a Cases domain
#'
#' @description
#' Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_list_templates/](https://www.paws-r-sdk.com/docs/connectcases_list_templates/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param status A list of status values to filter on.
#'
#' @keywords internal
#'
#' @rdname connectcases_list_templates
connectcases_list_templates <- function(domainId, maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListTemplates",
    http_method = "POST",
    http_path = "/domains/{domainId}/templates-list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .connectcases$list_templates_input(domainId = domainId, maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .connectcases$list_templates_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$list_templates <- connectcases_list_templates

#' Adds case event publishing configuration
#'
#' @description
#' Adds case event publishing configuration. For a complete list of fields you can add to the event message, see [Create case fields](https://docs.aws.amazon.com/connect/latest/adminguide/case-fields.html) in the *Amazon Connect Administrator Guide*
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_put_case_event_configuration/](https://www.paws-r-sdk.com/docs/connectcases_put_case_event_configuration/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param eventBridge &#91;required&#93; Configuration to enable EventBridge case event delivery and determine
#' what data is delivered.
#'
#' @keywords internal
#'
#' @rdname connectcases_put_case_event_configuration
connectcases_put_case_event_configuration <- function(domainId, eventBridge) {
  op <- new_operation(
    name = "PutCaseEventConfiguration",
    http_method = "PUT",
    http_path = "/domains/{domainId}/case-event-configuration",
    paginator = list()
  )
  input <- .connectcases$put_case_event_configuration_input(domainId = domainId, eventBridge = eventBridge)
  output <- .connectcases$put_case_event_configuration_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$put_case_event_configuration <- connectcases_put_case_event_configuration

#' Searches for cases within their associated Cases domain
#'
#' @description
#' Searches for cases within their associated Cases domain. Search results are returned as a paginated list of abridged case documents.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_search_cases/](https://www.paws-r-sdk.com/docs/connectcases_search_cases/) for full documentation.
#'
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fields The list of field identifiers to be returned as part of the response.
#' @param filter A list of filter objects.
#' @param maxResults The maximum number of cases to return. The current maximum supported
#' value is 25. This is also the default value when no other value is
#' provided.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#' @param searchTerm A word or phrase used to perform a quick search.
#' @param sorts A list of sorts where each sort specifies a field and their sort order
#' to be applied to the results.
#'
#' @keywords internal
#'
#' @rdname connectcases_search_cases
connectcases_search_cases <- function(domainId, fields = NULL, filter = NULL, maxResults = NULL, nextToken = NULL, searchTerm = NULL, sorts = NULL) {
  op <- new_operation(
    name = "SearchCases",
    http_method = "POST",
    http_path = "/domains/{domainId}/cases-search",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "cases")
  )
  input <- .connectcases$search_cases_input(domainId = domainId, fields = fields, filter = filter, maxResults = maxResults, nextToken = nextToken, searchTerm = searchTerm, sorts = sorts)
  output <- .connectcases$search_cases_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$search_cases <- connectcases_search_cases

#' Searches for related items that are associated with a case
#'
#' @description
#' Searches for related items that are associated with a case.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_search_related_items/](https://www.paws-r-sdk.com/docs/connectcases_search_related_items/) for full documentation.
#'
#' @param caseId &#91;required&#93; A unique identifier of the case.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param filters The list of types of related items and their parameters to use for
#' filtering.
#' @param maxResults The maximum number of results to return per page.
#' @param nextToken The token for the next set of results. Use the value returned in the
#' previous response in the next request to retrieve the next set of
#' results.
#'
#' @keywords internal
#'
#' @rdname connectcases_search_related_items
connectcases_search_related_items <- function(caseId, domainId, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "SearchRelatedItems",
    http_method = "POST",
    http_path = "/domains/{domainId}/cases/{caseId}/related-items-search",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "relatedItems")
  )
  input <- .connectcases$search_related_items_input(caseId = caseId, domainId = domainId, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .connectcases$search_related_items_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$search_related_items <- connectcases_search_related_items

#' Adds tags to a resource
#'
#' @description
#' Adds tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_tag_resource/](https://www.paws-r-sdk.com/docs/connectcases_tag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN)
#' @param tags &#91;required&#93; A map of of key-value pairs that represent tags on a resource. Tags are
#' used to organize, track, or control access for this resource.
#'
#' @keywords internal
#'
#' @rdname connectcases_tag_resource
connectcases_tag_resource <- function(arn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{arn}",
    paginator = list()
  )
  input <- .connectcases$tag_resource_input(arn = arn, tags = tags)
  output <- .connectcases$tag_resource_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$tag_resource <- connectcases_tag_resource

#' Untags a resource
#'
#' @description
#' Untags a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_untag_resource/](https://www.paws-r-sdk.com/docs/connectcases_untag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; The Amazon Resource Name (ARN)
#' @param tagKeys &#91;required&#93; List of tag keys.
#'
#' @keywords internal
#'
#' @rdname connectcases_untag_resource
connectcases_untag_resource <- function(arn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{arn}",
    paginator = list()
  )
  input <- .connectcases$untag_resource_input(arn = arn, tagKeys = tagKeys)
  output <- .connectcases$untag_resource_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$untag_resource <- connectcases_untag_resource

#' Updates the values of fields on a case
#'
#' @description
#' Updates the values of fields on a case. Fields to be updated are received as an array of id/value pairs identical to the [`create_case`][connectcases_create_case] input .
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_update_case/](https://www.paws-r-sdk.com/docs/connectcases_update_case/) for full documentation.
#'
#' @param caseId &#91;required&#93; A unique identifier of the case.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fields &#91;required&#93; An array of objects with `fieldId` (matching ListFields/DescribeField)
#' and value union data, structured identical to
#' [`create_case`][connectcases_create_case].
#'
#' @keywords internal
#'
#' @rdname connectcases_update_case
connectcases_update_case <- function(caseId, domainId, fields) {
  op <- new_operation(
    name = "UpdateCase",
    http_method = "PUT",
    http_path = "/domains/{domainId}/cases/{caseId}",
    paginator = list()
  )
  input <- .connectcases$update_case_input(caseId = caseId, domainId = domainId, fields = fields)
  output <- .connectcases$update_case_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$update_case <- connectcases_update_case

#' Updates the properties of an existing field
#'
#' @description
#' Updates the properties of an existing field.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_update_field/](https://www.paws-r-sdk.com/docs/connectcases_update_field/) for full documentation.
#'
#' @param description The description of a field.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param fieldId &#91;required&#93; The unique identifier of a field.
#' @param name The name of the field.
#'
#' @keywords internal
#'
#' @rdname connectcases_update_field
connectcases_update_field <- function(description = NULL, domainId, fieldId, name = NULL) {
  op <- new_operation(
    name = "UpdateField",
    http_method = "PUT",
    http_path = "/domains/{domainId}/fields/{fieldId}",
    paginator = list()
  )
  input <- .connectcases$update_field_input(description = description, domainId = domainId, fieldId = fieldId, name = name)
  output <- .connectcases$update_field_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$update_field <- connectcases_update_field

#' Updates the attributes of an existing layout
#'
#' @description
#' Updates the attributes of an existing layout.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_update_layout/](https://www.paws-r-sdk.com/docs/connectcases_update_layout/) for full documentation.
#'
#' @param content Information about which fields will be present in the layout, the order
#' of the fields.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param layoutId &#91;required&#93; The unique identifier of the layout.
#' @param name The name of the layout. It must be unique per domain.
#'
#' @keywords internal
#'
#' @rdname connectcases_update_layout
connectcases_update_layout <- function(content = NULL, domainId, layoutId, name = NULL) {
  op <- new_operation(
    name = "UpdateLayout",
    http_method = "PUT",
    http_path = "/domains/{domainId}/layouts/{layoutId}",
    paginator = list()
  )
  input <- .connectcases$update_layout_input(content = content, domainId = domainId, layoutId = layoutId, name = name)
  output <- .connectcases$update_layout_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$update_layout <- connectcases_update_layout

#' Updates the attributes of an existing template
#'
#' @description
#' Updates the attributes of an existing template. The template attributes that can be modified include `name`, `description`, `layoutConfiguration`, `requiredFields`, and `status`. At least one of these attributes must not be null. If a null value is provided for a given attribute, that attribute is ignored and its current value is preserved.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcases_update_template/](https://www.paws-r-sdk.com/docs/connectcases_update_template/) for full documentation.
#'
#' @param description A brief description of the template.
#' @param domainId &#91;required&#93; The unique identifier of the Cases domain.
#' @param layoutConfiguration Configuration of layouts associated to the template.
#' @param name The name of the template. It must be unique per domain.
#' @param requiredFields A list of fields that must contain a value for a case to be successfully
#' created with this template.
#' @param status The status of the template.
#' @param templateId &#91;required&#93; A unique identifier for the template.
#'
#' @keywords internal
#'
#' @rdname connectcases_update_template
connectcases_update_template <- function(description = NULL, domainId, layoutConfiguration = NULL, name = NULL, requiredFields = NULL, status = NULL, templateId) {
  op <- new_operation(
    name = "UpdateTemplate",
    http_method = "PUT",
    http_path = "/domains/{domainId}/templates/{templateId}",
    paginator = list()
  )
  input <- .connectcases$update_template_input(description = description, domainId = domainId, layoutConfiguration = layoutConfiguration, name = name, requiredFields = requiredFields, status = status, templateId = templateId)
  output <- .connectcases$update_template_output()
  config <- get_config()
  svc <- .connectcases$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcases$operations$update_template <- connectcases_update_template
