% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectwisdomservice_operations.R
\name{connectwisdomservice_create_quick_response}
\alias{connectwisdomservice_create_quick_response}
\title{Creates a Wisdom quick response}
\usage{
connectwisdomservice_create_quick_response(
  channels = NULL,
  clientToken = NULL,
  content,
  contentType = NULL,
  description = NULL,
  groupingConfiguration = NULL,
  isActive = NULL,
  knowledgeBaseId,
  language = NULL,
  name,
  shortcutKey = NULL,
  tags = NULL
)
}
\arguments{
\item{channels}{The Amazon Connect channels this quick response applies to.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{content}{[required] The content of the quick response.}

\item{contentType}{The media type of the quick response content.
\itemize{
\item Use \verb{application/x.quickresponse;format=plain} for a quick response
written in plain text.
\item Use \verb{application/x.quickresponse;format=markdown} for a quick
response written in richtext.
}}

\item{description}{The description of the quick response.}

\item{groupingConfiguration}{The configuration information of the user groups that the quick response
is accessible to.}

\item{isActive}{Whether the quick response is active.}

\item{knowledgeBaseId}{[required] The identifier of the knowledge base. This should not be a
QUICK_RESPONSES type knowledge base if you're storing Wisdom Content
resource to it. Can be either the ID or the ARN. URLs cannot contain the
ARN.}

\item{language}{The language code value for the language in which the quick response is
written. The supported language codes include \code{de_DE}, \code{en_US}, \code{es_ES},
\code{fr_FR}, \code{id_ID}, \code{it_IT}, \code{ja_JP}, \code{ko_KR}, \code{pt_BR}, \code{zh_CN}, \code{zh_TW}}

\item{name}{[required] The name of the quick response.}

\item{shortcutKey}{The shortcut key of the quick response. The value should be unique
across the knowledge base.}

\item{tags}{The tags used to organize, track, or control access for this resource.}
}
\description{
Creates a Wisdom quick response.

See \url{https://www.paws-r-sdk.com/docs/connectwisdomservice_create_quick_response/} for full documentation.
}
\keyword{internal}
