# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include connectcampaignservicev2_service.R
NULL

#' Creates a campaign for the specified Amazon Connect account
#'
#' @description
#' Creates a campaign for the specified Amazon Connect account. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_create_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_create_campaign/) for full documentation.
#'
#' @param name &#91;required&#93; 
#' @param connectInstanceId &#91;required&#93; 
#' @param channelSubtypeConfig &#91;required&#93; 
#' @param source 
#' @param connectCampaignFlowArn 
#' @param schedule 
#' @param communicationTimeConfig 
#' @param communicationLimitsOverride 
#' @param tags 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_create_campaign
connectcampaignservicev2_create_campaign <- function(name, connectInstanceId, channelSubtypeConfig, source = NULL, connectCampaignFlowArn = NULL, schedule = NULL, communicationTimeConfig = NULL, communicationLimitsOverride = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "PUT",
    http_path = "/v2/campaigns",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$create_campaign_input(name = name, connectInstanceId = connectInstanceId, channelSubtypeConfig = channelSubtypeConfig, source = source, connectCampaignFlowArn = connectCampaignFlowArn, schedule = schedule, communicationTimeConfig = communicationTimeConfig, communicationLimitsOverride = communicationLimitsOverride, tags = tags)
  output <- .connectcampaignservicev2$create_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$create_campaign <- connectcampaignservicev2_create_campaign

#' Deletes a campaign from the specified Amazon Connect account
#'
#' @description
#' Deletes a campaign from the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delete_campaign
connectcampaignservicev2_delete_campaign <- function(id) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "DELETE",
    http_path = "/v2/campaigns/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_campaign_input(id = id)
  output <- .connectcampaignservicev2$delete_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_campaign <- connectcampaignservicev2_delete_campaign

#' Deletes the channel subtype config of a campaign
#'
#' @description
#' Deletes the channel subtype config of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_channel_subtype_config/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_channel_subtype_config/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param channelSubtype &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_dele_camp_chan_subt_conf
connectcampaignservicev2_delete_campaign_channel_subtype_config <- function(id, channelSubtype) {
  op <- new_operation(
    name = "DeleteCampaignChannelSubtypeConfig",
    http_method = "DELETE",
    http_path = "/v2/campaigns/{id}/channel-subtype-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_campaign_channel_subtype_config_input(id = id, channelSubtype = channelSubtype)
  output <- .connectcampaignservicev2$delete_campaign_channel_subtype_config_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_campaign_channel_subtype_config <- connectcampaignservicev2_delete_campaign_channel_subtype_config

#' Deletes the communication limits config for a campaign
#'
#' @description
#' Deletes the communication limits config for a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_communication_limits/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_communication_limits/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param config &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delet_campa_commu_limit
connectcampaignservicev2_delete_campaign_communication_limits <- function(id, config) {
  op <- new_operation(
    name = "DeleteCampaignCommunicationLimits",
    http_method = "DELETE",
    http_path = "/v2/campaigns/{id}/communication-limits",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_campaign_communication_limits_input(id = id, config = config)
  output <- .connectcampaignservicev2$delete_campaign_communication_limits_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_campaign_communication_limits <- connectcampaignservicev2_delete_campaign_communication_limits

#' Deletes the communication time config for a campaign
#'
#' @description
#' Deletes the communication time config for a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_communication_time/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_campaign_communication_time/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param config &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delete_campaign_communication_time
connectcampaignservicev2_delete_campaign_communication_time <- function(id, config) {
  op <- new_operation(
    name = "DeleteCampaignCommunicationTime",
    http_method = "DELETE",
    http_path = "/v2/campaigns/{id}/communication-time",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_campaign_communication_time_input(id = id, config = config)
  output <- .connectcampaignservicev2$delete_campaign_communication_time_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_campaign_communication_time <- connectcampaignservicev2_delete_campaign_communication_time

#' Deletes a connect instance config from the specified AWS account
#'
#' @description
#' Deletes a connect instance config from the specified AWS account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_connect_instance_config/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_connect_instance_config/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param campaignDeletionPolicy 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delete_connect_instance_config
connectcampaignservicev2_delete_connect_instance_config <- function(connectInstanceId, campaignDeletionPolicy = NULL) {
  op <- new_operation(
    name = "DeleteConnectInstanceConfig",
    http_method = "DELETE",
    http_path = "/v2/connect-instance/{connectInstanceId}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_connect_instance_config_input(connectInstanceId = connectInstanceId, campaignDeletionPolicy = campaignDeletionPolicy)
  output <- .connectcampaignservicev2$delete_connect_instance_config_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_connect_instance_config <- connectcampaignservicev2_delete_connect_instance_config

#' Delete the integration for the specified Amazon Connect instance
#'
#' @description
#' Delete the integration for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_connect_instance_integration/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_connect_instance_integration/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param integrationIdentifier &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delete_connect_instance_integration
connectcampaignservicev2_delete_connect_instance_integration <- function(connectInstanceId, integrationIdentifier) {
  op <- new_operation(
    name = "DeleteConnectInstanceIntegration",
    http_method = "POST",
    http_path = "/v2/connect-instance/{connectInstanceId}/integrations/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_connect_instance_integration_input(connectInstanceId = connectInstanceId, integrationIdentifier = integrationIdentifier)
  output <- .connectcampaignservicev2$delete_connect_instance_integration_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_connect_instance_integration <- connectcampaignservicev2_delete_connect_instance_integration

#' Delete the Connect Campaigns onboarding job for the specified Amazon
#' Connect instance
#'
#' @description
#' Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_instance_onboarding_job/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_delete_instance_onboarding_job/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_delete_instance_onboarding_job
connectcampaignservicev2_delete_instance_onboarding_job <- function(connectInstanceId) {
  op <- new_operation(
    name = "DeleteInstanceOnboardingJob",
    http_method = "DELETE",
    http_path = "/v2/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$delete_instance_onboarding_job_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservicev2$delete_instance_onboarding_job_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$delete_instance_onboarding_job <- connectcampaignservicev2_delete_instance_onboarding_job

#' Describes the specific campaign
#'
#' @description
#' Describes the specific campaign.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_describe_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_describe_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_describe_campaign
connectcampaignservicev2_describe_campaign <- function(id) {
  op <- new_operation(
    name = "DescribeCampaign",
    http_method = "GET",
    http_path = "/v2/campaigns/{id}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$describe_campaign_input(id = id)
  output <- .connectcampaignservicev2$describe_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$describe_campaign <- connectcampaignservicev2_describe_campaign

#' Get state of a campaign for the specified Amazon Connect account
#'
#' @description
#' Get state of a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_campaign_state/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_campaign_state/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_get_campaign_state
connectcampaignservicev2_get_campaign_state <- function(id) {
  op <- new_operation(
    name = "GetCampaignState",
    http_method = "GET",
    http_path = "/v2/campaigns/{id}/state",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$get_campaign_state_input(id = id)
  output <- .connectcampaignservicev2$get_campaign_state_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$get_campaign_state <- connectcampaignservicev2_get_campaign_state

#' Get state of campaigns for the specified Amazon Connect account
#'
#' @description
#' Get state of campaigns for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_campaign_state_batch/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_campaign_state_batch/) for full documentation.
#'
#' @param campaignIds &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_get_campaign_state_batch
connectcampaignservicev2_get_campaign_state_batch <- function(campaignIds) {
  op <- new_operation(
    name = "GetCampaignStateBatch",
    http_method = "POST",
    http_path = "/v2/campaigns-state",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$get_campaign_state_batch_input(campaignIds = campaignIds)
  output <- .connectcampaignservicev2$get_campaign_state_batch_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$get_campaign_state_batch <- connectcampaignservicev2_get_campaign_state_batch

#' Get the specific Connect instance config
#'
#' @description
#' Get the specific Connect instance config.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_connect_instance_config/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_connect_instance_config/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_get_connect_instance_config
connectcampaignservicev2_get_connect_instance_config <- function(connectInstanceId) {
  op <- new_operation(
    name = "GetConnectInstanceConfig",
    http_method = "GET",
    http_path = "/v2/connect-instance/{connectInstanceId}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$get_connect_instance_config_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservicev2$get_connect_instance_config_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$get_connect_instance_config <- connectcampaignservicev2_get_connect_instance_config

#' Get the specific instance onboarding job status
#'
#' @description
#' Get the specific instance onboarding job status.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_instance_onboarding_job_status/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_get_instance_onboarding_job_status/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_get_instance_onboarding_job_status
connectcampaignservicev2_get_instance_onboarding_job_status <- function(connectInstanceId) {
  op <- new_operation(
    name = "GetInstanceOnboardingJobStatus",
    http_method = "GET",
    http_path = "/v2/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$get_instance_onboarding_job_status_input(connectInstanceId = connectInstanceId)
  output <- .connectcampaignservicev2$get_instance_onboarding_job_status_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$get_instance_onboarding_job_status <- connectcampaignservicev2_get_instance_onboarding_job_status

#' Provides summary information about the campaigns under the specified
#' Amazon Connect account
#'
#' @description
#' Provides summary information about the campaigns under the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_campaigns/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_campaigns/) for full documentation.
#'
#' @param maxResults 
#' @param nextToken 
#' @param filters 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_list_campaigns
connectcampaignservicev2_list_campaigns <- function(maxResults = NULL, nextToken = NULL, filters = NULL) {
  op <- new_operation(
    name = "ListCampaigns",
    http_method = "POST",
    http_path = "/v2/campaigns-summary",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "campaignSummaryList"),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$list_campaigns_input(maxResults = maxResults, nextToken = nextToken, filters = filters)
  output <- .connectcampaignservicev2$list_campaigns_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$list_campaigns <- connectcampaignservicev2_list_campaigns

#' Provides summary information about the integration under the specified
#' Connect instance
#'
#' @description
#' Provides summary information about the integration under the specified Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_connect_instance_integrations/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_connect_instance_integrations/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param maxResults 
#' @param nextToken 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_list_connect_instance_integrations
connectcampaignservicev2_list_connect_instance_integrations <- function(connectInstanceId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListConnectInstanceIntegrations",
    http_method = "GET",
    http_path = "/v2/connect-instance/{connectInstanceId}/integrations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "integrationSummaryList"),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$list_connect_instance_integrations_input(connectInstanceId = connectInstanceId, maxResults = maxResults, nextToken = nextToken)
  output <- .connectcampaignservicev2$list_connect_instance_integrations_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$list_connect_instance_integrations <- connectcampaignservicev2_list_connect_instance_integrations

#' List tags for a resource
#'
#' @description
#' List tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_list_tags_for_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_list_tags_for_resource
connectcampaignservicev2_list_tags_for_resource <- function(arn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v2/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$list_tags_for_resource_input(arn = arn)
  output <- .connectcampaignservicev2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$list_tags_for_resource <- connectcampaignservicev2_list_tags_for_resource

#' Pauses a campaign for the specified Amazon Connect account
#'
#' @description
#' Pauses a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_pause_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_pause_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_pause_campaign
connectcampaignservicev2_pause_campaign <- function(id) {
  op <- new_operation(
    name = "PauseCampaign",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/pause",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$pause_campaign_input(id = id)
  output <- .connectcampaignservicev2$pause_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$pause_campaign <- connectcampaignservicev2_pause_campaign

#' Put or update the integration for the specified Amazon Connect instance
#'
#' @description
#' Put or update the integration for the specified Amazon Connect instance.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_connect_instance_integration/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_connect_instance_integration/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param integrationConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_put_connect_instance_integration
connectcampaignservicev2_put_connect_instance_integration <- function(connectInstanceId, integrationConfig) {
  op <- new_operation(
    name = "PutConnectInstanceIntegration",
    http_method = "PUT",
    http_path = "/v2/connect-instance/{connectInstanceId}/integrations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$put_connect_instance_integration_input(connectInstanceId = connectInstanceId, integrationConfig = integrationConfig)
  output <- .connectcampaignservicev2$put_connect_instance_integration_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$put_connect_instance_integration <- connectcampaignservicev2_put_connect_instance_integration

#' Creates outbound requests for the specified campaign Amazon Connect
#' account
#'
#' @description
#' Creates outbound requests for the specified campaign Amazon Connect account. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_outbound_request_batch/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_outbound_request_batch/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param outboundRequests &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_put_outbound_request_batch
connectcampaignservicev2_put_outbound_request_batch <- function(id, outboundRequests) {
  op <- new_operation(
    name = "PutOutboundRequestBatch",
    http_method = "PUT",
    http_path = "/v2/campaigns/{id}/outbound-requests",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$put_outbound_request_batch_input(id = id, outboundRequests = outboundRequests)
  output <- .connectcampaignservicev2$put_outbound_request_batch_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$put_outbound_request_batch <- connectcampaignservicev2_put_outbound_request_batch

#' Takes in a list of profile outbound requests to be placed as part of an
#' outbound campaign
#'
#' @description
#' Takes in a list of profile outbound requests to be placed as part of an outbound campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_profile_outbound_request_batch/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_put_profile_outbound_request_batch/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param profileOutboundRequests &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_put_profile_outbound_request_batch
connectcampaignservicev2_put_profile_outbound_request_batch <- function(id, profileOutboundRequests) {
  op <- new_operation(
    name = "PutProfileOutboundRequestBatch",
    http_method = "PUT",
    http_path = "/v2/campaigns/{id}/profile-outbound-requests",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$put_profile_outbound_request_batch_input(id = id, profileOutboundRequests = profileOutboundRequests)
  output <- .connectcampaignservicev2$put_profile_outbound_request_batch_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$put_profile_outbound_request_batch <- connectcampaignservicev2_put_profile_outbound_request_batch

#' Stops a campaign for the specified Amazon Connect account
#'
#' @description
#' Stops a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_resume_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_resume_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_resume_campaign
connectcampaignservicev2_resume_campaign <- function(id) {
  op <- new_operation(
    name = "ResumeCampaign",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/resume",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$resume_campaign_input(id = id)
  output <- .connectcampaignservicev2$resume_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$resume_campaign <- connectcampaignservicev2_resume_campaign

#' Starts a campaign for the specified Amazon Connect account
#'
#' @description
#' Starts a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_start_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_start_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_start_campaign
connectcampaignservicev2_start_campaign <- function(id) {
  op <- new_operation(
    name = "StartCampaign",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/start",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$start_campaign_input(id = id)
  output <- .connectcampaignservicev2$start_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$start_campaign <- connectcampaignservicev2_start_campaign

#' Onboard the specific Amazon Connect instance to Connect Campaigns
#'
#' @description
#' Onboard the specific Amazon Connect instance to Connect Campaigns.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_start_instance_onboarding_job/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_start_instance_onboarding_job/) for full documentation.
#'
#' @param connectInstanceId &#91;required&#93; 
#' @param encryptionConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_start_instance_onboarding_job
connectcampaignservicev2_start_instance_onboarding_job <- function(connectInstanceId, encryptionConfig) {
  op <- new_operation(
    name = "StartInstanceOnboardingJob",
    http_method = "PUT",
    http_path = "/v2/connect-instance/{connectInstanceId}/onboarding",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$start_instance_onboarding_job_input(connectInstanceId = connectInstanceId, encryptionConfig = encryptionConfig)
  output <- .connectcampaignservicev2$start_instance_onboarding_job_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$start_instance_onboarding_job <- connectcampaignservicev2_start_instance_onboarding_job

#' Stops a campaign for the specified Amazon Connect account
#'
#' @description
#' Stops a campaign for the specified Amazon Connect account.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_stop_campaign/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_stop_campaign/) for full documentation.
#'
#' @param id &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_stop_campaign
connectcampaignservicev2_stop_campaign <- function(id) {
  op <- new_operation(
    name = "StopCampaign",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/stop",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$stop_campaign_input(id = id)
  output <- .connectcampaignservicev2$stop_campaign_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$stop_campaign <- connectcampaignservicev2_stop_campaign

#' Tag a resource
#'
#' @description
#' Tag a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_tag_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_tag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#' @param tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_tag_resource
connectcampaignservicev2_tag_resource <- function(arn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v2/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$tag_resource_input(arn = arn, tags = tags)
  output <- .connectcampaignservicev2$tag_resource_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$tag_resource <- connectcampaignservicev2_tag_resource

#' Untag a resource
#'
#' @description
#' Untag a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_untag_resource/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_untag_resource/) for full documentation.
#'
#' @param arn &#91;required&#93; 
#' @param tagKeys &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_untag_resource
connectcampaignservicev2_untag_resource <- function(arn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v2/tags/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$untag_resource_input(arn = arn, tagKeys = tagKeys)
  output <- .connectcampaignservicev2$untag_resource_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$untag_resource <- connectcampaignservicev2_untag_resource

#' Updates the channel subtype config of a campaign
#'
#' @description
#' Updates the channel subtype config of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_channel_subtype_config/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_channel_subtype_config/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param channelSubtypeConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_upda_camp_chan_subt_conf
connectcampaignservicev2_update_campaign_channel_subtype_config <- function(id, channelSubtypeConfig) {
  op <- new_operation(
    name = "UpdateCampaignChannelSubtypeConfig",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/channel-subtype-config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_channel_subtype_config_input(id = id, channelSubtypeConfig = channelSubtypeConfig)
  output <- .connectcampaignservicev2$update_campaign_channel_subtype_config_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_channel_subtype_config <- connectcampaignservicev2_update_campaign_channel_subtype_config

#' Updates the communication limits config for a campaign
#'
#' @description
#' Updates the communication limits config for a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_communication_limits/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_communication_limits/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param communicationLimitsOverride &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_updat_campa_commu_limit
connectcampaignservicev2_update_campaign_communication_limits <- function(id, communicationLimitsOverride) {
  op <- new_operation(
    name = "UpdateCampaignCommunicationLimits",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/communication-limits",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_communication_limits_input(id = id, communicationLimitsOverride = communicationLimitsOverride)
  output <- .connectcampaignservicev2$update_campaign_communication_limits_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_communication_limits <- connectcampaignservicev2_update_campaign_communication_limits

#' Updates the communication time config for a campaign
#'
#' @description
#' Updates the communication time config for a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_communication_time/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_communication_time/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param communicationTimeConfig &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_update_campaign_communication_time
connectcampaignservicev2_update_campaign_communication_time <- function(id, communicationTimeConfig) {
  op <- new_operation(
    name = "UpdateCampaignCommunicationTime",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/communication-time",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_communication_time_input(id = id, communicationTimeConfig = communicationTimeConfig)
  output <- .connectcampaignservicev2$update_campaign_communication_time_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_communication_time <- connectcampaignservicev2_update_campaign_communication_time

#' Updates the campaign flow associated with a campaign
#'
#' @description
#' Updates the campaign flow associated with a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_flow_association/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_flow_association/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param connectCampaignFlowArn &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_update_campaign_flow_association
connectcampaignservicev2_update_campaign_flow_association <- function(id, connectCampaignFlowArn) {
  op <- new_operation(
    name = "UpdateCampaignFlowAssociation",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/flow",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_flow_association_input(id = id, connectCampaignFlowArn = connectCampaignFlowArn)
  output <- .connectcampaignservicev2$update_campaign_flow_association_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_flow_association <- connectcampaignservicev2_update_campaign_flow_association

#' Updates the name of a campaign
#'
#' @description
#' Updates the name of a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_name/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_name/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param name &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_update_campaign_name
connectcampaignservicev2_update_campaign_name <- function(id, name) {
  op <- new_operation(
    name = "UpdateCampaignName",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/name",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_name_input(id = id, name = name)
  output <- .connectcampaignservicev2$update_campaign_name_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_name <- connectcampaignservicev2_update_campaign_name

#' Updates the schedule for a campaign
#'
#' @description
#' Updates the schedule for a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_schedule/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_schedule/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param schedule &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_update_campaign_schedule
connectcampaignservicev2_update_campaign_schedule <- function(id, schedule) {
  op <- new_operation(
    name = "UpdateCampaignSchedule",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/schedule",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_schedule_input(id = id, schedule = schedule)
  output <- .connectcampaignservicev2$update_campaign_schedule_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_schedule <- connectcampaignservicev2_update_campaign_schedule

#' Updates the campaign source with a campaign
#'
#' @description
#' Updates the campaign source with a campaign. This API is idempotent.
#'
#' See [https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_source/](https://www.paws-r-sdk.com/docs/connectcampaignservicev2_update_campaign_source/) for full documentation.
#'
#' @param id &#91;required&#93; 
#' @param source &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname connectcampaignservicev2_update_campaign_source
connectcampaignservicev2_update_campaign_source <- function(id, source) {
  op <- new_operation(
    name = "UpdateCampaignSource",
    http_method = "POST",
    http_path = "/v2/campaigns/{id}/source",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .connectcampaignservicev2$update_campaign_source_input(id = id, source = source)
  output <- .connectcampaignservicev2$update_campaign_source_output()
  config <- get_config()
  svc <- .connectcampaignservicev2$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.connectcampaignservicev2$operations$update_campaign_source <- connectcampaignservicev2_update_campaign_source
