% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_email_contact}
\alias{connect_start_email_contact}
\title{Creates an inbound email contact and initiates a flow to start the email
contact for the customer}
\usage{
connect_start_email_contact(
  InstanceId,
  FromEmailAddress,
  DestinationEmailAddress,
  Description = NULL,
  References = NULL,
  Name = NULL,
  EmailMessage,
  AdditionalRecipients = NULL,
  Attachments = NULL,
  ContactFlowId = NULL,
  RelatedContactId = NULL,
  Attributes = NULL,
  SegmentAttributes = NULL,
  ClientToken = NULL
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{FromEmailAddress}{[required] The email address of the customer.}

\item{DestinationEmailAddress}{[required] The email address associated with the instance.}

\item{Description}{A description of the email contact.}

\item{References}{A formatted URL that is shown to an agent in the Contact Control Panel
(CCP). Emails can have the following reference types at the time of
creation: \code{URL} | \code{NUMBER} | \code{STRING} | \code{DATE}. \code{EMAIL} |
\code{EMAIL_MESSAGE} |\code{ATTACHMENT} are not a supported reference type during
email creation.}

\item{Name}{The name of a email that is shown to an agent in the Contact Control
Panel (CCP).}

\item{EmailMessage}{[required] The email message body to be sent to the newly created email.}

\item{AdditionalRecipients}{The addtional recipients address of the email.}

\item{Attachments}{List of S3 presigned URLs of email attachments and their file name.}

\item{ContactFlowId}{The identifier of the flow for initiating the emails. To see the
ContactFlowId in the Amazon Connect admin website, on the navigation
menu go to \strong{Routing}, \strong{Flows}. Choose the flow. On the flow page,
under the name of the flow, choose \strong{Show additional flow information}.
The ContactFlowId is the last part of the ARN, shown here in bold:

arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/\strong{846ec553-a005-41c0-8341-xxxxxxxxxxxx}}

\item{RelatedContactId}{The contactId that is related to this contact. Linking emails together
by using \code{RelatedContactID} copies over contact attributes from the
related email contact to the new email contact. All updates to
user-defined attributes in the new email contact are limited to the
individual contact ID. There are no limits to the number of contacts
that can be linked by using \code{RelatedContactId}.}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in flows just
like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{SegmentAttributes}{A set of system defined key-value pairs stored on individual contact
segments using an attribute map. The attributes are standard Amazon
Connect attributes. They can be accessed in flows.

Attribute keys can include only alphanumeric, -, and _.

This field can be used to show channel subtype, such as \code{connect:Guide}.

To set contact expiry, a \code{ValueMap} must be specified containing the
integer number of minutes the contact will be active for before
expiring, with \code{SegmentAttributes} like \{
\verb{ "connect:ContactExpiry": \\\{"ValueMap" : \\\{ "ExpiryDuration": \\\{ "ValueInteger":135\\\}\\\}\\\}\\\}}.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}
}
\description{
Creates an inbound email contact and initiates a flow to start the email contact for the customer. Response of this API provides the ContactId of the email contact created.

See \url{https://www.paws-r-sdk.com/docs/connect_start_email_contact/} for full documentation.
}
\keyword{internal}
