% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customerprofiles_operations.R
\name{customerprofiles_create_profile}
\alias{customerprofiles_create_profile}
\title{Creates a standard profile}
\usage{
customerprofiles_create_profile(
  DomainName,
  AccountNumber = NULL,
  AdditionalInformation = NULL,
  PartyType = NULL,
  BusinessName = NULL,
  FirstName = NULL,
  MiddleName = NULL,
  LastName = NULL,
  BirthDate = NULL,
  Gender = NULL,
  PhoneNumber = NULL,
  MobilePhoneNumber = NULL,
  HomePhoneNumber = NULL,
  BusinessPhoneNumber = NULL,
  EmailAddress = NULL,
  PersonalEmailAddress = NULL,
  BusinessEmailAddress = NULL,
  Address = NULL,
  ShippingAddress = NULL,
  MailingAddress = NULL,
  BillingAddress = NULL,
  Attributes = NULL,
  PartyTypeString = NULL,
  GenderString = NULL
)
}
\arguments{
\item{DomainName}{[required] The unique name of the domain.}

\item{AccountNumber}{An account number that you have given to the customer.}

\item{AdditionalInformation}{Any additional information relevant to the customer’s profile.}

\item{PartyType}{The type of profile used to describe the customer.}

\item{BusinessName}{The name of the customer’s business.}

\item{FirstName}{The customer’s first name.}

\item{MiddleName}{The customer’s middle name.}

\item{LastName}{The customer’s last name.}

\item{BirthDate}{The customer’s birth date.}

\item{Gender}{The gender with which the customer identifies.}

\item{PhoneNumber}{The customer’s phone number, which has not been specified as a mobile,
home, or business number.}

\item{MobilePhoneNumber}{The customer’s mobile phone number.}

\item{HomePhoneNumber}{The customer’s home phone number.}

\item{BusinessPhoneNumber}{The customer’s business phone number.}

\item{EmailAddress}{The customer’s email address, which has not been specified as a personal
or business address.}

\item{PersonalEmailAddress}{The customer’s personal email address.}

\item{BusinessEmailAddress}{The customer’s business email address.}

\item{Address}{A generic address associated with the customer that is not mailing,
shipping, or billing.}

\item{ShippingAddress}{The customer’s shipping address.}

\item{MailingAddress}{The customer’s mailing address.}

\item{BillingAddress}{The customer’s billing address.}

\item{Attributes}{A key value pair of attributes of a customer profile.}

\item{PartyTypeString}{An alternative to \code{PartyType} which accepts any string as input.}

\item{GenderString}{An alternative to \code{Gender} which accepts any string as input.}
}
\description{
Creates a standard profile.

See \url{https://www.paws-r-sdk.com/docs/customerprofiles_create_profile/} for full documentation.
}
\keyword{internal}
