% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticache_operations.R
\name{elasticache_list_allowed_node_type_modifications}
\alias{elasticache_list_allowed_node_type_modifications}
\title{Lists all available node types that you can scale your Redis cluster's
or replication group's current node type}
\usage{
elasticache_list_allowed_node_type_modifications(CacheClusterId,
  ReplicationGroupId)
}
\arguments{
\item{CacheClusterId}{The name of the cluster you want to scale up to a larger node instanced
type. ElastiCache uses the cluster id to identify the current node type
of this cluster and from that to create a list of node types you can
scale up to.

You must provide a value for either the \code{CacheClusterId} or the
\code{ReplicationGroupId}.}

\item{ReplicationGroupId}{The name of the replication group want to scale up to a larger node
type. ElastiCache uses the replication group id to identify the current
node type being used by this replication group, and from that to create
a list of node types you can scale up to.

You must provide a value for either the \code{CacheClusterId} or the
\code{ReplicationGroupId}.}
}
\description{
Lists all available node types that you can scale your Redis cluster's
or replication group's current node type.

When you use the \code{ModifyCacheCluster} or \code{ModifyReplicationGroup}
operations to scale your cluster or replication group, the value of the
\code{CacheNodeType} parameter must be one of the node types returned by this
operation.
}
\section{Request syntax}{
\preformatted{svc$list_allowed_node_type_modifications(
  CacheClusterId = "string",
  ReplicationGroupId = "string"
)
}
}

\keyword{internal}
