% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdb_operations.R
\name{docdb_delete_db_cluster}
\alias{docdb_delete_db_cluster}
\title{Deletes a previously provisioned cluster}
\usage{
docdb_delete_db_cluster(DBClusterIdentifier, SkipFinalSnapshot,
  FinalDBSnapshotIdentifier)
}
\arguments{
\item{DBClusterIdentifier}{[required] The cluster identifier for the cluster to be deleted. This parameter
isn't case sensitive.

Constraints:
\itemize{
\item Must match an existing \code{DBClusterIdentifier}.
}}

\item{SkipFinalSnapshot}{Determines whether a final cluster snapshot is created before the
cluster is deleted. If \code{true} is specified, no cluster snapshot is
created. If \code{false} is specified, a cluster snapshot is created before
the DB cluster is deleted.

If \code{SkipFinalSnapshot} is \code{false}, you must specify a
\code{FinalDBSnapshotIdentifier} parameter.

Default: \code{false}}

\item{FinalDBSnapshotIdentifier}{The cluster snapshot identifier of the new cluster snapshot created when
\code{SkipFinalSnapshot} is set to \code{false}.

Specifying this parameter and also setting the \code{SkipFinalShapshot}
parameter to \code{true} results in an error.

Constraints:
\itemize{
\item Must be from 1 to 255 letters, numbers, or hyphens.
\item The first character must be a letter.
\item Cannot end with a hyphen or contain two consecutive hyphens.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  DBCluster = list(
    AvailabilityZones = list(
      "string"
    ),
    BackupRetentionPeriod = 123,
    DBClusterIdentifier = "string",
    DBClusterParameterGroup = "string",
    DBSubnetGroup = "string",
    Status = "string",
    PercentProgress = "string",
    EarliestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Endpoint = "string",
    ReaderEndpoint = "string",
    MultiAZ = TRUE|FALSE,
    Engine = "string",
    EngineVersion = "string",
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    Port = 123,
    MasterUsername = "string",
    PreferredBackupWindow = "string",
    PreferredMaintenanceWindow = "string",
    DBClusterMembers = list(
      list(
        DBInstanceIdentifier = "string",
        IsClusterWriter = TRUE|FALSE,
        DBClusterParameterGroupStatus = "string",
        PromotionTier = 123
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    HostedZoneId = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbClusterResourceId = "string",
    DBClusterArn = "string",
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        Status = "string"
      )
    ),
    ClusterCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    DeletionProtection = TRUE|FALSE
  )
)
}
}
\description{
Deletes a previously provisioned cluster. When you delete a cluster, all
automated backups for that cluster are deleted and can't be recovered.
Manual DB cluster snapshots of the specified cluster are not deleted.
}
\section{Request syntax}{
\preformatted{svc$delete_db_cluster(
  DBClusterIdentifier = "string",
  SkipFinalSnapshot = TRUE|FALSE,
  FinalDBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
