% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_describe_snapshot_schedules}
\alias{redshift_describe_snapshot_schedules}
\title{Returns a list of snapshot schedules}
\usage{
redshift_describe_snapshot_schedules(ClusterIdentifier,
  ScheduleIdentifier, TagKeys, TagValues, Marker, MaxRecords)
}
\arguments{
\item{ClusterIdentifier}{The unique identifier for the cluster whose snapshot schedules you want
to view.}

\item{ScheduleIdentifier}{A unique identifier for a snapshot schedule.}

\item{TagKeys}{The key value for a snapshot schedule tag.}

\item{TagValues}{The value corresponding to the key of the snapshot schedule tag.}

\item{Marker}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
marker value in the \code{marker} parameter and retrying the command. If the
\code{marker} field is empty, all response records have been retrieved for
the request.}

\item{MaxRecords}{The maximum number or response records to return in each call. If the
number of remaining response records exceeds the specified \code{MaxRecords}
value, a value is returned in a \code{marker} field of the response. You can
retrieve the next set of records by retrying the command with the
returned \code{marker} value.}
}
\value{
A list with the following syntax:\preformatted{list(
  SnapshotSchedules = list(
    list(
      ScheduleDefinitions = list(
        "string"
      ),
      ScheduleIdentifier = "string",
      ScheduleDescription = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      NextInvocations = list(
        as.POSIXct(
          "2015-01-01"
        )
      ),
      AssociatedClusterCount = 123,
      AssociatedClusters = list(
        list(
          ClusterIdentifier = "string",
          ScheduleAssociationState = "MODIFYING"|"ACTIVE"|"FAILED"
        )
      )
    )
  ),
  Marker = "string"
)
}
}
\description{
Returns a list of snapshot schedules.
}
\section{Request syntax}{
\preformatted{svc$describe_snapshot_schedules(
  ClusterIdentifier = "string",
  ScheduleIdentifier = "string",
  TagKeys = list(
    "string"
  ),
  TagValues = list(
    "string"
  ),
  Marker = "string",
  MaxRecords = 123
)
}
}

\keyword{internal}
