% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_from_db_snapshot}
\alias{rds_restore_db_instance_from_db_snapshot}
\title{Creates a new DB instance from a DB snapshot}
\usage{
rds_restore_db_instance_from_db_snapshot(DBInstanceIdentifier,
  DBSnapshotIdentifier, DBInstanceClass, Port, AvailabilityZone,
  DBSubnetGroupName, MultiAZ, PubliclyAccessible, AutoMinorVersionUpgrade,
  LicenseModel, DBName, Engine, Iops, OptionGroupName, Tags, StorageType,
  TdeCredentialArn, TdeCredentialPassword, VpcSecurityGroupIds, Domain,
  CopyTagsToSnapshot, DomainIAMRoleName, EnableIAMDatabaseAuthentication,
  EnableCloudwatchLogsExports, ProcessorFeatures,
  UseDefaultProcessorFeatures, DBParameterGroupName, DeletionProtection,
  EnableCustomerOwnedIp)
}
\arguments{
\item{DBInstanceIdentifier}{[required] Name of the DB instance to create from the DB snapshot. This parameter
isn't case-sensitive.

Constraints:
\itemize{
\item Must contain from 1 to 63 numbers, letters, or hyphens
\item First character must be a letter
\item Can't end with a hyphen or contain two consecutive hyphens
}

Example: \code{my-snapshot-id}}

\item{DBSnapshotIdentifier}{[required] The identifier for the DB snapshot to restore from.

Constraints:
\itemize{
\item Must match the identifier of an existing DBSnapshot.
\item If you are restoring from a shared manual DB snapshot, the
\code{DBSnapshotIdentifier} must be the ARN of the shared DB snapshot.
}}

\item{DBInstanceClass}{The compute and memory capacity of the Amazon RDS DB instance, for
example, \code{db.m4.large}. Not all DB instance classes are available in all
AWS Regions, or for all database engines. For the full list of DB
instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Default: The same DBInstanceClass as the original DB instance.}

\item{Port}{The port number on which the database accepts connections.

Default: The same port as the original DB instance

Constraints: Value must be \code{1150-65535}}

\item{AvailabilityZone}{The Availability Zone (AZ) where the DB instance will be created.

Default: A random, system-chosen Availability Zone.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.

Example: \verb{us-east-1a}}

\item{DBSubnetGroupName}{The DB subnet group name to use for the new instance.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mySubnetgroup}}

\item{MultiAZ}{A value that indicates whether the DB instance is a Multi-AZ deployment.

Constraint: You can't specify the \code{AvailabilityZone} parameter if the DB
instance is a Multi-AZ deployment.}

\item{PubliclyAccessible}{A value that indicates whether the DB instance is publicly accessible.

When the DB instance is publicly accessible, its DNS endpoint resolves
to the private IP address from within the DB instance's VPC, and to the
public IP address from outside of the DB instance's VPC. Access to the
DB instance is ultimately controlled by the security group it uses, and
that public access is not permitted if the security group assigned to
the DB instance doesn't permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{AutoMinorVersionUpgrade}{A value that indicates whether minor version upgrades are applied
automatically to the DB instance during the maintenance window.}

\item{LicenseModel}{License model information for the restored DB instance.

Default: Same as source.

Valid values: \code{license-included} | \code{bring-your-own-license} |
\code{general-public-license}}

\item{DBName}{The database name for the restored DB instance.

This parameter doesn't apply to the MySQL, PostgreSQL, or MariaDB
engines.}

\item{Engine}{The database engine to use for the new instance.

Default: The same as source

Constraint: Must be compatible with the engine of the source. For
example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6
snapshot.

Valid Values:
\itemize{
\item \code{mariadb}
\item \code{mysql}
\item \code{oracle-ee}
\item \code{oracle-se2}
\item \code{oracle-se1}
\item \code{oracle-se}
\item \code{postgres}
\item \code{sqlserver-ee}
\item \code{sqlserver-se}
\item \code{sqlserver-ex}
\item \code{sqlserver-web}
}}

\item{Iops}{Specifies the amount of provisioned IOPS for the DB instance, expressed
in I/O operations per second. If this parameter isn't specified, the
IOPS value is taken from the backup. If this parameter is set to 0, the
new instance is converted to a non-PIOPS instance. The conversion takes
additional time, though your DB instance is available for connections
before the conversion starts.

The provisioned IOPS value must follow the requirements for your
database engine. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS Storage to Improve Performance}
in the \emph{Amazon RDS User Guide.}

Constraints: Must be an integer greater than 1000.}

\item{OptionGroupName}{The name of the option group to be used for the restored DB instance.

Permanent options, such as the TDE option for Oracle Advanced Security
TDE, can't be removed from an option group, and that option group can't
be removed from a DB instance once it is associated with a DB instance}

\item{Tags}{}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid values: \code{standard | gp2 | io1}

If you specify \code{io1}, you must also include a value for the \code{Iops}
parameter.

Default: \code{io1} if the \code{Iops} parameter is specified, otherwise \code{gp2}}

\item{TdeCredentialArn}{The ARN from the key store with which to associate the instance for TDE
encryption.}

\item{TdeCredentialPassword}{The password for the given ARN from the key store in order to access the
device.}

\item{VpcSecurityGroupIds}{A list of EC2 VPC security groups to associate with this DB instance.

Default: The default EC2 VPC security group for the DB subnet group's
VPC.}

\item{Domain}{Specify the Active Directory directory ID to restore the DB instance in.
The domain must be created prior to this operation. Currently, only
MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be
created in an Active Directory Domain.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/database-authentication.html}{Kerberos Authentication}
in the \emph{Amazon RDS User Guide}.}

\item{CopyTagsToSnapshot}{A value that indicates whether to copy all tags from the restored DB
instance to snapshots of the DB instance. By default, tags are not
copied.}

\item{DomainIAMRoleName}{Specify the name of the IAM role to be used when making API calls to the
Directory Service.}

\item{EnableIAMDatabaseAuthentication}{A value that indicates whether to enable mapping of AWS Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping is disabled.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{A value that indicates whether the DB instance class of the DB instance
uses its default processor features.}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then the
default \code{DBParameterGroup} for the specified DB engine is used.

Constraints:
\itemize{
\item If supplied, must match the name of an existing DBParameterGroup.
\item Must be 1 to 255 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{DeletionProtection}{A value that indicates whether the DB instance has deletion protection
enabled. The database can't be deleted when deletion protection is
enabled. By default, deletion protection is disabled. For more
information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{EnableCustomerOwnedIp}{A value that indicates whether to enable a customer-owned IP address
(CoIP) for an RDS on Outposts DB instance.

A \emph{CoIP} provides local or external connectivity to resources in your
Outpost subnets through your on-premises network. For some use cases, a
CoIP can provide lower latency for connections to the DB instance from
outside of its virtual private cloud (VPC) on your local network.

For more information about RDS on Outposts, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-on-outposts.html}{Working with Amazon RDS on AWS Outposts}
in the \emph{Amazon RDS User Guide}.

For more information about CoIPs, see \href{https://docs.aws.amazon.com/outposts/latest/userguide/outposts-networking-components.html#ip-addressing}{Customer-owned IP addresses}
in the \emph{AWS Outposts User Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstance = list(
    DBInstanceIdentifier = "string",
    DBInstanceClass = "string",
    Engine = "string",
    DBInstanceStatus = "string",
    MasterUsername = "string",
    DBName = "string",
    Endpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    AllocatedStorage = 123,
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    PreferredBackupWindow = "string",
    BackupRetentionPeriod = 123,
    DBSecurityGroups = list(
      list(
        DBSecurityGroupName = "string",
        Status = "string"
      )
    ),
    VpcSecurityGroups = list(
      list(
        VpcSecurityGroupId = "string",
        Status = "string"
      )
    ),
    DBParameterGroups = list(
      list(
        DBParameterGroupName = "string",
        ParameterApplyStatus = "string"
      )
    ),
    AvailabilityZone = "string",
    DBSubnetGroup = list(
      DBSubnetGroupName = "string",
      DBSubnetGroupDescription = "string",
      VpcId = "string",
      SubnetGroupStatus = "string",
      Subnets = list(
        list(
          SubnetIdentifier = "string",
          SubnetAvailabilityZone = list(
            Name = "string"
          ),
          SubnetOutpost = list(
            Arn = "string"
          ),
          SubnetStatus = "string"
        )
      ),
      DBSubnetGroupArn = "string"
    ),
    PreferredMaintenanceWindow = "string",
    PendingModifiedValues = list(
      DBInstanceClass = "string",
      AllocatedStorage = 123,
      MasterUserPassword = "string",
      Port = 123,
      BackupRetentionPeriod = 123,
      MultiAZ = TRUE|FALSE,
      EngineVersion = "string",
      LicenseModel = "string",
      Iops = 123,
      DBInstanceIdentifier = "string",
      StorageType = "string",
      CACertificateIdentifier = "string",
      DBSubnetGroupName = "string",
      PendingCloudwatchLogsExports = list(
        LogTypesToEnable = list(
          "string"
        ),
        LogTypesToDisable = list(
          "string"
        )
      ),
      ProcessorFeatures = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      IAMDatabaseAuthenticationEnabled = TRUE|FALSE
    ),
    LatestRestorableTime = as.POSIXct(
      "2015-01-01"
    ),
    MultiAZ = TRUE|FALSE,
    EngineVersion = "string",
    AutoMinorVersionUpgrade = TRUE|FALSE,
    ReadReplicaSourceDBInstanceIdentifier = "string",
    ReadReplicaDBInstanceIdentifiers = list(
      "string"
    ),
    ReadReplicaDBClusterIdentifiers = list(
      "string"
    ),
    ReplicaMode = "open-read-only"|"mounted",
    LicenseModel = "string",
    Iops = 123,
    OptionGroupMemberships = list(
      list(
        OptionGroupName = "string",
        Status = "string"
      )
    ),
    CharacterSetName = "string",
    NcharCharacterSetName = "string",
    SecondaryAvailabilityZone = "string",
    PubliclyAccessible = TRUE|FALSE,
    StatusInfos = list(
      list(
        StatusType = "string",
        Normal = TRUE|FALSE,
        Status = "string",
        Message = "string"
      )
    ),
    StorageType = "string",
    TdeCredentialArn = "string",
    DbInstancePort = 123,
    DBClusterIdentifier = "string",
    StorageEncrypted = TRUE|FALSE,
    KmsKeyId = "string",
    DbiResourceId = "string",
    CACertificateIdentifier = "string",
    DomainMemberships = list(
      list(
        Domain = "string",
        Status = "string",
        FQDN = "string",
        IAMRoleName = "string"
      )
    ),
    CopyTagsToSnapshot = TRUE|FALSE,
    MonitoringInterval = 123,
    EnhancedMonitoringResourceArn = "string",
    MonitoringRoleArn = "string",
    PromotionTier = 123,
    DBInstanceArn = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    PerformanceInsightsEnabled = TRUE|FALSE,
    PerformanceInsightsKMSKeyId = "string",
    PerformanceInsightsRetentionPeriod = 123,
    EnabledCloudwatchLogsExports = list(
      "string"
    ),
    ProcessorFeatures = list(
      list(
        Name = "string",
        Value = "string"
      )
    ),
    DeletionProtection = TRUE|FALSE,
    AssociatedRoles = list(
      list(
        RoleArn = "string",
        FeatureName = "string",
        Status = "string"
      )
    ),
    ListenerEndpoint = list(
      Address = "string",
      Port = 123,
      HostedZoneId = "string"
    ),
    MaxAllocatedStorage = 123,
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    DBInstanceAutomatedBackupsReplications = list(
      list(
        DBInstanceAutomatedBackupsArn = "string"
      )
    ),
    CustomerOwnedIpEnabled = TRUE|FALSE
  )
)
}
}
\description{
Creates a new DB instance from a DB snapshot. The target database is
created from the source database restore point with most of the source's
original configuration, including the default security group and DB
parameter group. By default, the new DB instance is created as a
Single-AZ deployment, except when the instance is a SQL Server instance
that has an option group associated with mirroring. In this case, the
instance becomes a Multi-AZ deployment, not a Single-AZ deployment.

If you want to replace your original DB instance with the new, restored
DB instance, then rename your original DB instance before you call the
RestoreDBInstanceFromDBSnapshot action. RDS doesn't allow two DB
instances with the same name. After you have renamed your original DB
instance with a different identifier, then you can pass the original
name of the DB instance as the DBInstanceIdentifier in the call to the
RestoreDBInstanceFromDBSnapshot action. The result is that you replace
the original DB instance with the DB instance created from the snapshot.

If you are restoring from a shared manual DB snapshot, the
\code{DBSnapshotIdentifier} must be the ARN of the shared DB snapshot.

This command doesn't apply to Aurora MySQL and Aurora PostgreSQL. For
Aurora, use
\code{\link[=rds_restore_db_cluster_from_snapshot]{restore_db_cluster_from_snapshot}}.
}
\section{Request syntax}{
\preformatted{svc$restore_db_instance_from_db_snapshot(
  DBInstanceIdentifier = "string",
  DBSnapshotIdentifier = "string",
  DBInstanceClass = "string",
  Port = 123,
  AvailabilityZone = "string",
  DBSubnetGroupName = "string",
  MultiAZ = TRUE|FALSE,
  PubliclyAccessible = TRUE|FALSE,
  AutoMinorVersionUpgrade = TRUE|FALSE,
  LicenseModel = "string",
  DBName = "string",
  Engine = "string",
  Iops = 123,
  OptionGroupName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  StorageType = "string",
  TdeCredentialArn = "string",
  TdeCredentialPassword = "string",
  VpcSecurityGroupIds = list(
    "string"
  ),
  Domain = "string",
  CopyTagsToSnapshot = TRUE|FALSE,
  DomainIAMRoleName = "string",
  EnableIAMDatabaseAuthentication = TRUE|FALSE,
  EnableCloudwatchLogsExports = list(
    "string"
  ),
  ProcessorFeatures = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  UseDefaultProcessorFeatures = TRUE|FALSE,
  DBParameterGroupName = "string",
  DeletionProtection = TRUE|FALSE,
  EnableCustomerOwnedIp = TRUE|FALSE
)
}
}

\keyword{internal}
