% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_stop_db_instance}
\alias{rds_stop_db_instance}
\title{Stops an Amazon RDS DB instance}
\usage{
rds_stop_db_instance(DBInstanceIdentifier, DBSnapshotIdentifier)
}
\arguments{
\item{DBInstanceIdentifier}{[required] The user-supplied instance identifier.}

\item{DBSnapshotIdentifier}{The user-supplied instance identifier of the DB Snapshot created
immediately before the DB instance is stopped.}
}
\description{
Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS
retains the DB instance\'s metadata, including its endpoint, DB
parameter group, and option group membership. Amazon RDS also retains
the transaction logs so you can do a point-in-time restore if necessary.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_StopInstance.html}{Stopping an Amazon RDS DB Instance Temporarily}
in the \emph{Amazon RDS User Guide.}

This command doesn\'t apply to Aurora MySQL and Aurora PostgreSQL. For
Aurora clusters, use \code{StopDBCluster} instead.
}
\section{Request syntax}{
\preformatted{svc$stop_db_instance(
  DBInstanceIdentifier = "string",
  DBSnapshotIdentifier = "string"
)
}
}

\keyword{internal}
