% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_describe_events}
\alias{rds_describe_events}
\title{Returns events related to DB instances, DB clusters, DB parameter
groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS
Proxies for the past 14 days}
\usage{
rds_describe_events(
  SourceIdentifier = NULL,
  SourceType = NULL,
  StartTime = NULL,
  EndTime = NULL,
  Duration = NULL,
  EventCategories = NULL,
  Filters = NULL,
  MaxRecords = NULL,
  Marker = NULL
)
}
\arguments{
\item{SourceIdentifier}{The identifier of the event source for which events are returned. If not
specified, then all sources are included in the response.

Constraints:
\itemize{
\item If \code{SourceIdentifier} is supplied, \code{SourceType} must also be
provided.
\item If the source type is a DB instance, a \code{DBInstanceIdentifier} value
must be supplied.
\item If the source type is a DB cluster, a \code{DBClusterIdentifier} value
must be supplied.
\item If the source type is a DB parameter group, a \code{DBParameterGroupName}
value must be supplied.
\item If the source type is a DB security group, a \code{DBSecurityGroupName}
value must be supplied.
\item If the source type is a DB snapshot, a \code{DBSnapshotIdentifier} value
must be supplied.
\item If the source type is a DB cluster snapshot, a
\code{DBClusterSnapshotIdentifier} value must be supplied.
\item If the source type is an RDS Proxy, a \code{DBProxyName} value must be
supplied.
\item Can't end with a hyphen or contain two consecutive hyphens.
}}

\item{SourceType}{The event source to retrieve events for. If no value is specified, all
events are returned.}

\item{StartTime}{The beginning of the time interval to retrieve events for, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: 2009-07-08T18:00Z}

\item{EndTime}{The end of the time interval for which to retrieve events, specified in
ISO 8601 format. For more information about ISO 8601, go to the \href{https://en.wikipedia.org/wiki/ISO_8601}{ISO8601 Wikipedia page.}

Example: 2009-07-08T18:00Z}

\item{Duration}{The number of minutes to retrieve events for.

Default: 60}

\item{EventCategories}{A list of event categories that trigger notifications for a event
notification subscription.}

\item{Filters}{This parameter isn't currently supported.}

\item{MaxRecords}{The maximum number of records to include in the response. If more
records exist than the specified \code{MaxRecords} value, a pagination token
called a marker is included in the response so that you can retrieve the
remaining results.

Default: 100

Constraints: Minimum 20, maximum 100.}

\item{Marker}{An optional pagination token provided by a previous DescribeEvents
request. If this parameter is specified, the response includes only
records beyond the marker, up to the value specified by \code{MaxRecords}.}
}
\description{
Returns events related to DB instances, DB clusters, DB parameter groups, DB security groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days. Events specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by providing the name as a parameter.

See \url{https://paws-r.github.io/docs/rds/describe_events.html} for full documentation.
}
\keyword{internal}
