% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshiftdataapiservice_operations.R
\name{redshiftdataapiservice_describe_table}
\alias{redshiftdataapiservice_describe_table}
\title{Describes the detailed information about a table from metadata in the
cluster}
\usage{
redshiftdataapiservice_describe_table(
  ClusterIdentifier = NULL,
  ConnectedDatabase = NULL,
  Database,
  DbUser = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  Schema = NULL,
  SecretArn = NULL,
  Table = NULL,
  WorkgroupName = NULL
)
}
\arguments{
\item{ClusterIdentifier}{The cluster identifier. This parameter is required when connecting to a
cluster and authenticating using either Secrets Manager or temporary
credentials.}

\item{ConnectedDatabase}{A database name. The connected database is specified when you connect
with your authentication credentials.}

\item{Database}{[required] The name of the database that contains the tables to be described. If
\code{ConnectedDatabase} is not specified, this is also the database to
connect to with your authentication credentials.}

\item{DbUser}{The database user name. This parameter is required when connecting to a
cluster and authenticating using temporary credentials.}

\item{MaxResults}{The maximum number of tables to return in the response. If more tables
exist than fit in one response, then \code{NextToken} is returned to page
through the results.}

\item{NextToken}{A value that indicates the starting point for the next set of response
records in a subsequent request. If a value is returned in a response,
you can retrieve the next set of records by providing this returned
NextToken value in the next NextToken parameter and retrying the
command. If the NextToken field is empty, all response records have been
retrieved for the request.}

\item{Schema}{The schema that contains the table. If no schema is specified, then
matching tables for all schemas are returned.}

\item{SecretArn}{The name or ARN of the secret that enables access to the database. This
parameter is required when authenticating using Secrets Manager.}

\item{Table}{The table name. If no table is specified, then all tables for all
matching schemas are returned. If no table and no schema is specified,
then all tables for all schemas in the database are returned}

\item{WorkgroupName}{The serverless workgroup name. This parameter is required when
connecting to a serverless workgroup and authenticating using either
Secrets Manager or temporary credentials.}
}
\description{
Describes the detailed information about a table from metadata in the cluster. The information includes its columns. A token is returned to page through the column list. Depending on the authorization method, use one of the following combinations of request parameters:

See \url{https://paws-r.github.io/docs/redshiftdataapiservice/describe_table.html} for full documentation.
}
\keyword{internal}
