# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon DocumentDB Elastic Clusters
#'
#' @description
#' The new Amazon Elastic DocumentDB service endpoint.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- docdbelastic(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- docdbelastic()
#' svc$create_cluster(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=docdbelastic_create_cluster]{create_cluster} \tab Creates a new Elastic DocumentDB cluster and returns its Cluster structure\cr
#'  \link[=docdbelastic_create_cluster_snapshot]{create_cluster_snapshot} \tab Creates a snapshot of a cluster\cr
#'  \link[=docdbelastic_delete_cluster]{delete_cluster} \tab Delete a Elastic DocumentDB cluster\cr
#'  \link[=docdbelastic_delete_cluster_snapshot]{delete_cluster_snapshot} \tab Delete a Elastic DocumentDB snapshot\cr
#'  \link[=docdbelastic_get_cluster]{get_cluster} \tab Returns information about a specific Elastic DocumentDB cluster\cr
#'  \link[=docdbelastic_get_cluster_snapshot]{get_cluster_snapshot} \tab Returns information about a specific Elastic DocumentDB snapshot\cr
#'  \link[=docdbelastic_list_clusters]{list_clusters} \tab Returns information about provisioned Elastic DocumentDB clusters\cr
#'  \link[=docdbelastic_list_cluster_snapshots]{list_cluster_snapshots} \tab Returns information about Elastic DocumentDB snapshots for a specified cluster\cr
#'  \link[=docdbelastic_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on a Elastic DocumentDB resource\cr
#'  \link[=docdbelastic_restore_cluster_from_snapshot]{restore_cluster_from_snapshot} \tab Restores a Elastic DocumentDB cluster from a snapshot\cr
#'  \link[=docdbelastic_tag_resource]{tag_resource} \tab Adds metadata tags to a Elastic DocumentDB resource\cr
#'  \link[=docdbelastic_untag_resource]{untag_resource} \tab Removes metadata tags to a Elastic DocumentDB resource\cr
#'  \link[=docdbelastic_update_cluster]{update_cluster} \tab Modifies a Elastic DocumentDB cluster
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname docdbelastic
#' @export
docdbelastic <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .docdbelastic$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.docdbelastic <- list()

.docdbelastic$operations <- list()

.docdbelastic$metadata <- list(
  service_name = "docdbelastic",
  endpoints = list("*" = list(endpoint = "docdb-elastic.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "docdb-elastic.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "docdb-elastic.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "docdb-elastic.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "DocDB Elastic",
  api_version = "2022-11-28",
  signing_name = "docdb-elastic",
  json_version = "1.1",
  target_prefix = ""
)

.docdbelastic$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.docdbelastic$metadata, handlers, config)
}
