% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neptunedata_operations.R
\name{neptunedata_get_sparql_stream}
\alias{neptunedata_get_sparql_stream}
\title{Gets a stream for an RDF graph}
\usage{
neptunedata_get_sparql_stream(
  limit = NULL,
  iteratorType = NULL,
  commitNum = NULL,
  opNum = NULL,
  encoding = NULL
)
}
\arguments{
\item{limit}{Specifies the maximum number of records to return. There is also a size
limit of 10 MB on the response that can't be modified and that takes
precedence over the number of records specified in the \code{limit}
parameter. The response does include a threshold-breaching record if the
10 MB limit was reached.

The range for \code{limit} is 1 to 100,000, with a default of 10.}

\item{iteratorType}{Can be one of:
\itemize{
\item \code{AT_SEQUENCE_NUMBER}   –   Indicates that reading should start from
the event sequence number specified jointly by the \code{commitNum} and
\code{opNum} parameters.
\item \code{AFTER_SEQUENCE_NUMBER}   –   Indicates that reading should start
right after the event sequence number specified jointly by the
\code{commitNum} and \code{opNum} parameters.
\item \code{TRIM_HORIZON}   –   Indicates that reading should start at the last
untrimmed record in the system, which is the oldest unexpired (not
yet deleted) record in the change-log stream.
\item \code{LATEST}   –   Indicates that reading should start at the most
recent record in the system, which is the latest unexpired (not yet
deleted) record in the change-log stream.
}}

\item{commitNum}{The commit number of the starting record to read from the change-log
stream. This parameter is required when \code{iteratorType}
is\code{AT_SEQUENCE_NUMBER} or \code{AFTER_SEQUENCE_NUMBER}, and ignored when
\code{iteratorType} is \code{TRIM_HORIZON} or \code{LATEST}.}

\item{opNum}{The operation sequence number within the specified commit to start
reading from in the change-log stream data. The default is \code{1}.}

\item{encoding}{If set to TRUE, Neptune compresses the response using gzip encoding.}
}
\description{
Gets a stream for an RDF graph.

See \url{https://www.paws-r-sdk.com/docs/neptunedata_get_sparql_stream/} for full documentation.
}
\keyword{internal}
