% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_get_pipeline_execution}
\alias{codepipeline_get_pipeline_execution}
\title{Returns information about an execution of a pipeline, including details
about artifacts, the pipeline execution ID, and the name, version, and
status of the pipeline}
\usage{
codepipeline_get_pipeline_execution(pipelineName, pipelineExecutionId)
}
\arguments{
\item{pipelineName}{[required] The name of the pipeline about which you want to get execution details.}

\item{pipelineExecutionId}{[required] The ID of the pipeline execution about which you want to get execution
details.}
}
\value{
A list with the following syntax:\preformatted{list(
  pipelineExecution = list(
    pipelineName = "string",
    pipelineVersion = 123,
    pipelineExecutionId = "string",
    status = "Cancelled"|"InProgress"|"Stopped"|"Stopping"|"Succeeded"|"Superseded"|"Failed",
    statusSummary = "string",
    artifactRevisions = list(
      list(
        name = "string",
        revisionId = "string",
        revisionChangeIdentifier = "string",
        revisionSummary = "string",
        created = as.POSIXct(
          "2015-01-01"
        ),
        revisionUrl = "string"
      )
    )
  )
)
}
}
\description{
Returns information about an execution of a pipeline, including details
about artifacts, the pipeline execution ID, and the name, version, and
status of the pipeline.
}
\section{Request syntax}{
\preformatted{svc$get_pipeline_execution(
  pipelineName = "string",
  pipelineExecutionId = "string"
)
}
}

\keyword{internal}
