% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_create_fleet}
\alias{codebuild_create_fleet}
\title{Creates a compute fleet}
\usage{
codebuild_create_fleet(
  name,
  baseCapacity,
  environmentType,
  computeType,
  scalingConfiguration = NULL,
  overflowBehavior = NULL,
  vpcConfig = NULL,
  imageId = NULL,
  fleetServiceRole = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name of the compute fleet.}

\item{baseCapacity}{[required] The initial number of machines allocated to the ﬂeet, which defines the
number of builds that can run in parallel.}

\item{environmentType}{[required] The environment type of the compute fleet.
\itemize{
\item The environment type \code{ARM_CONTAINER} is available only in regions US
East (N. Virginia), US East (Ohio), US West (Oregon), EU (Ireland),
Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
(Singapore), Asia Pacific (Sydney), EU (Frankfurt), and South
America (São Paulo).
\item The environment type \code{LINUX_CONTAINER} is available only in regions
US East (N. Virginia), US East (Ohio), US West (Oregon), EU
(Ireland), EU (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
(Singapore), Asia Pacific (Sydney), South America (São Paulo), and
Asia Pacific (Mumbai).
\item The environment type \code{LINUX_GPU_CONTAINER} is available only in
regions US East (N. Virginia), US East (Ohio), US West (Oregon), EU
(Ireland), EU (Frankfurt), Asia Pacific (Tokyo), and Asia Pacific
(Sydney).
\item The environment type \code{MAC_ARM} is available for Medium fleets only
in regions US East (N. Virginia), US East (Ohio), US West (Oregon),
Asia Pacific (Sydney), and EU (Frankfurt)
\item The environment type \code{MAC_ARM} is available for Large fleets only in
regions US East (N. Virginia), US East (Ohio), US West (Oregon), and
Asia Pacific (Sydney).
\item The environment type \code{WINDOWS_SERVER_2019_CONTAINER} is available
only in regions US East (N. Virginia), US East (Ohio), US West
(Oregon), Asia Pacific (Sydney), Asia Pacific (Tokyo), Asia Pacific
(Mumbai) and EU (Ireland).
\item The environment type \code{WINDOWS_SERVER_2022_CONTAINER} is available
only in regions US East (N. Virginia), US East (Ohio), US West
(Oregon), EU (Ireland), EU (Frankfurt), Asia Pacific (Sydney), Asia
Pacific (Singapore), Asia Pacific (Tokyo), South America (São Paulo)
and Asia Pacific (Mumbai).
}

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html}{Build environment compute types}
in the \emph{CodeBuild user guide}.}

\item{computeType}{[required] Information about the compute resources the compute fleet uses.
Available values include:
\itemize{
\item \code{BUILD_GENERAL1_SMALL}: Use up to 3 GB memory and 2 vCPUs for
builds.
\item \code{BUILD_GENERAL1_MEDIUM}: Use up to 7 GB memory and 4 vCPUs for
builds.
\item \code{BUILD_GENERAL1_LARGE}: Use up to 16 GB memory and 8 vCPUs for
builds, depending on your environment type.
\item \code{BUILD_GENERAL1_XLARGE}: Use up to 70 GB memory and 36 vCPUs for
builds, depending on your environment type.
\item \code{BUILD_GENERAL1_2XLARGE}: Use up to 145 GB memory, 72 vCPUs, and 824
GB of SSD storage for builds. This compute type supports Docker
images up to 100 GB uncompressed.
}

If you use \code{BUILD_GENERAL1_SMALL}:
\itemize{
\item For environment type \code{LINUX_CONTAINER}, you can use up to 3 GB
memory and 2 vCPUs for builds.
\item For environment type \code{LINUX_GPU_CONTAINER}, you can use up to 16 GB
memory, 4 vCPUs, and 1 NVIDIA A10G Tensor Core GPU for builds.
\item For environment type \code{ARM_CONTAINER}, you can use up to 4 GB memory
and 2 vCPUs on ARM-based processors for builds.
}

If you use \code{BUILD_GENERAL1_LARGE}:
\itemize{
\item For environment type \code{LINUX_CONTAINER}, you can use up to 15 GB
memory and 8 vCPUs for builds.
\item For environment type \code{LINUX_GPU_CONTAINER}, you can use up to 255 GB
memory, 32 vCPUs, and 4 NVIDIA Tesla V100 GPUs for builds.
\item For environment type \code{ARM_CONTAINER}, you can use up to 16 GB memory
and 8 vCPUs on ARM-based processors for builds.
}

For more information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html}{Build environment compute types}
in the \emph{CodeBuild User Guide.}}

\item{scalingConfiguration}{The scaling configuration of the compute fleet.}

\item{overflowBehavior}{The compute fleet overflow behavior.
\itemize{
\item For overflow behavior \code{QUEUE}, your overflow builds need to wait on
the existing fleet instance to become available.
\item For overflow behavior \code{ON_DEMAND}, your overflow builds run on
CodeBuild on-demand.

If you choose to set your overflow behavior to on-demand while
creating a VPC-connected fleet, make sure that you add the required
VPC permissions to your project service role. For more information,
see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-create-vpc-network-interface}{Example policy statement to allow CodeBuild access to Amazon Web Services services required to create a VPC network interface}.
}}

\item{vpcConfig}{}

\item{imageId}{The Amazon Machine Image (AMI) of the compute fleet.}

\item{fleetServiceRole}{The service role associated with the compute fleet. For more
information, see \href{https://docs.aws.amazon.com/codebuild/latest/userguide/auth-and-access-control-iam-identity-based-access-control.html#customer-managed-policies-example-permission-policy-fleet-service-role.html}{Allow a user to add a permission policy for a fleet service role}
in the \emph{CodeBuild User Guide}.}

\item{tags}{A list of tag key and value pairs associated with this compute fleet.

These tags are available for use by Amazon Web Services services that
support CodeBuild build project tags.}
}
\description{
Creates a compute fleet.

See \url{https://www.paws-r-sdk.com/docs/codebuild_create_fleet/} for full documentation.
}
\keyword{internal}
