% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_describe_groups}
\alias{workdocs_describe_groups}
\title{Describes the groups specified by the query}
\usage{
workdocs_describe_groups(AuthenticationToken, SearchQuery,
  OrganizationId, Marker, Limit)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{SearchQuery}{[required] A query to describe groups by group name.}

\item{OrganizationId}{The ID of the organization.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{Limit}{The maximum number of items to return with this call.}
}
\value{
A list with the following syntax:\preformatted{list(
  Groups = list(
    list(
      Id = "string",
      Name = "string"
    )
  ),
  Marker = "string"
)
}
}
\description{
Describes the groups specified by the query. Groups are defined by the
underlying Active Directory.
}
\section{Request syntax}{
\preformatted{svc$describe_groups(
  AuthenticationToken = "string",
  SearchQuery = "string",
  OrganizationId = "string",
  Marker = "string",
  Limit = 123
)
}
}

\keyword{internal}
