% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_image_builder}
\alias{appstream_create_image_builder}
\title{Creates an image builder}
\usage{
appstream_create_image_builder(
  Name,
  ImageName = NULL,
  ImageArn = NULL,
  InstanceType,
  Description = NULL,
  DisplayName = NULL,
  VpcConfig = NULL,
  IamRoleArn = NULL,
  EnableDefaultInternetAccess = NULL,
  DomainJoinInfo = NULL,
  AppstreamAgentVersion = NULL,
  Tags = NULL,
  AccessEndpoints = NULL
)
}
\arguments{
\item{Name}{[required] A unique name for the image builder.}

\item{ImageName}{The name of the image used to create the image builder.}

\item{ImageArn}{The ARN of the public, private, or shared image to use.}

\item{InstanceType}{[required] The instance type to use when launching the image builder. The following
instance types are available:
\itemize{
\item stream.standard.small
\item stream.standard.medium
\item stream.standard.large
\item stream.compute.large
\item stream.compute.xlarge
\item stream.compute.2xlarge
\item stream.compute.4xlarge
\item stream.compute.8xlarge
\item stream.memory.large
\item stream.memory.xlarge
\item stream.memory.2xlarge
\item stream.memory.4xlarge
\item stream.memory.8xlarge
\item stream.memory.z1d.large
\item stream.memory.z1d.xlarge
\item stream.memory.z1d.2xlarge
\item stream.memory.z1d.3xlarge
\item stream.memory.z1d.6xlarge
\item stream.memory.z1d.12xlarge
\item stream.graphics-design.large
\item stream.graphics-design.xlarge
\item stream.graphics-design.2xlarge
\item stream.graphics-design.4xlarge
\item stream.graphics-desktop.2xlarge
\item stream.graphics.g4dn.xlarge
\item stream.graphics.g4dn.2xlarge
\item stream.graphics.g4dn.4xlarge
\item stream.graphics.g4dn.8xlarge
\item stream.graphics.g4dn.12xlarge
\item stream.graphics.g4dn.16xlarge
\item stream.graphics-pro.4xlarge
\item stream.graphics-pro.8xlarge
\item stream.graphics-pro.16xlarge
}}

\item{Description}{The description to display.}

\item{DisplayName}{The image builder name to display.}

\item{VpcConfig}{The VPC configuration for the image builder. You can specify only one
subnet.}

\item{IamRoleArn}{The Amazon Resource Name (ARN) of the IAM role to apply to the image
builder. To assume a role, the image builder calls the AWS Security
Token Service (STS) \code{AssumeRole} API operation and passes the ARN of the
role to use. The operation creates a new session with temporary
credentials. AppStream 2.0 retrieves the temporary credentials and
creates the \strong{appstream_machine_role} credential profile on the
instance.

For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html}{Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming Instances}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{EnableDefaultInternetAccess}{Enables or disables default internet access for the image builder.}

\item{DomainJoinInfo}{The name of the directory and organizational unit (OU) to use to join
the image builder to a Microsoft Active Directory domain.}

\item{AppstreamAgentVersion}{The version of the AppStream 2.0 agent to use for this image builder. To
use the latest version of the AppStream 2.0 agent, specify [LATEST].}

\item{Tags}{The tags to associate with the image builder. A tag is a key-value pair,
and the value is optional. For example, Environment=Test. If you do not
specify a value, Environment=.

Generally allowed characters are: letters, numbers, and spaces
representable in UTF-8, and the following special characters:

_ . : / = + \\ - @

If you do not specify a value, the value is set to an empty string.

For more information about tags, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html}{Tagging Your Resources}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{AccessEndpoints}{The list of interface VPC endpoint (interface endpoint) objects.
Administrators can connect to the image builder only through the
specified endpoints.}
}
\description{
Creates an image builder. An image builder is a virtual machine that is used to create an image.

See \url{https://paws-r.github.io/docs/appstream/create_image_builder.html} for full documentation.
}
\keyword{internal}
