% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_auto_ml_jobs}
\alias{sagemaker_list_auto_ml_jobs}
\title{Request a list of jobs}
\usage{
sagemaker_list_auto_ml_jobs(CreationTimeAfter, CreationTimeBefore,
  LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
  StatusEquals, SortOrder, SortBy, MaxResults, NextToken)
}
\arguments{
\item{CreationTimeAfter}{Request a list of jobs, using a filter for time.}

\item{CreationTimeBefore}{Request a list of jobs, using a filter for time.}

\item{LastModifiedTimeAfter}{Request a list of jobs, using a filter for time.}

\item{LastModifiedTimeBefore}{Request a list of jobs, using a filter for time.}

\item{NameContains}{Request a list of jobs, using a search filter for name.}

\item{StatusEquals}{Request a list of jobs, using a filter for status.}

\item{SortOrder}{The sort order for the results. The default is Descending.}

\item{SortBy}{The parameter by which to sort the results. The default is
AutoMLJobName.}

\item{MaxResults}{Request a list of jobs up to a specified limit.}

\item{NextToken}{If the previous response was truncated, you receive this token. Use it
in your next request to receive the next set of results.}
}
\description{
Request a list of jobs.
}
\section{Request syntax}{
\preformatted{svc$list_auto_ml_jobs(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  NameContains = "string",
  StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping",
  SortOrder = "Ascending"|"Descending",
  SortBy = "Name"|"CreationTime"|"Status",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
