% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_describe_action}
\alias{sagemaker_describe_action}
\title{Describes an action}
\usage{
sagemaker_describe_action(ActionName)
}
\arguments{
\item{ActionName}{[required] The name of the action to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  ActionName = "string",
  ActionArn = "string",
  Source = list(
    SourceUri = "string",
    SourceType = "string",
    SourceId = "string"
  ),
  ActionType = "string",
  Description = "string",
  Status = "Unknown"|"InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
  Properties = list(
    "string"
  ),
  CreationTime = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  LastModifiedTime = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedBy = list(
    UserProfileArn = "string",
    UserProfileName = "string",
    DomainId = "string"
  ),
  MetadataProperties = list(
    CommitId = "string",
    Repository = "string",
    GeneratedBy = "string",
    ProjectId = "string"
  )
)
}
}
\description{
Describes an action.
}
\section{Request syntax}{
\preformatted{svc$describe_action(
  ActionName = "string"
)
}
}

\keyword{internal}
