% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_data_quality_job_definitions}
\alias{sagemaker_list_data_quality_job_definitions}
\title{Lists the data quality job definitions in your account}
\usage{
sagemaker_list_data_quality_job_definitions(EndpointName, SortBy,
  SortOrder, NextToken, MaxResults, NameContains, CreationTimeBefore,
  CreationTimeAfter)
}
\arguments{
\item{EndpointName}{A filter that lists the data quality job definitions associated with the
specified endpoint.}

\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Descending}.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_data_quality_job_definitions]{list_data_quality_job_definitions}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of transform jobs, use the token in the next request.>}

\item{MaxResults}{The maximum number of data quality monitoring job definitions to return
in the response.}

\item{NameContains}{A string in the data quality monitoring job definition name. This filter
returns only data quality monitoring job definitions whose name contains
the specified string.}

\item{CreationTimeBefore}{A filter that returns only data quality monitoring job definitions
created before the specified time.}

\item{CreationTimeAfter}{A filter that returns only data quality monitoring job definitions
created after the specified time.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobDefinitionSummaries = list(
    list(
      MonitoringJobDefinitionName = "string",
      MonitoringJobDefinitionArn = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      EndpointName = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the data quality job definitions in your account.
}
\section{Request syntax}{
\preformatted{svc$list_data_quality_job_definitions(
  EndpointName = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123,
  NameContains = "string",
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  )
)
}
}

\keyword{internal}
