% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_faces}
\alias{rekognition_detect_faces}
\title{Detects faces within an image that is provided as input}
\usage{
rekognition_detect_faces(Image, Attributes)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{Attributes}{An array of facial attributes you want to be returned. This can be the
default list of attributes or all attributes. If you don\'t specify a
value for \code{Attributes} or if you specify \verb{\\\["DEFAULT"\\\]}, the API
returns the following subset of facial attributes: \code{BoundingBox},
\code{Confidence}, \code{Pose}, \code{Quality}, and \code{Landmarks}. If you provide
\verb{\\\["ALL"\\\]}, all facial attributes are returned, but the operation
takes longer to complete.

If you provide both, \verb{\\\["ALL", "DEFAULT"\\\]}, the service uses a
logical AND operator to determine which attributes to return (in this
case, all attributes).}
}
\description{
Detects faces within an image that is provided as input.
}
\details{
\code{DetectFaces} detects the 100 largest faces in the image. For each face
detected, the operation returns face details. These details include a
bounding box of the face, a confidence value (that the bounding box
contains a face), and a fixed set of attributes such as facial landmarks
(for example, coordinates of eye and mouth), presence of beard,
sunglasses, and so on.

The face-detection algorithm is most effective on frontal faces. For
non-frontal or obscured faces, the algorithm might not detect the faces
or might detect faces with lower confidence.

You pass the input image either as base64-encoded image bytes or as a
reference to an image in an Amazon S3 bucket. If you use the to call
Amazon Rekognition operations, passing image bytes is not supported. The
image must be either a PNG or JPEG formatted file.

This is a stateless API operation. That is, the operation does not
persist any data.

This operation requires permissions to perform the
\code{rekognition:DetectFaces} action.
}
\section{Request syntax}{
\preformatted{svc$detect_faces(
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  Attributes = list(
    "DEFAULT"|"ALL"
  )
)
}
}

\examples{
# This operation detects faces in an image stored in an AWS S3 bucket.
\dontrun{svc$detect_faces(
  Image = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "myphoto"
    )
  )
)}

}
\keyword{internal}
