% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_get_detectors}
\alias{frauddetector_get_detectors}
\title{Gets all detectors or a single detector if a detectorId is specified}
\usage{
frauddetector_get_detectors(
  detectorId = NULL,
  nextToken = NULL,
  maxResults = NULL
)
}
\arguments{
\item{detectorId}{The detector ID.}

\item{nextToken}{The next token for the subsequent request.}

\item{maxResults}{The maximum number of objects to return for the request.}
}
\description{
Gets all detectors or a single detector if a \code{detectorId} is specified. This is a paginated API. If you provide a null \code{maxResults}, this action retrieves a maximum of 10 records per page. If you provide a \code{maxResults}, the value must be between 5 and 10. To get the next page results, provide the pagination token from the \code{GetDetectorsResponse} as part of your request. A null pagination token fetches the records from the beginning.

See \url{https://paws-r.github.io/docs/frauddetector/get_detectors.html} for full documentation.
}
\keyword{internal}
