% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_hubs}
\alias{sagemaker_list_hubs}
\title{List all existing hubs}
\usage{
sagemaker_list_hubs(
  NameContains = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{NameContains}{Only list hubs with names that contain the specified string.}

\item{CreationTimeBefore}{Only list hubs that were created before the time specified.}

\item{CreationTimeAfter}{Only list hubs that were created after the time specified.}

\item{LastModifiedTimeBefore}{Only list hubs that were last modified before the time specified.}

\item{LastModifiedTimeAfter}{Only list hubs that were last modified after the time specified.}

\item{SortBy}{Sort hubs by either name or creation time.}

\item{SortOrder}{Sort hubs by ascending or descending order.}

\item{MaxResults}{The maximum number of hubs to list.}

\item{NextToken}{If the response to a previous \code{\link[=sagemaker_list_hubs]{list_hubs}} request
was truncated, the response includes a \code{NextToken}. To retrieve the next
set of hubs, use the token in the next request.}
}
\description{
List all existing hubs.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_hubs/} for full documentation.
}
\keyword{internal}
