# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexmodelsv2_service.R
NULL

#' Create a batch of custom vocabulary items for a given bot locale's
#' custom vocabulary
#'
#' @description
#' Create a batch of custom vocabulary items for a given bot locale's custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_create_custom_vocabulary_item/](https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_create_custom_vocabulary_item/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot associated with this custom vocabulary.
#' @param botVersion &#91;required&#93; The identifier of the version of the bot associated with this custom
#' vocabulary.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this custom vocabulary
#' is used. The string must match one of the supported locales. For more
#' information, see [Supported
#' Languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' .
#' @param customVocabularyItemList &#91;required&#93; A list of new custom vocabulary items. Each entry must contain a phrase
#' and can optionally contain a displayAs and/or a weight.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_batch_create_custom_vocabulary_item
lexmodelsv2_batch_create_custom_vocabulary_item <- function(botId, botVersion, localeId, customVocabularyItemList) {
  op <- new_operation(
    name = "BatchCreateCustomVocabularyItem",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchcreate",
    paginator = list()
  )
  input <- .lexmodelsv2$batch_create_custom_vocabulary_item_input(botId = botId, botVersion = botVersion, localeId = localeId, customVocabularyItemList = customVocabularyItemList)
  output <- .lexmodelsv2$batch_create_custom_vocabulary_item_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$batch_create_custom_vocabulary_item <- lexmodelsv2_batch_create_custom_vocabulary_item

#' Delete a batch of custom vocabulary items for a given bot locale's
#' custom vocabulary
#'
#' @description
#' Delete a batch of custom vocabulary items for a given bot locale's custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_delete_custom_vocabulary_item/](https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_delete_custom_vocabulary_item/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot associated with this custom vocabulary.
#' @param botVersion &#91;required&#93; The identifier of the version of the bot associated with this custom
#' vocabulary.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this custom vocabulary
#' is used. The string must match one of the supported locales. For more
#' information, see [Supported
#' Languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' .
#' @param customVocabularyItemList &#91;required&#93; A list of custom vocabulary items requested to be deleted. Each entry
#' must contain the unique custom vocabulary entry identifier.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_batch_delete_custom_vocabulary_item
lexmodelsv2_batch_delete_custom_vocabulary_item <- function(botId, botVersion, localeId, customVocabularyItemList) {
  op <- new_operation(
    name = "BatchDeleteCustomVocabularyItem",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchdelete",
    paginator = list()
  )
  input <- .lexmodelsv2$batch_delete_custom_vocabulary_item_input(botId = botId, botVersion = botVersion, localeId = localeId, customVocabularyItemList = customVocabularyItemList)
  output <- .lexmodelsv2$batch_delete_custom_vocabulary_item_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$batch_delete_custom_vocabulary_item <- lexmodelsv2_batch_delete_custom_vocabulary_item

#' Update a batch of custom vocabulary items for a given bot locale's
#' custom vocabulary
#'
#' @description
#' Update a batch of custom vocabulary items for a given bot locale's custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_update_custom_vocabulary_item/](https://www.paws-r-sdk.com/docs/lexmodelsv2_batch_update_custom_vocabulary_item/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot associated with this custom vocabulary
#' @param botVersion &#91;required&#93; The identifier of the version of the bot associated with this custom
#' vocabulary.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this custom vocabulary
#' is used. The string must match one of the supported locales. For more
#' information, see [Supported
#' Languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' .
#' @param customVocabularyItemList &#91;required&#93; A list of custom vocabulary items with updated fields. Each entry must
#' contain a phrase and can optionally contain a displayAs and/or a weight.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_batch_update_custom_vocabulary_item
lexmodelsv2_batch_update_custom_vocabulary_item <- function(botId, botVersion, localeId, customVocabularyItemList) {
  op <- new_operation(
    name = "BatchUpdateCustomVocabularyItem",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchupdate",
    paginator = list()
  )
  input <- .lexmodelsv2$batch_update_custom_vocabulary_item_input(botId = botId, botVersion = botVersion, localeId = localeId, customVocabularyItemList = customVocabularyItemList)
  output <- .lexmodelsv2$batch_update_custom_vocabulary_item_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$batch_update_custom_vocabulary_item <- lexmodelsv2_batch_update_custom_vocabulary_item

#' Builds a bot, its intents, and its slot types into a specific locale
#'
#' @description
#' Builds a bot, its intents, and its slot types into a specific locale. A bot can be built into multiple locales. At runtime the locale is used to choose a specific build of the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_build_bot_locale/](https://www.paws-r-sdk.com/docs/lexmodelsv2_build_bot_locale/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to build. The identifier is returned in the
#' response from the [`create_bot`][lexmodelsv2_create_bot] operation.
#' @param botVersion &#91;required&#93; The version of the bot to build. This can only be the draft version of
#' the bot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the bot will be used in.
#' The string must match one of the supported locales. All of the intents,
#' slot types, and slots used in the bot must have the same locale. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_build_bot_locale
lexmodelsv2_build_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "BuildBotLocale",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$build_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$build_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$build_bot_locale <- lexmodelsv2_build_bot_locale

#' Creates an Amazon Lex conversational bot
#'
#' @description
#' Creates an Amazon Lex conversational bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot/) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the bot. The bot name must be unique in the account that
#' creates the bot.
#' @param description A description of the bot. It appears in lists to help you identify a
#' particular bot.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that has permission to
#' access the bot.
#' @param dataPrivacy &#91;required&#93; Provides information on additional privacy protections Amazon Lex should
#' use with the bot's data.
#' @param idleSessionTTLInSeconds &#91;required&#93; The time, in seconds, that Amazon Lex should keep information about a
#' user's conversation with the bot.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Lex deletes any data provided before the timeout.
#' 
#' You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
#' @param botTags A list of tags to add to the bot. You can only add tags when you create
#' a bot. You can't use the [`update_bot`][lexmodelsv2_update_bot]
#' operation to update tags. To update tags, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#' @param testBotAliasTags A list of tags to add to the test alias for a bot. You can only add tags
#' when you create a bot. You can't use the `UpdateAlias` operation to
#' update tags. To update tags on the test alias, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#' @param botType The type of a bot to create.
#' @param botMembers The list of bot members in a network to be created.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot
lexmodelsv2_create_bot <- function(botName, description = NULL, roleArn, dataPrivacy, idleSessionTTLInSeconds, botTags = NULL, testBotAliasTags = NULL, botType = NULL, botMembers = NULL) {
  op <- new_operation(
    name = "CreateBot",
    http_method = "PUT",
    http_path = "/bots/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_input(botName = botName, description = description, roleArn = roleArn, dataPrivacy = dataPrivacy, idleSessionTTLInSeconds = idleSessionTTLInSeconds, botTags = botTags, testBotAliasTags = testBotAliasTags, botType = botType, botMembers = botMembers)
  output <- .lexmodelsv2$create_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot <- lexmodelsv2_create_bot

#' Creates an alias for the specified version of a bot
#'
#' @description
#' Creates an alias for the specified version of a bot. Use an alias to enable you to change the version of a bot without updating applications that use the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_alias/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_alias/) for full documentation.
#'
#' @param botAliasName &#91;required&#93; The alias to create. The name must be unique for the bot.
#' @param description A description of the alias. Use this description to help identify the
#' alias.
#' @param botVersion The version of the bot that this alias points to. You can use the
#' [`update_bot_alias`][lexmodelsv2_update_bot_alias] operation to change
#' the bot version associated with the alias.
#' @param botAliasLocaleSettings Maps configuration information to a specific locale. You can use this
#' parameter to specify a specific Lambda function to run different
#' functions in different locales.
#' @param conversationLogSettings Specifies whether Amazon Lex logs text and audio for a conversation with
#' the bot. When you enable conversation logs, text logs store text input,
#' transcripts of audio input, and associated metadata in Amazon CloudWatch
#' Logs. Audio logs store audio input in Amazon S3.
#' @param sentimentAnalysisSettings 
#' @param botId &#91;required&#93; The unique identifier of the bot that the alias applies to.
#' @param tags A list of tags to add to the bot alias. You can only add tags when you
#' create an alias, you can't use the
#' [`update_bot_alias`][lexmodelsv2_update_bot_alias] operation to update
#' the tags on a bot alias. To update tags, use the
#' [`tag_resource`][lexmodelsv2_tag_resource] operation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_alias
lexmodelsv2_create_bot_alias <- function(botAliasName, description = NULL, botVersion = NULL, botAliasLocaleSettings = NULL, conversationLogSettings = NULL, sentimentAnalysisSettings = NULL, botId, tags = NULL) {
  op <- new_operation(
    name = "CreateBotAlias",
    http_method = "PUT",
    http_path = "/bots/{botId}/botaliases/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_alias_input(botAliasName = botAliasName, description = description, botVersion = botVersion, botAliasLocaleSettings = botAliasLocaleSettings, conversationLogSettings = conversationLogSettings, sentimentAnalysisSettings = sentimentAnalysisSettings, botId = botId, tags = tags)
  output <- .lexmodelsv2$create_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_alias <- lexmodelsv2_create_bot_alias

#' Creates a locale in the bot
#'
#' @description
#' Creates a locale in the bot. The locale contains the intents and slot types that the bot uses in conversations with users in the specified language and locale. You must add a locale to a bot before you can add intents and slot types to the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_locale/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_locale/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to create the locale for.
#' @param botVersion &#91;required&#93; The version of the bot to create the locale for. This can only be the
#' draft version of the bot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the bot will be used in.
#' The string must match one of the supported locales. All of the intents,
#' slot types, and slots used in the bot must have the same locale. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param description A description of the bot locale. Use this to help identify the bot
#' locale in lists.
#' @param nluIntentConfidenceThreshold &#91;required&#93; Determines the threshold where Amazon Lex will insert the
#' `AMAZON.FallbackIntent`, `AMAZON.KendraSearchIntent`, or both when
#' returning alternative intents. `AMAZON.FallbackIntent` and
#' `AMAZON.KendraSearchIntent` are only inserted if they are configured for
#' the bot.
#' 
#' For example, suppose a bot is configured with the confidence threshold
#' of 0.80 and the `AMAZON.FallbackIntent`. Amazon Lex returns three
#' alternative intents with the following confidence scores: IntentA
#' (0.70), IntentB (0.60), IntentC (0.50). The response from the
#' `RecognizeText` operation would be:
#' 
#' -   AMAZON.FallbackIntent
#' 
#' -   IntentA
#' 
#' -   IntentB
#' 
#' -   IntentC
#' @param voiceSettings The Amazon Polly voice ID that Amazon Lex uses for voice interaction
#' with the user.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_locale
lexmodelsv2_create_bot_locale <- function(botId, botVersion, localeId, description = NULL, nluIntentConfidenceThreshold, voiceSettings = NULL) {
  op <- new_operation(
    name = "CreateBotLocale",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId, description = description, nluIntentConfidenceThreshold = nluIntentConfidenceThreshold, voiceSettings = voiceSettings)
  output <- .lexmodelsv2$create_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_locale <- lexmodelsv2_create_bot_locale

#' Creates a new version of the bot based on the DRAFT version
#'
#' @description
#' Creates a new version of the bot based on the `DRAFT` version. If the `DRAFT` version of this resource hasn't changed since you created the last version, Amazon Lex doesn't create a new version, it returns the last created version.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_version/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_bot_version/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to create the version for.
#' @param description A description of the version. Use the description to help identify the
#' version in lists.
#' @param botVersionLocaleSpecification &#91;required&#93; Specifies the locales that Amazon Lex adds to this version. You can
#' choose the `Draft` version or any other previously published version for
#' each locale. When you specify a source version, the locale data is
#' copied from the source version to the new version.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_bot_version
lexmodelsv2_create_bot_version <- function(botId, description = NULL, botVersionLocaleSpecification) {
  op <- new_operation(
    name = "CreateBotVersion",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_bot_version_input(botId = botId, description = description, botVersionLocaleSpecification = botVersionLocaleSpecification)
  output <- .lexmodelsv2$create_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_bot_version <- lexmodelsv2_create_bot_version

#' Creates a zip archive containing the contents of a bot or a bot locale
#'
#' @description
#' Creates a zip archive containing the contents of a bot or a bot locale. The archive contains a directory structure that contains JSON files that define the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_export/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_export/) for full documentation.
#'
#' @param resourceSpecification &#91;required&#93; Specifies the type of resource to export, either a bot or a bot locale.
#' You can only specify one type of resource to export.
#' @param fileFormat &#91;required&#93; The file format of the bot or bot locale definition files.
#' @param filePassword An password to use to encrypt the exported archive. Using a password is
#' optional, but you should encrypt the archive to protect the data in
#' transit between Amazon Lex and your local computer.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_export
lexmodelsv2_create_export <- function(resourceSpecification, fileFormat, filePassword = NULL) {
  op <- new_operation(
    name = "CreateExport",
    http_method = "PUT",
    http_path = "/exports/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_export_input(resourceSpecification = resourceSpecification, fileFormat = fileFormat, filePassword = filePassword)
  output <- .lexmodelsv2$create_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_export <- lexmodelsv2_create_export

#' Creates an intent
#'
#' @description
#' Creates an intent.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_intent/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_intent/) for full documentation.
#'
#' @param intentName &#91;required&#93; The name of the intent. Intent names must be unique in the locale that
#' contains the intent and cannot match the name of any built-in intent.
#' @param description A description of the intent. Use the description to help identify the
#' intent in lists.
#' @param parentIntentSignature A unique identifier for the built-in intent to base this intent on.
#' @param sampleUtterances An array of strings that a user might say to signal the intent. For
#' example, "I want a pizza", or "I want a \{PizzaSize\} pizza".
#' 
#' In an utterance, slot names are enclosed in curly braces ("\{", "\}")
#' to indicate where they should be displayed in the utterance shown to the
#' user..
#' @param dialogCodeHook Specifies that Amazon Lex invokes the alias Lambda function for each
#' user input. You can invoke this Lambda function to personalize user
#' interaction.
#' 
#' For example, suppose that your bot determines that the user's name is
#' John. You Lambda function might retrieve John's information from a
#' backend database and prepopulate some of the values. For example, if you
#' find that John is gluten intolerant, you might set the corresponding
#' intent slot, `glutenIntolerant` to `true`. You might find John's phone
#' number and set the corresponding session attribute.
#' @param fulfillmentCodeHook Specifies that Amazon Lex invokes the alias Lambda function when the
#' intent is ready for fulfillment. You can invoke this function to
#' complete the bot's transaction with the user.
#' 
#' For example, in a pizza ordering bot, the Lambda function can look up
#' the closest pizza restaurant to the customer's location and then place
#' an order on the customer's behalf.
#' @param intentConfirmationSetting Provides prompts that Amazon Lex sends to the user to confirm the
#' completion of an intent. If the user answers "no," the settings contain
#' a statement that is sent to the user to end the intent.
#' @param intentClosingSetting Sets the response that Amazon Lex sends to the user when the intent is
#' closed.
#' @param inputContexts A list of contexts that must be active for this intent to be considered
#' by Amazon Lex.
#' 
#' When an intent has an input context list, Amazon Lex only considers
#' using the intent in an interaction with the user when the specified
#' contexts are included in the active context list for the session. If the
#' contexts are not active, then Amazon Lex will not use the intent.
#' 
#' A context can be automatically activated using the `outputContexts`
#' property or it can be set at runtime.
#' 
#' For example, if there are two intents with different input contexts that
#' respond to the same utterances, only the intent with the active context
#' will respond.
#' 
#' An intent may have up to 5 input contexts. If an intent has multiple
#' input contexts, all of the contexts must be active to consider the
#' intent.
#' @param outputContexts A lists of contexts that the intent activates when it is fulfilled.
#' 
#' You can use an output context to indicate the intents that Amazon Lex
#' should consider for the next turn of the conversation with a customer.
#' 
#' When you use the `outputContextsList` property, all of the contexts
#' specified in the list are activated when the intent is fulfilled. You
#' can set up to 10 output contexts. You can also set the number of
#' conversation turns that the context should be active, or the length of
#' time that the context should be active.
#' @param kendraConfiguration Configuration information required to use the
#' `AMAZON.KendraSearchIntent` intent to connect to an Amazon Kendra index.
#' The `AMAZON.KendraSearchIntent` intent is called when Amazon Lex can't
#' determine another intent to invoke.
#' @param botId &#91;required&#93; The identifier of the bot associated with this intent.
#' @param botVersion &#91;required&#93; The version of the bot associated with this intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this intent is used. All
#' of the bots, slot types, and slots used by the intent must have the same
#' locale. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param initialResponseSetting Configuration settings for the response that is sent to the user at the
#' beginning of a conversation, before eliciting slot values.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_intent
lexmodelsv2_create_intent <- function(intentName, description = NULL, parentIntentSignature = NULL, sampleUtterances = NULL, dialogCodeHook = NULL, fulfillmentCodeHook = NULL, intentConfirmationSetting = NULL, intentClosingSetting = NULL, inputContexts = NULL, outputContexts = NULL, kendraConfiguration = NULL, botId, botVersion, localeId, initialResponseSetting = NULL) {
  op <- new_operation(
    name = "CreateIntent",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_intent_input(intentName = intentName, description = description, parentIntentSignature = parentIntentSignature, sampleUtterances = sampleUtterances, dialogCodeHook = dialogCodeHook, fulfillmentCodeHook = fulfillmentCodeHook, intentConfirmationSetting = intentConfirmationSetting, intentClosingSetting = intentClosingSetting, inputContexts = inputContexts, outputContexts = outputContexts, kendraConfiguration = kendraConfiguration, botId = botId, botVersion = botVersion, localeId = localeId, initialResponseSetting = initialResponseSetting)
  output <- .lexmodelsv2$create_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_intent <- lexmodelsv2_create_intent

#' Creates a new resource policy with the specified policy statements
#'
#' @description
#' Creates a new resource policy with the specified policy statements.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_resource_policy/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param policy &#91;required&#93; A resource policy to add to the resource. The policy is a JSON structure
#' that contains one or more statements that define the policy. The policy
#' must follow the IAM syntax. For more information about the contents of a
#' JSON policy document, see [IAM JSON policy
#' reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' .
#' 
#' If the policy isn't valid, Amazon Lex returns a validation exception.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_resource_policy
lexmodelsv2_create_resource_policy <- function(resourceArn, policy) {
  op <- new_operation(
    name = "CreateResourcePolicy",
    http_method = "POST",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_resource_policy_input(resourceArn = resourceArn, policy = policy)
  output <- .lexmodelsv2$create_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_resource_policy <- lexmodelsv2_create_resource_policy

#' Adds a new resource policy statement to a bot or bot alias
#'
#' @description
#' Adds a new resource policy statement to a bot or bot alias. If a resource policy exists, the statement is added to the current resource policy. If a policy doesn't exist, a new policy is created.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_resource_policy_statement/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_resource_policy_statement/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param statementId &#91;required&#93; The name of the statement. The ID is the same as the `Sid` IAM property.
#' The statement name must be unique within the policy. For more
#' information, see [IAM JSON policy elements:
#' Sid](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html).
#' @param effect &#91;required&#93; Determines whether the statement allows or denies access to the
#' resource.
#' @param principal &#91;required&#93; An IAM principal, such as an IAM user, IAM role, or Amazon Web Services
#' services that is allowed or denied access to a resource. For more
#' information, see [Amazon Web Services JSON policy elements:
#' Principal](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html).
#' @param action &#91;required&#93; The Amazon Lex action that this policy either allows or denies. The
#' action must apply to the resource type of the specified ARN. For more
#' information, see [Actions, resources, and condition keys for Amazon Lex
#' V2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
#' @param condition Specifies a condition when the policy is in effect. If the principal of
#' the policy is a service principal, you must provide two condition
#' blocks, one with a SourceAccount global condition key and one with a
#' SourceArn global condition key.
#' 
#' For more information, see [IAM JSON policy elements:
#' Condition](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html)
#' .
#' @param expectedRevisionId The identifier of the revision of the policy to edit. If this revision
#' ID doesn't match the current revision ID, Amazon Lex throws an
#' exception.
#' 
#' If you don't specify a revision, Amazon Lex overwrites the contents of
#' the policy with the new values.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_resource_policy_statement
lexmodelsv2_create_resource_policy_statement <- function(resourceArn, statementId, effect, principal, action, condition = NULL, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "CreateResourcePolicyStatement",
    http_method = "POST",
    http_path = "/policy/{resourceArn}/statements/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_resource_policy_statement_input(resourceArn = resourceArn, statementId = statementId, effect = effect, principal = principal, action = action, condition = condition, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$create_resource_policy_statement_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_resource_policy_statement <- lexmodelsv2_create_resource_policy_statement

#' Creates a slot in an intent
#'
#' @description
#' Creates a slot in an intent. A slot is a variable needed to fulfill an intent. For example, an `OrderPizza` intent might need slots for size, crust, and number of pizzas. For each slot, you define one or more utterances that Amazon Lex uses to elicit a response from the user.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_slot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_slot/) for full documentation.
#'
#' @param slotName &#91;required&#93; The name of the slot. Slot names must be unique within the bot that
#' contains the slot.
#' @param description A description of the slot. Use this to help identify the slot in lists.
#' @param slotTypeId The unique identifier for the slot type associated with this slot. The
#' slot type determines the values that can be entered into the slot.
#' @param valueElicitationSetting &#91;required&#93; Specifies prompts that Amazon Lex sends to the user to elicit a response
#' that provides the value for the slot.
#' @param obfuscationSetting Determines how slot values are used in Amazon CloudWatch logs. If the
#' value of the `obfuscationSetting` parameter is `DefaultObfuscation`,
#' slot values are obfuscated in the log output. If the value is `None`,
#' the actual value is present in the log output.
#' 
#' The default is to obfuscate values in the CloudWatch logs.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot will be used in.
#' The string must match one of the supported locales. All of the bots,
#' intents, slot types used by the slot must have the same locale. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#' @param multipleValuesSetting Indicates whether the slot returns multiple values in one response.
#' Multi-value slots are only available in the `en-US` locale. If you set
#' this value to `true` in any other locale, Amazon Lex throws a
#' `ValidationException`.
#' 
#' If the `multipleValuesSetting` is not set, the default value is `false`.
#' @param subSlotSetting Specifications for the constituent sub slots and the expression for the
#' composite slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_slot
lexmodelsv2_create_slot <- function(slotName, description = NULL, slotTypeId = NULL, valueElicitationSetting, obfuscationSetting = NULL, botId, botVersion, localeId, intentId, multipleValuesSetting = NULL, subSlotSetting = NULL) {
  op <- new_operation(
    name = "CreateSlot",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_slot_input(slotName = slotName, description = description, slotTypeId = slotTypeId, valueElicitationSetting = valueElicitationSetting, obfuscationSetting = obfuscationSetting, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, multipleValuesSetting = multipleValuesSetting, subSlotSetting = subSlotSetting)
  output <- .lexmodelsv2$create_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_slot <- lexmodelsv2_create_slot

#' Creates a custom slot type
#'
#' @description
#' Creates a custom slot type
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_slot_type/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_slot_type/) for full documentation.
#'
#' @param slotTypeName &#91;required&#93; The name for the slot. A slot type name must be unique within the
#' intent.
#' @param description A description of the slot type. Use the description to help identify the
#' slot type in lists.
#' @param slotTypeValues A list of `SlotTypeValue` objects that defines the values that the slot
#' type can take. Each value can have a list of synonyms, additional values
#' that help train the machine learning model about the values that it
#' resolves for a slot.
#' @param valueSelectionSetting Determines the strategy that Amazon Lex uses to select a value from the
#' list of possible values. The field can be set to one of the following
#' values:
#' 
#' -   `ORIGINAL_VALUE` - Returns the value entered by the user, if the
#'     user value is similar to the slot value.
#' 
#' -   `TOP_RESOLUTION` - If there is a resolution list for the slot,
#'     return the first value in the resolution list. If there is no
#'     resolution list, return null.
#' 
#' If you don't specify the `valueSelectionSetting` parameter, the default
#' is `ORIGINAL_VALUE`.
#' @param parentSlotTypeSignature The built-in slot type used as a parent of this slot type. When you
#' define a parent slot type, the new slot type has the configuration of
#' the parent slot type.
#' 
#' Only `AMAZON.AlphaNumeric` is supported.
#' @param botId &#91;required&#93; The identifier of the bot associated with this slot type.
#' @param botVersion &#91;required&#93; The identifier of the bot version associated with this slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot type will be
#' used in. The string must match one of the supported locales. All of the
#' bots, intents, and slots used by the slot type must have the same
#' locale. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param externalSourceSetting Sets the type of external information used to create the slot type.
#' @param compositeSlotTypeSetting Specifications for a composite slot type.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_slot_type
lexmodelsv2_create_slot_type <- function(slotTypeName, description = NULL, slotTypeValues = NULL, valueSelectionSetting = NULL, parentSlotTypeSignature = NULL, botId, botVersion, localeId, externalSourceSetting = NULL, compositeSlotTypeSetting = NULL) {
  op <- new_operation(
    name = "CreateSlotType",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_slot_type_input(slotTypeName = slotTypeName, description = description, slotTypeValues = slotTypeValues, valueSelectionSetting = valueSelectionSetting, parentSlotTypeSignature = parentSlotTypeSignature, botId = botId, botVersion = botVersion, localeId = localeId, externalSourceSetting = externalSourceSetting, compositeSlotTypeSetting = compositeSlotTypeSetting)
  output <- .lexmodelsv2$create_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_slot_type <- lexmodelsv2_create_slot_type

#' Create a report that describes the differences between the bot and the
#' test set
#'
#' @description
#' Create a report that describes the differences between the bot and the test set.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_test_set_discrepancy_report/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_test_set_discrepancy_report/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The test set Id for the test set discrepancy report.
#' @param target &#91;required&#93; The target bot for the test set discrepancy report.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_test_set_discrepancy_report
lexmodelsv2_create_test_set_discrepancy_report <- function(testSetId, target) {
  op <- new_operation(
    name = "CreateTestSetDiscrepancyReport",
    http_method = "POST",
    http_path = "/testsets/{testSetId}/testsetdiscrepancy",
    paginator = list()
  )
  input <- .lexmodelsv2$create_test_set_discrepancy_report_input(testSetId = testSetId, target = target)
  output <- .lexmodelsv2$create_test_set_discrepancy_report_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_test_set_discrepancy_report <- lexmodelsv2_create_test_set_discrepancy_report

#' Gets a pre-signed S3 write URL that you use to upload the zip archive
#' when importing a bot or a bot locale
#'
#' @description
#' Gets a pre-signed S3 write URL that you use to upload the zip archive when importing a bot or a bot locale.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_create_upload_url/](https://www.paws-r-sdk.com/docs/lexmodelsv2_create_upload_url/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_create_upload_url
lexmodelsv2_create_upload_url <- function() {
  op <- new_operation(
    name = "CreateUploadUrl",
    http_method = "POST",
    http_path = "/createuploadurl/",
    paginator = list()
  )
  input <- .lexmodelsv2$create_upload_url_input()
  output <- .lexmodelsv2$create_upload_url_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$create_upload_url <- lexmodelsv2_create_upload_url

#' Deletes all versions of a bot, including the Draft version
#'
#' @description
#' Deletes all versions of a bot, including the `Draft` version. To delete a specific version, use the [`delete_bot_version`][lexmodelsv2_delete_bot_version] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to delete.
#' @param skipResourceInUseCheck By default, Amazon Lex checks if any other resource, such as an alias or
#' bot network, is using the bot version before it is deleted and throws a
#' `ResourceInUseException` exception if the bot is being used by another
#' resource. Set this parameter to `true` to skip this check and remove the
#' bot even if it is being used by another resource.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot
lexmodelsv2_delete_bot <- function(botId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBot",
    http_method = "DELETE",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_input(botId = botId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot <- lexmodelsv2_delete_bot

#' Deletes the specified bot alias
#'
#' @description
#' Deletes the specified bot alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_alias/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_alias/) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The unique identifier of the bot alias to delete.
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the alias to delete.
#' @param skipResourceInUseCheck By default, Amazon Lex checks if any other resource, such as a bot
#' network, is using the bot alias before it is deleted and throws a
#' `ResourceInUseException` exception if the alias is being used by another
#' resource. Set this parameter to `true` to skip this check and remove the
#' alias even if it is being used by another resource.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_alias
lexmodelsv2_delete_bot_alias <- function(botAliasId, botId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBotAlias",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_alias_input(botAliasId = botAliasId, botId = botId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_alias <- lexmodelsv2_delete_bot_alias

#' Removes a locale from a bot
#'
#' @description
#' Removes a locale from a bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_locale/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_locale/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the locale.
#' @param botVersion &#91;required&#93; The version of the bot that contains the locale.
#' @param localeId &#91;required&#93; The identifier of the language and locale that will be deleted. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_locale
lexmodelsv2_delete_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteBotLocale",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_locale <- lexmodelsv2_delete_bot_locale

#' Deletes a specific version of a bot
#'
#' @description
#' Deletes a specific version of a bot. To delete all versions of a bot, use the [`delete_bot`][lexmodelsv2_delete_bot] operation.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_version/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_bot_version/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the version.
#' @param botVersion &#91;required&#93; The version of the bot to delete.
#' @param skipResourceInUseCheck By default, Amazon Lex checks if any other resource, such as an alias or
#' bot network, is using the bot version before it is deleted and throws a
#' `ResourceInUseException` exception if the version is being used by
#' another resource. Set this parameter to `true` to skip this check and
#' remove the version even if it is being used by another resource.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_bot_version
lexmodelsv2_delete_bot_version <- function(botId, botVersion, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteBotVersion",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_bot_version_input(botId = botId, botVersion = botVersion, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_bot_version <- lexmodelsv2_delete_bot_version

#' Removes a custom vocabulary from the specified locale in the specified
#' bot
#'
#' @description
#' Removes a custom vocabulary from the specified locale in the specified bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_custom_vocabulary/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_custom_vocabulary/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to remove the custom vocabulary from.
#' @param botVersion &#91;required&#93; The version of the bot to remove the custom vocabulary from.
#' @param localeId &#91;required&#93; The locale identifier for the locale that contains the custom vocabulary
#' to remove.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_custom_vocabulary
lexmodelsv2_delete_custom_vocabulary <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteCustomVocabulary",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_custom_vocabulary_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_custom_vocabulary_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_custom_vocabulary <- lexmodelsv2_delete_custom_vocabulary

#' Removes a previous export and the associated files stored in an S3
#' bucket
#'
#' @description
#' Removes a previous export and the associated files stored in an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_export/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_export/) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier of the export to delete.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_export
lexmodelsv2_delete_export <- function(exportId) {
  op <- new_operation(
    name = "DeleteExport",
    http_method = "DELETE",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_export_input(exportId = exportId)
  output <- .lexmodelsv2$delete_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_export <- lexmodelsv2_delete_export

#' Removes a previous import and the associated file stored in an S3 bucket
#'
#' @description
#' Removes a previous import and the associated file stored in an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_import/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_import/) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier of the import to delete.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_import
lexmodelsv2_delete_import <- function(importId) {
  op <- new_operation(
    name = "DeleteImport",
    http_method = "DELETE",
    http_path = "/imports/{importId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_import_input(importId = importId)
  output <- .lexmodelsv2$delete_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_import <- lexmodelsv2_delete_import

#' Removes the specified intent
#'
#' @description
#' Removes the specified intent.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_intent/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_intent/) for full documentation.
#'
#' @param intentId &#91;required&#93; The unique identifier of the intent to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the intent.
#' @param botVersion &#91;required&#93; The version of the bot associated with the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale where the bot will be deleted.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_intent
lexmodelsv2_delete_intent <- function(intentId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DeleteIntent",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_intent_input(intentId = intentId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$delete_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_intent <- lexmodelsv2_delete_intent

#' Removes an existing policy from a bot or bot alias
#'
#' @description
#' Removes an existing policy from a bot or bot alias. If the resource doesn't have a policy attached, Amazon Lex returns an exception.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_resource_policy/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that has the
#' resource policy attached.
#' @param expectedRevisionId The identifier of the revision to edit. If this ID doesn't match the
#' current revision number, Amazon Lex returns an exception
#' 
#' If you don't specify a revision ID, Amazon Lex will delete the current
#' policy.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_resource_policy
lexmodelsv2_delete_resource_policy <- function(resourceArn, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicy",
    http_method = "DELETE",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_resource_policy_input(resourceArn = resourceArn, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$delete_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_resource_policy <- lexmodelsv2_delete_resource_policy

#' Deletes a policy statement from a resource policy
#'
#' @description
#' Deletes a policy statement from a resource policy. If you delete the last statement from a policy, the policy is deleted. If you specify a statement ID that doesn't exist in the policy, or if the bot or bot alias doesn't have a policy attached, Amazon Lex returns an exception.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_resource_policy_statement/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_resource_policy_statement/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param statementId &#91;required&#93; The name of the statement (SID) to delete from the policy.
#' @param expectedRevisionId The identifier of the revision of the policy to delete the statement
#' from. If this revision ID doesn't match the current revision ID, Amazon
#' Lex throws an exception.
#' 
#' If you don't specify a revision, Amazon Lex removes the current contents
#' of the statement.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_resource_policy_statement
lexmodelsv2_delete_resource_policy_statement <- function(resourceArn, statementId, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "DeleteResourcePolicyStatement",
    http_method = "DELETE",
    http_path = "/policy/{resourceArn}/statements/{statementId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_resource_policy_statement_input(resourceArn = resourceArn, statementId = statementId, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$delete_resource_policy_statement_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_resource_policy_statement <- lexmodelsv2_delete_resource_policy_statement

#' Deletes the specified slot from an intent
#'
#' @description
#' Deletes the specified slot from an intent.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_slot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_slot/) for full documentation.
#'
#' @param slotId &#91;required&#93; The identifier of the slot to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot to delete.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot to delete.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot will be deleted
#' from. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent associated with the slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_slot
lexmodelsv2_delete_slot <- function(slotId, botId, botVersion, localeId, intentId) {
  op <- new_operation(
    name = "DeleteSlot",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_slot_input(slotId = slotId, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId)
  output <- .lexmodelsv2$delete_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_slot <- lexmodelsv2_delete_slot

#' Deletes a slot type from a bot locale
#'
#' @description
#' Deletes a slot type from a bot locale.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_slot_type/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_slot_type/) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The identifier of the slot type to delete.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot type.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale that the slot type will be
#' deleted from. The string must match one of the supported locales. For
#' more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param skipResourceInUseCheck By default, the [`delete_slot_type`][lexmodelsv2_delete_slot_type]
#' operations throws a `ResourceInUseException` exception if you try to
#' delete a slot type used by a slot. Set the `skipResourceInUseCheck`
#' parameter to `true` to skip this check and remove the slot type even if
#' a slot uses it.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_slot_type
lexmodelsv2_delete_slot_type <- function(slotTypeId, botId, botVersion, localeId, skipResourceInUseCheck = NULL) {
  op <- new_operation(
    name = "DeleteSlotType",
    http_method = "DELETE",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_slot_type_input(slotTypeId = slotTypeId, botId = botId, botVersion = botVersion, localeId = localeId, skipResourceInUseCheck = skipResourceInUseCheck)
  output <- .lexmodelsv2$delete_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_slot_type <- lexmodelsv2_delete_slot_type

#' The action to delete the selected test set
#'
#' @description
#' The action to delete the selected test set.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_test_set/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_test_set/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The test set Id of the test set to be deleted.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_test_set
lexmodelsv2_delete_test_set <- function(testSetId) {
  op <- new_operation(
    name = "DeleteTestSet",
    http_method = "DELETE",
    http_path = "/testsets/{testSetId}",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_test_set_input(testSetId = testSetId)
  output <- .lexmodelsv2$delete_test_set_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_test_set <- lexmodelsv2_delete_test_set

#' Deletes stored utterances
#'
#' @description
#' Deletes stored utterances.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_utterances/](https://www.paws-r-sdk.com/docs/lexmodelsv2_delete_utterances/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the utterances.
#' @param localeId The identifier of the language and locale where the utterances were
#' collected. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sessionId The unique identifier of the session with the user. The ID is returned
#' in the response from the
#' [RecognizeText](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeText.html)
#' and
#' [RecognizeUtterance](https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_RecognizeUtterance.html)
#' operations.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_delete_utterances
lexmodelsv2_delete_utterances <- function(botId, localeId = NULL, sessionId = NULL) {
  op <- new_operation(
    name = "DeleteUtterances",
    http_method = "DELETE",
    http_path = "/bots/{botId}/utterances/",
    paginator = list()
  )
  input <- .lexmodelsv2$delete_utterances_input(botId = botId, localeId = localeId, sessionId = sessionId)
  output <- .lexmodelsv2$delete_utterances_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$delete_utterances <- lexmodelsv2_delete_utterances

#' Provides metadata information about a bot
#'
#' @description
#' Provides metadata information about a bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot
lexmodelsv2_describe_bot <- function(botId) {
  op <- new_operation(
    name = "DescribeBot",
    http_method = "GET",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_input(botId = botId)
  output <- .lexmodelsv2$describe_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot <- lexmodelsv2_describe_bot

#' Get information about a specific bot alias
#'
#' @description
#' Get information about a specific bot alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_alias/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_alias/) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The identifier of the bot alias to describe.
#' @param botId &#91;required&#93; The identifier of the bot associated with the bot alias to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_alias
lexmodelsv2_describe_bot_alias <- function(botAliasId, botId) {
  op <- new_operation(
    name = "DescribeBotAlias",
    http_method = "GET",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_alias_input(botAliasId = botAliasId, botId = botId)
  output <- .lexmodelsv2$describe_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_alias <- lexmodelsv2_describe_bot_alias

#' Describes the settings that a bot has for a specific locale
#'
#' @description
#' Describes the settings that a bot has for a specific locale.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_locale/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_locale/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot associated with the locale.
#' @param botVersion &#91;required&#93; The version of the bot associated with the locale.
#' @param localeId &#91;required&#93; The unique identifier of the locale to describe. The string must match
#' one of the supported locales. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_locale
lexmodelsv2_describe_bot_locale <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeBotLocale",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_locale <- lexmodelsv2_describe_bot_locale

#' Provides metadata information about a bot recommendation
#'
#' @description
#' Provides metadata information about a bot recommendation. This information will enable you to get a description on the request inputs, to download associated transcripts after processing is complete, and to download intents and slot-types generated by the bot recommendation.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_recommendation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_recommendation/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the bot recommendation.
#' @param botVersion &#91;required&#93; The version of the bot associated with the bot recommendation.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' describe. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param botRecommendationId &#91;required&#93; The identifier of the bot recommendation to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_recommendation
lexmodelsv2_describe_bot_recommendation <- function(botId, botVersion, localeId, botRecommendationId) {
  op <- new_operation(
    name = "DescribeBotRecommendation",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId)
  output <- .lexmodelsv2$describe_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_recommendation <- lexmodelsv2_describe_bot_recommendation

#' Provides metadata about a version of a bot
#'
#' @description
#' Provides metadata about a version of a bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_version/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_bot_version/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot containing the version to return metadata for.
#' @param botVersion &#91;required&#93; The version of the bot to return metadata for.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_bot_version
lexmodelsv2_describe_bot_version <- function(botId, botVersion) {
  op <- new_operation(
    name = "DescribeBotVersion",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_bot_version_input(botId = botId, botVersion = botVersion)
  output <- .lexmodelsv2$describe_bot_version_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_bot_version <- lexmodelsv2_describe_bot_version

#' Provides metadata information about a custom vocabulary
#'
#' @description
#' Provides metadata information about a custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_custom_vocabulary_metadata/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_custom_vocabulary_metadata/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the custom vocabulary.
#' @param botVersion &#91;required&#93; The bot version of the bot to return metadata for.
#' @param localeId &#91;required&#93; The locale to return the custom vocabulary information for. The locale
#' must be `en_GB`.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_custom_vocabulary_metadata
lexmodelsv2_describe_custom_vocabulary_metadata <- function(botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeCustomVocabularyMetadata",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_custom_vocabulary_metadata_input(botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_custom_vocabulary_metadata_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_custom_vocabulary_metadata <- lexmodelsv2_describe_custom_vocabulary_metadata

#' Gets information about a specific export
#'
#' @description
#' Gets information about a specific export.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_export/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_export/) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier of the export to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_export
lexmodelsv2_describe_export <- function(exportId) {
  op <- new_operation(
    name = "DescribeExport",
    http_method = "GET",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_export_input(exportId = exportId)
  output <- .lexmodelsv2$describe_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_export <- lexmodelsv2_describe_export

#' Gets information about a specific import
#'
#' @description
#' Gets information about a specific import.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_import/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_import/) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier of the import to describe.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_import
lexmodelsv2_describe_import <- function(importId) {
  op <- new_operation(
    name = "DescribeImport",
    http_method = "GET",
    http_path = "/imports/{importId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_import_input(importId = importId)
  output <- .lexmodelsv2$describe_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_import <- lexmodelsv2_describe_import

#' Returns metadata about an intent
#'
#' @description
#' Returns metadata about an intent.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_intent/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_intent/) for full documentation.
#'
#' @param intentId &#91;required&#93; The identifier of the intent to describe.
#' @param botId &#91;required&#93; The identifier of the bot associated with the intent.
#' @param botVersion &#91;required&#93; The version of the bot associated with the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intent to describe. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_intent
lexmodelsv2_describe_intent <- function(intentId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeIntent",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_intent_input(intentId = intentId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_intent <- lexmodelsv2_describe_intent

#' Gets the resource policy and policy revision for a bot or bot alias
#'
#' @description
#' Gets the resource policy and policy revision for a bot or bot alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_resource_policy/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_resource_policy
lexmodelsv2_describe_resource_policy <- function(resourceArn) {
  op <- new_operation(
    name = "DescribeResourcePolicy",
    http_method = "GET",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_resource_policy_input(resourceArn = resourceArn)
  output <- .lexmodelsv2$describe_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_resource_policy <- lexmodelsv2_describe_resource_policy

#' Gets metadata information about a slot
#'
#' @description
#' Gets metadata information about a slot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_slot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_slot/) for full documentation.
#'
#' @param slotId &#91;required&#93; The unique identifier for the slot.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot to describe. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_slot
lexmodelsv2_describe_slot <- function(slotId, botId, botVersion, localeId, intentId) {
  op <- new_operation(
    name = "DescribeSlot",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_slot_input(slotId = slotId, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId)
  output <- .lexmodelsv2$describe_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_slot <- lexmodelsv2_describe_slot

#' Gets metadata information about a slot type
#'
#' @description
#' Gets metadata information about a slot type.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_slot_type/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_slot_type/) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The identifier of the slot type.
#' @param botId &#91;required&#93; The identifier of the bot associated with the slot type.
#' @param botVersion &#91;required&#93; The version of the bot associated with the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot type to describe.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_slot_type
lexmodelsv2_describe_slot_type <- function(slotTypeId, botId, botVersion, localeId) {
  op <- new_operation(
    name = "DescribeSlotType",
    http_method = "GET",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_slot_type_input(slotTypeId = slotTypeId, botId = botId, botVersion = botVersion, localeId = localeId)
  output <- .lexmodelsv2$describe_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_slot_type <- lexmodelsv2_describe_slot_type

#' Gets metadata information about the test execution
#'
#' @description
#' Gets metadata information about the test execution.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_execution/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_execution/) for full documentation.
#'
#' @param testExecutionId &#91;required&#93; The execution Id of the test set execution.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_test_execution
lexmodelsv2_describe_test_execution <- function(testExecutionId) {
  op <- new_operation(
    name = "DescribeTestExecution",
    http_method = "GET",
    http_path = "/testexecutions/{testExecutionId}",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_test_execution_input(testExecutionId = testExecutionId)
  output <- .lexmodelsv2$describe_test_execution_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_test_execution <- lexmodelsv2_describe_test_execution

#' Gets metadata information about the test set
#'
#' @description
#' Gets metadata information about the test set.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The test set Id for the test set request.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_test_set
lexmodelsv2_describe_test_set <- function(testSetId) {
  op <- new_operation(
    name = "DescribeTestSet",
    http_method = "GET",
    http_path = "/testsets/{testSetId}",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_test_set_input(testSetId = testSetId)
  output <- .lexmodelsv2$describe_test_set_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_test_set <- lexmodelsv2_describe_test_set

#' Gets metadata information about the test set discrepancy report
#'
#' @description
#' Gets metadata information about the test set discrepancy report.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set_discrepancy_report/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set_discrepancy_report/) for full documentation.
#'
#' @param testSetDiscrepancyReportId &#91;required&#93; The unique identifier of the test set discrepancy report.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_test_set_discrepancy_report
lexmodelsv2_describe_test_set_discrepancy_report <- function(testSetDiscrepancyReportId) {
  op <- new_operation(
    name = "DescribeTestSetDiscrepancyReport",
    http_method = "GET",
    http_path = "/testsetdiscrepancy/{testSetDiscrepancyReportId}",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_test_set_discrepancy_report_input(testSetDiscrepancyReportId = testSetDiscrepancyReportId)
  output <- .lexmodelsv2$describe_test_set_discrepancy_report_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_test_set_discrepancy_report <- lexmodelsv2_describe_test_set_discrepancy_report

#' Gets metadata information about the test set generation
#'
#' @description
#' Gets metadata information about the test set generation.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set_generation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_describe_test_set_generation/) for full documentation.
#'
#' @param testSetGenerationId &#91;required&#93; The unique identifier of the test set generation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_describe_test_set_generation
lexmodelsv2_describe_test_set_generation <- function(testSetGenerationId) {
  op <- new_operation(
    name = "DescribeTestSetGeneration",
    http_method = "GET",
    http_path = "/testsetgenerations/{testSetGenerationId}",
    paginator = list()
  )
  input <- .lexmodelsv2$describe_test_set_generation_input(testSetGenerationId = testSetGenerationId)
  output <- .lexmodelsv2$describe_test_set_generation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$describe_test_set_generation <- lexmodelsv2_describe_test_set_generation

#' The pre-signed Amazon S3 URL to download the test execution result
#' artifacts
#'
#' @description
#' The pre-signed Amazon S3 URL to download the test execution result artifacts.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_get_test_execution_artifacts_url/](https://www.paws-r-sdk.com/docs/lexmodelsv2_get_test_execution_artifacts_url/) for full documentation.
#'
#' @param testExecutionId &#91;required&#93; The unique identifier of the completed test execution.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_get_test_execution_artifacts_url
lexmodelsv2_get_test_execution_artifacts_url <- function(testExecutionId) {
  op <- new_operation(
    name = "GetTestExecutionArtifactsUrl",
    http_method = "GET",
    http_path = "/testexecutions/{testExecutionId}/artifacturl",
    paginator = list()
  )
  input <- .lexmodelsv2$get_test_execution_artifacts_url_input(testExecutionId = testExecutionId)
  output <- .lexmodelsv2$get_test_execution_artifacts_url_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$get_test_execution_artifacts_url <- lexmodelsv2_get_test_execution_artifacts_url

#' Provides a list of utterances that users have sent to the bot
#'
#' @description
#' Provides a list of utterances that users have sent to the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_aggregated_utterances/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_aggregated_utterances/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with this request.
#' @param botAliasId The identifier of the bot alias associated with this request. If you
#' specify the bot alias, you can't specify the bot version.
#' @param botVersion The identifier of the bot version associated with this request. If you
#' specify the bot version, you can't specify the bot alias.
#' @param localeId &#91;required&#93; The identifier of the language and locale where the utterances were
#' collected. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param aggregationDuration &#91;required&#93; The time window for aggregating the utterance information. You can
#' specify a time between one hour and two weeks.
#' @param sortBy Specifies sorting parameters for the list of utterances. You can sort by
#' the hit count, the missed count, or the number of distinct sessions the
#' utterance appeared in.
#' @param filters Provides the specification of a filter used to limit the utterances in
#' the response to only those that match the filter specification. You can
#' only specify one filter and one string to filter on.
#' @param maxResults The maximum number of utterances to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned. If you don't specify the `maxResults`
#' parameter, 1,000 results are returned.
#' @param nextToken If the response from the
#' [`list_aggregated_utterances`][lexmodelsv2_list_aggregated_utterances]
#' operation contains more results that specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_aggregated_utterances
lexmodelsv2_list_aggregated_utterances <- function(botId, botAliasId = NULL, botVersion = NULL, localeId, aggregationDuration, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAggregatedUtterances",
    http_method = "POST",
    http_path = "/bots/{botId}/aggregatedutterances/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_aggregated_utterances_input(botId = botId, botAliasId = botAliasId, botVersion = botVersion, localeId = localeId, aggregationDuration = aggregationDuration, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_aggregated_utterances_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_aggregated_utterances <- lexmodelsv2_list_aggregated_utterances

#' Gets a list of aliases for the specified bot
#'
#' @description
#' Gets a list of aliases for the specified bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_aliases/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_aliases/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list aliases for.
#' @param maxResults The maximum number of aliases to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_bot_aliases`][lexmodelsv2_list_bot_aliases] operation contains
#' more results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token in the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_aliases
lexmodelsv2_list_bot_aliases <- function(botId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotAliases",
    http_method = "POST",
    http_path = "/bots/{botId}/botaliases/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_bot_aliases_input(botId = botId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_aliases_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_aliases <- lexmodelsv2_list_bot_aliases

#' Gets a list of locales for the specified bot
#'
#' @description
#' Gets a list of locales for the specified bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_locales/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_locales/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list locales for.
#' @param botVersion &#91;required&#93; The version of the bot to list locales for.
#' @param sortBy Specifies sorting parameters for the list of locales. You can sort by
#' locale name in ascending or descending order.
#' @param filters Provides the specification for a filter used to limit the response to
#' only those locales that match the filter specification. You can only
#' specify one filter and one value to filter on.
#' @param maxResults The maximum number of aliases to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_bot_locales`][lexmodelsv2_list_bot_locales] operation contains
#' more results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token as the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_locales
lexmodelsv2_list_bot_locales <- function(botId, botVersion, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotLocales",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_bot_locales_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_locales_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_locales <- lexmodelsv2_list_bot_locales

#' Get a list of bot recommendations that meet the specified criteria
#'
#' @description
#' Get a list of bot recommendations that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_recommendations/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_recommendations/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the bot recommendation
#' list.
#' @param botVersion &#91;required&#93; The version of the bot that contains the bot recommendation list.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation
#' list.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the ListBotRecommendation operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_recommendations
lexmodelsv2_list_bot_recommendations <- function(botId, botVersion, localeId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotRecommendations",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_bot_recommendations_input(botId = botId, botVersion = botVersion, localeId = localeId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_recommendations_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_recommendations <- lexmodelsv2_list_bot_recommendations

#' Gets information about all of the versions of a bot
#'
#' @description
#' Gets information about all of the versions of a bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_versions/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bot_versions/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot to list versions for.
#' @param sortBy Specifies sorting parameters for the list of versions. You can specify
#' that the list be sorted by version name in either ascending or
#' descending order.
#' @param maxResults The maximum number of versions to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response to the `ListBotVersion` operation contains more results
#' than specified in the `maxResults` parameter, a token is returned in the
#' response. Use that token in the `nextToken` parameter to return the next
#' page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bot_versions
lexmodelsv2_list_bot_versions <- function(botId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBotVersions",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_bot_versions_input(botId = botId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bot_versions_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bot_versions <- lexmodelsv2_list_bot_versions

#' Gets a list of available bots
#'
#' @description
#' Gets a list of available bots.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bots/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_bots/) for full documentation.
#'
#' @param sortBy Specifies sorting parameters for the list of bots. You can specify that
#' the list be sorted by bot name in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the bots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of bots to return in each page of results. If there
#' are fewer results than the maximum page size, only the actual number of
#' results are returned.
#' @param nextToken If the response from the [`list_bots`][lexmodelsv2_list_bots] operation
#' contains more results than specified in the `maxResults` parameter, a
#' token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_bots`][lexmodelsv2_list_bots] request to return the next page of
#' results. For a complete set of results, call the
#' [`list_bots`][lexmodelsv2_list_bots] operation until the `nextToken`
#' returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_bots
lexmodelsv2_list_bots <- function(sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBots",
    http_method = "POST",
    http_path = "/bots/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_bots_input(sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_bots_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_bots <- lexmodelsv2_list_bots

#' Gets a list of built-in intents provided by Amazon Lex that you can use
#' in your bot
#'
#' @description
#' Gets a list of built-in intents provided by Amazon Lex that you can use in your bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_built_in_intents/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_built_in_intents/) for full documentation.
#'
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intents to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Specifies sorting parameters for the list of built-in intents. You can
#' specify that the list be sorted by the built-in intent signature in
#' either ascending or descending order.
#' @param maxResults The maximum number of built-in intents to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the
#' [`list_built_in_intents`][lexmodelsv2_list_built_in_intents] operation
#' contains more results than specified in the `maxResults` parameter, a
#' token is returned in the response. Use that token in the `nextToken`
#' parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_built_in_intents
lexmodelsv2_list_built_in_intents <- function(localeId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuiltInIntents",
    http_method = "POST",
    http_path = "/builtins/locales/{localeId}/intents/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_built_in_intents_input(localeId = localeId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_built_in_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_built_in_intents <- lexmodelsv2_list_built_in_intents

#' Gets a list of built-in slot types that meet the specified criteria
#'
#' @description
#' Gets a list of built-in slot types that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_built_in_slot_types/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_built_in_slot_types/) for full documentation.
#'
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot types to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_built_in_slot_types`][lexmodelsv2_list_built_in_slot_types]
#' operation. You can choose to sort by the slot type signature in either
#' ascending or descending order.
#' @param maxResults The maximum number of built-in slot types to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextToken If the response from the
#' [`list_built_in_slot_types`][lexmodelsv2_list_built_in_slot_types]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_built_in_slot_types
lexmodelsv2_list_built_in_slot_types <- function(localeId, sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListBuiltInSlotTypes",
    http_method = "POST",
    http_path = "/builtins/locales/{localeId}/slottypes/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_built_in_slot_types_input(localeId = localeId, sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_built_in_slot_types_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_built_in_slot_types <- lexmodelsv2_list_built_in_slot_types

#' Paginated list of custom vocabulary items for a given bot locale's
#' custom vocabulary
#'
#' @description
#' Paginated list of custom vocabulary items for a given bot locale's custom vocabulary.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_custom_vocabulary_items/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_custom_vocabulary_items/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the version of the bot associated with this custom
#' vocabulary.
#' @param botVersion &#91;required&#93; The bot version of the bot to the list custom vocabulary request.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this custom vocabulary
#' is used. The string must match one of the supported locales. For more
#' information, see Supported languages
#' (https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param maxResults The maximum number of items returned by the list operation.
#' @param nextToken The nextToken identifier to the list custom vocabulary request.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_custom_vocabulary_items
lexmodelsv2_list_custom_vocabulary_items <- function(botId, botVersion, localeId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCustomVocabularyItems",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/list",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_custom_vocabulary_items_input(botId = botId, botVersion = botVersion, localeId = localeId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_custom_vocabulary_items_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_custom_vocabulary_items <- lexmodelsv2_list_custom_vocabulary_items

#' Lists the exports for a bot, bot locale, or custom vocabulary
#'
#' @description
#' Lists the exports for a bot, bot locale, or custom vocabulary. Exports are kept in the list for 7 days.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_exports/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_exports/) for full documentation.
#'
#' @param botId The unique identifier that Amazon Lex assigned to the bot.
#' @param botVersion The version of the bot to list exports for.
#' @param sortBy Determines the field that the list of exports is sorted by. You can sort
#' by the `LastUpdatedDateTime` field in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the exports in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of exports to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_exports`][lexmodelsv2_list_exports]
#' operation contains more results that specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_exports`][lexmodelsv2_list_exports] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_exports`][lexmodelsv2_list_exports] operation until the
#' `nextToken` returned in the response is null.
#' @param localeId Specifies the resources that should be exported. If you don't specify a
#' resource type in the `filters` parameter, both bot locales and custom
#' vocabularies are exported.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_exports
lexmodelsv2_list_exports <- function(botId = NULL, botVersion = NULL, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL, localeId = NULL) {
  op <- new_operation(
    name = "ListExports",
    http_method = "POST",
    http_path = "/exports/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_exports_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken, localeId = localeId)
  output <- .lexmodelsv2$list_exports_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_exports <- lexmodelsv2_list_exports

#' Lists the imports for a bot, bot locale, or custom vocabulary
#'
#' @description
#' Lists the imports for a bot, bot locale, or custom vocabulary. Imports are kept in the list for 7 days.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_imports/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_imports/) for full documentation.
#'
#' @param botId The unique identifier that Amazon Lex assigned to the bot.
#' @param botVersion The version of the bot to list imports for.
#' @param sortBy Determines the field that the list of imports is sorted by. You can sort
#' by the `LastUpdatedDateTime` field in ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the bots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and one string to filter on.
#' @param maxResults The maximum number of imports to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_imports`][lexmodelsv2_list_imports]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_imports`][lexmodelsv2_list_imports] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_imports`][lexmodelsv2_list_imports] operation until the
#' `nextToken` returned in the response is null.
#' @param localeId Specifies the locale that should be present in the list. If you don't
#' specify a resource type in the `filters` parameter, the list contains
#' both bot locales and custom vocabularies.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_imports
lexmodelsv2_list_imports <- function(botId = NULL, botVersion = NULL, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL, localeId = NULL) {
  op <- new_operation(
    name = "ListImports",
    http_method = "POST",
    http_path = "/imports/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_imports_input(botId = botId, botVersion = botVersion, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken, localeId = localeId)
  output <- .lexmodelsv2$list_imports_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_imports <- lexmodelsv2_list_imports

#' Retrieves summary metrics for the intents in your bot
#'
#' @description
#' Retrieves summary metrics for the intents in your bot. The following fields are required:
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_metrics/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_metrics/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve intent
#' metrics.
#' @param startDateTime &#91;required&#93; The timestamp that marks the beginning of the range of time for which
#' you want to see intent metrics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see intent metrics.
#' @param metrics &#91;required&#93; A list of objects, each of which contains a metric you want to list, the
#' statistic for the metric you want to return, and the order by which to
#' organize the results.
#' @param binBy A list of objects, each of which contains specifications for organizing
#' the results by time.
#' @param groupBy A list of objects, each of which specifies how to group the results. You
#' can group by the following criteria:
#' 
#' -   `IntentName` – The name of the intent.
#' 
#' -   `IntentEndState` – The final state of the intent. The possible end
#'     states are detailed in Key definitions in the user guide.
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListIntentMetrics operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response.
#' 
#' Use the returned token in the nextToken parameter of a ListIntentMetrics
#' request to return the next page of results. For a complete set of
#' results, call the ListIntentMetrics operation until the nextToken
#' returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_intent_metrics
lexmodelsv2_list_intent_metrics <- function(botId, startDateTime, endDateTime, metrics, binBy = NULL, groupBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIntentMetrics",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/intentmetrics",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_intent_metrics_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, metrics = metrics, binBy = binBy, groupBy = groupBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_intent_metrics_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_intent_metrics <- lexmodelsv2_list_intent_metrics

#' Retrieves summary statistics for a path of intents that users take over
#' sessions with your bot
#'
#' @description
#' Retrieves summary statistics for a path of intents that users take over sessions with your bot. The following fields are required:
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_paths/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_paths/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve intent path
#' metrics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see intent path metrics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see intent path metrics.
#' @param intentPath &#91;required&#93; The intent path for which you want to retrieve metrics. Use a forward
#' slash to separate intents in the path. For example:
#' 
#' -   /BookCar
#' 
#' -   /BookCar/BookHotel
#' 
#' -   /BookHotel/BookCar
#' @param filters A list of objects, each describes a condition by which you want to
#' filter the results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_intent_paths
lexmodelsv2_list_intent_paths <- function(botId, startDateTime, endDateTime, intentPath, filters = NULL) {
  op <- new_operation(
    name = "ListIntentPaths",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/intentpaths",
    paginator = list()
  )
  input <- .lexmodelsv2$list_intent_paths_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, intentPath = intentPath, filters = filters)
  output <- .lexmodelsv2$list_intent_paths_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_intent_paths <- lexmodelsv2_list_intent_paths

#' Retrieves summary metrics for the stages within intents in your bot
#'
#' @description
#' Retrieves summary metrics for the stages within intents in your bot. The following fields are required:
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_stage_metrics/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intent_stage_metrics/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve intent stage
#' metrics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see intent stage metrics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see intent stage metrics.
#' @param metrics &#91;required&#93; A list of objects, each of which contains a metric you want to list, the
#' statistic for the metric you want to return, and the method by which to
#' organize the results.
#' @param binBy A list of objects, each of which contains specifications for organizing
#' the results by time.
#' @param groupBy A list of objects, each of which specifies how to group the results. You
#' can group by the following criteria:
#' 
#' -   `IntentStageName` – The name of the intent stage.
#' 
#' -   `SwitchedToIntent` – The intent to which the conversation was
#'     switched (if any).
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListIntentStageMetrics operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response.
#' 
#' Use the returned token in the nextToken parameter of a
#' ListIntentStageMetrics request to return the next page of results. For a
#' complete set of results, call the ListIntentStageMetrics operation until
#' the nextToken returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_intent_stage_metrics
lexmodelsv2_list_intent_stage_metrics <- function(botId, startDateTime, endDateTime, metrics, binBy = NULL, groupBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIntentStageMetrics",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/intentstagemetrics",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_intent_stage_metrics_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, metrics = metrics, binBy = binBy, groupBy = groupBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_intent_stage_metrics_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_intent_stage_metrics <- lexmodelsv2_list_intent_stage_metrics

#' Get a list of intents that meet the specified criteria
#'
#' @description
#' Get a list of intents that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intents/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_intents/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the intent.
#' @param botVersion &#91;required&#93; The version of the bot that contains the intent.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the intents to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_intents`][lexmodelsv2_list_intents] operation. You can choose to
#' sort by the intent name or last updated date in either ascending or
#' descending order.
#' @param filters Provides the specification of a filter used to limit the intents in the
#' response to only those that match the filter specification. You can only
#' specify one filter and only one string to filter on.
#' @param maxResults The maximum number of intents to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the [`list_intents`][lexmodelsv2_list_intents]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response.
#' 
#' Use the returned token in the `nextToken` parameter of a
#' [`list_intents`][lexmodelsv2_list_intents] request to return the next
#' page of results. For a complete set of results, call the
#' [`list_intents`][lexmodelsv2_list_intents] operation until the
#' `nextToken` returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_intents
lexmodelsv2_list_intents <- function(botId, botVersion, localeId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListIntents",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_intents_input(botId = botId, botVersion = botVersion, localeId = localeId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_intents <- lexmodelsv2_list_intents

#' Gets a list of recommended intents provided by the bot recommendation
#' that you can use in your bot
#'
#' @description
#' Gets a list of recommended intents provided by the bot recommendation that you can use in your bot. Intents in the response are ordered by relevance.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_recommended_intents/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_recommended_intents/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the recommended
#' intents.
#' @param botVersion &#91;required&#93; The version of the bot that contains the recommended intents.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the recommended intents.
#' @param botRecommendationId &#91;required&#93; The identifier of the bot recommendation that contains the recommended
#' intents.
#' @param nextToken If the response from the ListRecommendedIntents operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_recommended_intents
lexmodelsv2_list_recommended_intents <- function(botId, botVersion, localeId, botRecommendationId, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRecommendedIntents",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_recommended_intents_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, nextToken = nextToken, maxResults = maxResults)
  output <- .lexmodelsv2$list_recommended_intents_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_recommended_intents <- lexmodelsv2_list_recommended_intents

#' Retrieves a list of metadata for individual user sessions with your bot
#'
#' @description
#' Retrieves a list of metadata for individual user sessions with your bot. The `startDateTime` and `endDateTime` fields are required. These fields define a time range for which you want to retrieve results. Of the optional fields, you can organize the results in the following ways:
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_session_analytics_data/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_session_analytics_data/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve session
#' analytics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see session analytics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see session analytics.
#' @param sortBy An object specifying the measure and method by which to sort the session
#' analytics data.
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListSessionAnalyticsData operation contains
#' more results than specified in the maxResults parameter, a token is
#' returned in the response.
#' 
#' Use the returned token in the nextToken parameter of a
#' ListSessionAnalyticsData request to return the next page of results. For
#' a complete set of results, call the ListSessionAnalyticsData operation
#' until the nextToken returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_session_analytics_data
lexmodelsv2_list_session_analytics_data <- function(botId, startDateTime, endDateTime, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSessionAnalyticsData",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/sessions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_session_analytics_data_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_session_analytics_data_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_session_analytics_data <- lexmodelsv2_list_session_analytics_data

#' Retrieves summary metrics for the user sessions with your bot
#'
#' @description
#' Retrieves summary metrics for the user sessions with your bot. The following fields are required:
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_session_metrics/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_session_metrics/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve session
#' metrics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see session metrics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see session metrics.
#' @param metrics &#91;required&#93; A list of objects, each of which contains a metric you want to list, the
#' statistic for the metric you want to return, and the method by which to
#' organize the results.
#' @param binBy A list of objects, each of which contains specifications for organizing
#' the results by time.
#' @param groupBy A list of objects, each of which specifies how to group the results. You
#' can group by the following criteria:
#' 
#' -   `ConversationEndState` – The final state of the conversation. The
#'     possible end states are detailed in Key definitions in the user
#'     guide.
#' 
#' -   `LocaleId` – The unique identifier of the bot locale.
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListSessionMetrics operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response.
#' 
#' Use the returned token in the nextToken parameter of a
#' ListSessionMetrics request to return the next page of results. For a
#' complete set of results, call the ListSessionMetrics operation until the
#' nextToken returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_session_metrics
lexmodelsv2_list_session_metrics <- function(botId, startDateTime, endDateTime, metrics, binBy = NULL, groupBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSessionMetrics",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/sessionmetrics",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_session_metrics_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, metrics = metrics, binBy = binBy, groupBy = groupBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_session_metrics_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_session_metrics <- lexmodelsv2_list_session_metrics

#' Gets a list of slot types that match the specified criteria
#'
#' @description
#' Gets a list of slot types that match the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_slot_types/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_slot_types/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the slot types.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot type.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slot types to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param sortBy Determines the sort order for the response from the
#' [`list_slot_types`][lexmodelsv2_list_slot_types] operation. You can
#' choose to sort by the slot type name or last updated date in either
#' ascending or descending order.
#' @param filters Provides the specification of a filter used to limit the slot types in
#' the response to only those that match the filter specification. You can
#' only specify one filter and only one string to filter on.
#' @param maxResults The maximum number of slot types to return in each page of results. If
#' there are fewer results than the max page size, only the actual number
#' of results are returned.
#' @param nextToken If the response from the
#' [`list_slot_types`][lexmodelsv2_list_slot_types] operation contains more
#' results than specified in the `maxResults` parameter, a token is
#' returned in the response. Use that token in the `nextToken` parameter to
#' return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_slot_types
lexmodelsv2_list_slot_types <- function(botId, botVersion, localeId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSlotTypes",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_slot_types_input(botId = botId, botVersion = botVersion, localeId = localeId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_slot_types_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_slot_types <- lexmodelsv2_list_slot_types

#' Gets a list of slots that match the specified criteria
#'
#' @description
#' Gets a list of slots that match the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_slots/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_slots/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier of the bot that contains the slot.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the slots to list. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The unique identifier of the intent that contains the slot.
#' @param sortBy Determines the sort order for the response from the
#' [`list_slots`][lexmodelsv2_list_slots] operation. You can choose to sort
#' by the slot name or last updated date in either ascending or descending
#' order.
#' @param filters Provides the specification of a filter used to limit the slots in the
#' response to only those that match the filter specification. You can only
#' specify one filter and only one string to filter on.
#' @param maxResults The maximum number of slots to return in each page of results. If there
#' are fewer results than the max page size, only the actual number of
#' results are returned.
#' @param nextToken If the response from the [`list_slots`][lexmodelsv2_list_slots]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_slots
lexmodelsv2_list_slots <- function(botId, botVersion, localeId, intentId, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSlots",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_slots_input(botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_slots_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_slots <- lexmodelsv2_list_slots

#' Gets a list of tags associated with a resource
#'
#' @description
#' Gets a list of tags associated with a resource. Only bots, bot aliases, and bot channels can have tags associated with them.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_tags_for_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get a list of tags
#' for.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_tags_for_resource
lexmodelsv2_list_tags_for_resource <- function(resourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$list_tags_for_resource_input(resourceARN = resourceARN)
  output <- .lexmodelsv2$list_tags_for_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_tags_for_resource <- lexmodelsv2_list_tags_for_resource

#' Gets a list of test execution result items
#'
#' @description
#' Gets a list of test execution result items.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_execution_result_items/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_execution_result_items/) for full documentation.
#'
#' @param testExecutionId &#91;required&#93; The unique identifier of the test execution to list the result items.
#' @param resultFilterBy &#91;required&#93; The filter for the list of results from the test set execution.
#' @param maxResults The maximum number of test execution result items to return in each
#' page. If there are fewer results than the max page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the
#' [`list_test_execution_result_items`][lexmodelsv2_list_test_execution_result_items]
#' operation contains more results than specified in the `maxResults`
#' parameter, a token is returned in the response. Use that token in the
#' `nextToken` parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_test_execution_result_items
lexmodelsv2_list_test_execution_result_items <- function(testExecutionId, resultFilterBy, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestExecutionResultItems",
    http_method = "POST",
    http_path = "/testexecutions/{testExecutionId}/results",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_test_execution_result_items_input(testExecutionId = testExecutionId, resultFilterBy = resultFilterBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_test_execution_result_items_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_test_execution_result_items <- lexmodelsv2_list_test_execution_result_items

#' The list of test set executions
#'
#' @description
#' The list of test set executions.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_executions/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_executions/) for full documentation.
#'
#' @param sortBy The sort order of the test set executions.
#' @param maxResults The maximum number of test executions to return in each page. If there
#' are fewer results than the max page size, only the actual number of
#' results are returned.
#' @param nextToken If the response from the ListTestExecutions operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_test_executions
lexmodelsv2_list_test_executions <- function(sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestExecutions",
    http_method = "POST",
    http_path = "/testexecutions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_test_executions_input(sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_test_executions_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_test_executions <- lexmodelsv2_list_test_executions

#' The list of test set records
#'
#' @description
#' The list of test set records.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_set_records/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_set_records/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The identifier of the test set to list its test set records.
#' @param maxResults The maximum number of test set records to return in each page. If there
#' are fewer records than the max page size, only the actual number of
#' records are returned.
#' @param nextToken If the response from the ListTestSetRecords operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response. Use that token in the nextToken parameter to return the
#' next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_test_set_records
lexmodelsv2_list_test_set_records <- function(testSetId, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestSetRecords",
    http_method = "POST",
    http_path = "/testsets/{testSetId}/records",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_test_set_records_input(testSetId = testSetId, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_test_set_records_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_test_set_records <- lexmodelsv2_list_test_set_records

#' The list of the test sets
#'
#' @description
#' The list of the test sets
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_sets/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_test_sets/) for full documentation.
#'
#' @param sortBy The sort order for the list of test sets.
#' @param maxResults The maximum number of test sets to return in each page. If there are
#' fewer results than the max page size, only the actual number of results
#' are returned.
#' @param nextToken If the response from the ListTestSets operation contains more results
#' than specified in the maxResults parameter, a token is returned in the
#' response. Use that token in the nextToken parameter to return the next
#' page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_test_sets
lexmodelsv2_list_test_sets <- function(sortBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListTestSets",
    http_method = "POST",
    http_path = "/testsets",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_test_sets_input(sortBy = sortBy, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_test_sets_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_test_sets <- lexmodelsv2_list_test_sets

#' To use this API operation, your IAM role must have permissions to
#' perform the ListAggregatedUtterances operation, which provides access to
#' utterance-related analytics
#'
#' @description
#' To use this API operation, your IAM role must have permissions to perform the [`list_aggregated_utterances`][lexmodelsv2_list_aggregated_utterances] operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/) for the IAM policy to apply to the IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_utterance_analytics_data/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_utterance_analytics_data/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve utterance
#' analytics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see utterance analytics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see utterance analytics.
#' @param sortBy An object specifying the measure and method by which to sort the
#' utterance analytics data.
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListUtteranceAnalyticsData operation contains
#' more results than specified in the maxResults parameter, a token is
#' returned in the response.
#' 
#' Use the returned token in the nextToken parameter of a
#' ListUtteranceAnalyticsData request to return the next page of results.
#' For a complete set of results, call the ListUtteranceAnalyticsData
#' operation until the nextToken returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_utterance_analytics_data
lexmodelsv2_list_utterance_analytics_data <- function(botId, startDateTime, endDateTime, sortBy = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUtteranceAnalyticsData",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/utterances",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_utterance_analytics_data_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, sortBy = sortBy, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_utterance_analytics_data_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_utterance_analytics_data <- lexmodelsv2_list_utterance_analytics_data

#' To use this API operation, your IAM role must have permissions to
#' perform the ListAggregatedUtterances operation, which provides access to
#' utterance-related analytics
#'
#' @description
#' To use this API operation, your IAM role must have permissions to perform the [`list_aggregated_utterances`][lexmodelsv2_list_aggregated_utterances] operation, which provides access to utterance-related analytics. See [Viewing utterance statistics](https://docs.aws.amazon.com/lexv2/latest/dg/) for the IAM policy to apply to the IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_list_utterance_metrics/](https://www.paws-r-sdk.com/docs/lexmodelsv2_list_utterance_metrics/) for full documentation.
#'
#' @param botId &#91;required&#93; The identifier for the bot for which you want to retrieve utterance
#' metrics.
#' @param startDateTime &#91;required&#93; The date and time that marks the beginning of the range of time for
#' which you want to see utterance metrics.
#' @param endDateTime &#91;required&#93; The date and time that marks the end of the range of time for which you
#' want to see utterance metrics.
#' @param metrics &#91;required&#93; A list of objects, each of which contains a metric you want to list, the
#' statistic for the metric you want to return, and the method by which to
#' organize the results.
#' @param binBy A list of objects, each of which contains specifications for organizing
#' the results by time.
#' @param groupBy A list of objects, each of which specifies how to group the results. You
#' can group by the following criteria:
#' 
#' -   `UtteranceText` – The transcription of the utterance.
#' 
#' -   `UtteranceState` – The state of the utterance. The possible states
#'     are detailed in Key definitions in the user guide.
#' @param attributes A list containing attributes related to the utterance that you want the
#' response to return. The following attributes are possible:
#' 
#' -   `LastUsedIntent` – The last used intent at the time of the
#'     utterance.
#' @param filters A list of objects, each of which describes a condition by which you want
#' to filter the results.
#' @param maxResults The maximum number of results to return in each page of results. If
#' there are fewer results than the maximum page size, only the actual
#' number of results are returned.
#' @param nextToken If the response from the ListUtteranceMetrics operation contains more
#' results than specified in the maxResults parameter, a token is returned
#' in the response.
#' 
#' Use the returned token in the nextToken parameter of a
#' ListUtteranceMetrics request to return the next page of results. For a
#' complete set of results, call the ListUtteranceMetrics operation until
#' the nextToken returned in the response is null.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_list_utterance_metrics
lexmodelsv2_list_utterance_metrics <- function(botId, startDateTime, endDateTime, metrics, binBy = NULL, groupBy = NULL, attributes = NULL, filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListUtteranceMetrics",
    http_method = "POST",
    http_path = "/bots/{botId}/analytics/utterancemetrics",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults")
  )
  input <- .lexmodelsv2$list_utterance_metrics_input(botId = botId, startDateTime = startDateTime, endDateTime = endDateTime, metrics = metrics, binBy = binBy, groupBy = groupBy, attributes = attributes, filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .lexmodelsv2$list_utterance_metrics_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$list_utterance_metrics <- lexmodelsv2_list_utterance_metrics

#' Search for associated transcripts that meet the specified criteria
#'
#' @description
#' Search for associated transcripts that meet the specified criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_search_associated_transcripts/](https://www.paws-r-sdk.com/docs/lexmodelsv2_search_associated_transcripts/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot associated with the transcripts that
#' you are searching.
#' @param botVersion &#91;required&#93; The version of the bot containing the transcripts that you are
#' searching.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the transcripts to search.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param botRecommendationId &#91;required&#93; The unique identifier of the bot recommendation associated with the
#' transcripts to search.
#' @param searchOrder How SearchResults are ordered. Valid values are Ascending or Descending.
#' The default is Descending.
#' @param filters &#91;required&#93; A list of filter objects.
#' @param maxResults The maximum number of bot recommendations to return in each page of
#' results. If there are fewer results than the max page size, only the
#' actual number of results are returned.
#' @param nextIndex If the response from the SearchAssociatedTranscriptsRequest operation
#' contains more results than specified in the maxResults parameter, an
#' index is returned in the response. Use that index in the nextIndex
#' parameter to return the next page of results.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_search_associated_transcripts
lexmodelsv2_search_associated_transcripts <- function(botId, botVersion, localeId, botRecommendationId, searchOrder = NULL, filters, maxResults = NULL, nextIndex = NULL) {
  op <- new_operation(
    name = "SearchAssociatedTranscripts",
    http_method = "POST",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts",
    paginator = list()
  )
  input <- .lexmodelsv2$search_associated_transcripts_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, searchOrder = searchOrder, filters = filters, maxResults = maxResults, nextIndex = nextIndex)
  output <- .lexmodelsv2$search_associated_transcripts_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$search_associated_transcripts <- lexmodelsv2_search_associated_transcripts

#' Use this to provide your transcript data, and to start the bot
#' recommendation process
#'
#' @description
#' Use this to provide your transcript data, and to start the bot recommendation process.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_start_bot_recommendation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_start_bot_recommendation/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot containing the bot recommendation.
#' @param botVersion &#91;required&#93; The version of the bot containing the bot recommendation.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' start. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param transcriptSourceSetting &#91;required&#93; The object representing the Amazon S3 bucket containing the transcript,
#' as well as the associated metadata.
#' @param encryptionSetting The object representing the passwords that will be used to encrypt the
#' data related to the bot recommendation results, as well as the KMS key
#' ARN used to encrypt the associated metadata.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_bot_recommendation
lexmodelsv2_start_bot_recommendation <- function(botId, botVersion, localeId, transcriptSourceSetting, encryptionSetting = NULL) {
  op <- new_operation(
    name = "StartBotRecommendation",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/",
    paginator = list()
  )
  input <- .lexmodelsv2$start_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, transcriptSourceSetting = transcriptSourceSetting, encryptionSetting = encryptionSetting)
  output <- .lexmodelsv2$start_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_bot_recommendation <- lexmodelsv2_start_bot_recommendation

#' Starts importing a bot, bot locale, or custom vocabulary from a zip
#' archive that you uploaded to an S3 bucket
#'
#' @description
#' Starts importing a bot, bot locale, or custom vocabulary from a zip archive that you uploaded to an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_start_import/](https://www.paws-r-sdk.com/docs/lexmodelsv2_start_import/) for full documentation.
#'
#' @param importId &#91;required&#93; The unique identifier for the import. It is included in the response
#' from the [`create_upload_url`][lexmodelsv2_create_upload_url] operation.
#' @param resourceSpecification &#91;required&#93; Parameters for creating the bot, bot locale or custom vocabulary.
#' @param mergeStrategy &#91;required&#93; The strategy to use when there is a name conflict between the imported
#' resource and an existing resource. When the merge strategy is
#' `FailOnConflict` existing resources are not overwritten and the import
#' fails.
#' @param filePassword The password used to encrypt the zip archive that contains the resource
#' definition. You should always encrypt the zip archive to protect it
#' during transit between your site and Amazon Lex.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_import
lexmodelsv2_start_import <- function(importId, resourceSpecification, mergeStrategy, filePassword = NULL) {
  op <- new_operation(
    name = "StartImport",
    http_method = "PUT",
    http_path = "/imports/",
    paginator = list()
  )
  input <- .lexmodelsv2$start_import_input(importId = importId, resourceSpecification = resourceSpecification, mergeStrategy = mergeStrategy, filePassword = filePassword)
  output <- .lexmodelsv2$start_import_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_import <- lexmodelsv2_start_import

#' The action to start test set execution
#'
#' @description
#' The action to start test set execution.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_start_test_execution/](https://www.paws-r-sdk.com/docs/lexmodelsv2_start_test_execution/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The test set Id for the test set execution.
#' @param target &#91;required&#93; The target bot for the test set execution.
#' @param apiMode &#91;required&#93; Indicates whether we use streaming or non-streaming APIs for the test
#' set execution. For streaming, StartConversation Runtime API is used.
#' Whereas, for non-streaming, RecognizeUtterance and RecognizeText Amazon
#' Lex Runtime API are used.
#' @param testExecutionModality Indicates whether audio or text is used.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_test_execution
lexmodelsv2_start_test_execution <- function(testSetId, target, apiMode, testExecutionModality = NULL) {
  op <- new_operation(
    name = "StartTestExecution",
    http_method = "POST",
    http_path = "/testsets/{testSetId}/testexecutions",
    paginator = list()
  )
  input <- .lexmodelsv2$start_test_execution_input(testSetId = testSetId, target = target, apiMode = apiMode, testExecutionModality = testExecutionModality)
  output <- .lexmodelsv2$start_test_execution_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_test_execution <- lexmodelsv2_start_test_execution

#' The action to start the generation of test set
#'
#' @description
#' The action to start the generation of test set.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_start_test_set_generation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_start_test_set_generation/) for full documentation.
#'
#' @param testSetName &#91;required&#93; The test set name for the test set generation request.
#' @param description The test set description for the test set generation request.
#' @param storageLocation &#91;required&#93; The Amazon S3 storage location for the test set generation.
#' @param generationDataSource &#91;required&#93; The data source for the test set generation.
#' @param roleArn &#91;required&#93; The roleARN used for any operation in the test set to access resources
#' in the Amazon Web Services account.
#' @param testSetTags A list of tags to add to the test set. You can only add tags when you
#' import/generate a new test set. You can't use the
#' [`update_test_set`][lexmodelsv2_update_test_set] operation to update
#' tags. To update tags, use the [`tag_resource`][lexmodelsv2_tag_resource]
#' operation.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_start_test_set_generation
lexmodelsv2_start_test_set_generation <- function(testSetName, description = NULL, storageLocation, generationDataSource, roleArn, testSetTags = NULL) {
  op <- new_operation(
    name = "StartTestSetGeneration",
    http_method = "PUT",
    http_path = "/testsetgenerations",
    paginator = list()
  )
  input <- .lexmodelsv2$start_test_set_generation_input(testSetName = testSetName, description = description, storageLocation = storageLocation, generationDataSource = generationDataSource, roleArn = roleArn, testSetTags = testSetTags)
  output <- .lexmodelsv2$start_test_set_generation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$start_test_set_generation <- lexmodelsv2_start_test_set_generation

#' Stop an already running Bot Recommendation request
#'
#' @description
#' Stop an already running Bot Recommendation request.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_stop_bot_recommendation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_stop_bot_recommendation/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot containing the bot recommendation to be
#' stopped.
#' @param botVersion &#91;required&#93; The version of the bot containing the bot recommendation.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' stop. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param botRecommendationId &#91;required&#93; The unique identifier of the bot recommendation to be stopped.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_stop_bot_recommendation
lexmodelsv2_stop_bot_recommendation <- function(botId, botVersion, localeId, botRecommendationId) {
  op <- new_operation(
    name = "StopBotRecommendation",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/stopbotrecommendation",
    paginator = list()
  )
  input <- .lexmodelsv2$stop_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId)
  output <- .lexmodelsv2$stop_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$stop_bot_recommendation <- lexmodelsv2_stop_bot_recommendation

#' Adds the specified tags to the specified resource
#'
#' @description
#' Adds the specified tags to the specified resource. If a tag key already exists, the existing value is replaced with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_tag_resource/](https://www.paws-r-sdk.com/docs/lexmodelsv2_tag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the bot, bot alias, or bot channel to
#' tag.
#' @param tags &#91;required&#93; A list of tag keys to add to the resource. If a tag key already exists,
#' the existing value is replaced with the new value.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_tag_resource
lexmodelsv2_tag_resource <- function(resourceARN, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$tag_resource_input(resourceARN = resourceARN, tags = tags)
  output <- .lexmodelsv2$tag_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$tag_resource <- lexmodelsv2_tag_resource

#' Removes tags from a bot, bot alias, or bot channel
#'
#' @description
#' Removes tags from a bot, bot alias, or bot channel.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_untag_resource/](https://www.paws-r-sdk.com/docs/lexmodelsv2_untag_resource/) for full documentation.
#'
#' @param resourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove the tags from.
#' @param tagKeys &#91;required&#93; A list of tag keys to remove from the resource. If a tag key does not
#' exist on the resource, it is ignored.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_untag_resource
lexmodelsv2_untag_resource <- function(resourceARN, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceARN}",
    paginator = list()
  )
  input <- .lexmodelsv2$untag_resource_input(resourceARN = resourceARN, tagKeys = tagKeys)
  output <- .lexmodelsv2$untag_resource_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$untag_resource <- lexmodelsv2_untag_resource

#' Updates the configuration of an existing bot
#'
#' @description
#' Updates the configuration of an existing bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot to update. This identifier is returned
#' by the [`create_bot`][lexmodelsv2_create_bot] operation.
#' @param botName &#91;required&#93; The new name of the bot. The name must be unique in the account that
#' creates the bot.
#' @param description A description of the bot.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that has permissions to
#' access the bot.
#' @param dataPrivacy &#91;required&#93; Provides information on additional privacy protections Amazon Lex should
#' use with the bot's data.
#' @param idleSessionTTLInSeconds &#91;required&#93; The time, in seconds, that Amazon Lex should keep information about a
#' user's conversation with the bot.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and Amazon
#' Lex deletes any data provided before the timeout.
#' 
#' You can specify between 60 (1 minute) and 86,400 (24 hours) seconds.
#' @param botType The type of the bot to be updated.
#' @param botMembers The list of bot members in the network associated with the update
#' action.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot
lexmodelsv2_update_bot <- function(botId, botName, description = NULL, roleArn, dataPrivacy, idleSessionTTLInSeconds, botType = NULL, botMembers = NULL) {
  op <- new_operation(
    name = "UpdateBot",
    http_method = "PUT",
    http_path = "/bots/{botId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_input(botId = botId, botName = botName, description = description, roleArn = roleArn, dataPrivacy = dataPrivacy, idleSessionTTLInSeconds = idleSessionTTLInSeconds, botType = botType, botMembers = botMembers)
  output <- .lexmodelsv2$update_bot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot <- lexmodelsv2_update_bot

#' Updates the configuration of an existing bot alias
#'
#' @description
#' Updates the configuration of an existing bot alias.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_alias/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_alias/) for full documentation.
#'
#' @param botAliasId &#91;required&#93; The unique identifier of the bot alias.
#' @param botAliasName &#91;required&#93; The new name to assign to the bot alias.
#' @param description The new description to assign to the bot alias.
#' @param botVersion The new bot version to assign to the bot alias.
#' @param botAliasLocaleSettings The new Lambda functions to use in each locale for the bot alias.
#' @param conversationLogSettings The new settings for storing conversation logs in Amazon CloudWatch Logs
#' and Amazon S3 buckets.
#' @param sentimentAnalysisSettings 
#' @param botId &#91;required&#93; The identifier of the bot with the updated alias.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_alias
lexmodelsv2_update_bot_alias <- function(botAliasId, botAliasName, description = NULL, botVersion = NULL, botAliasLocaleSettings = NULL, conversationLogSettings = NULL, sentimentAnalysisSettings = NULL, botId) {
  op <- new_operation(
    name = "UpdateBotAlias",
    http_method = "PUT",
    http_path = "/bots/{botId}/botaliases/{botAliasId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_alias_input(botAliasId = botAliasId, botAliasName = botAliasName, description = description, botVersion = botVersion, botAliasLocaleSettings = botAliasLocaleSettings, conversationLogSettings = conversationLogSettings, sentimentAnalysisSettings = sentimentAnalysisSettings, botId = botId)
  output <- .lexmodelsv2$update_bot_alias_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_alias <- lexmodelsv2_update_bot_alias

#' Updates the settings that a bot has for a specific locale
#'
#' @description
#' Updates the settings that a bot has for a specific locale.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_locale/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_locale/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the locale.
#' @param botVersion &#91;required&#93; The version of the bot that contains the locale to be updated. The
#' version can only be the `DRAFT` version.
#' @param localeId &#91;required&#93; The identifier of the language and locale to update. The string must
#' match one of the supported locales. For more information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param description The new description of the locale.
#' @param nluIntentConfidenceThreshold &#91;required&#93; The new confidence threshold where Amazon Lex inserts the
#' `AMAZON.FallbackIntent` and `AMAZON.KendraSearchIntent` intents in the
#' list of possible intents for an utterance.
#' @param voiceSettings The new Amazon Polly voice Amazon Lex should use for voice interaction
#' with the user.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_locale
lexmodelsv2_update_bot_locale <- function(botId, botVersion, localeId, description = NULL, nluIntentConfidenceThreshold, voiceSettings = NULL) {
  op <- new_operation(
    name = "UpdateBotLocale",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_locale_input(botId = botId, botVersion = botVersion, localeId = localeId, description = description, nluIntentConfidenceThreshold = nluIntentConfidenceThreshold, voiceSettings = voiceSettings)
  output <- .lexmodelsv2$update_bot_locale_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_locale <- lexmodelsv2_update_bot_locale

#' Updates an existing bot recommendation request
#'
#' @description
#' Updates an existing bot recommendation request.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_recommendation/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_bot_recommendation/) for full documentation.
#'
#' @param botId &#91;required&#93; The unique identifier of the bot containing the bot recommendation to be
#' updated.
#' @param botVersion &#91;required&#93; The version of the bot containing the bot recommendation to be updated.
#' @param localeId &#91;required&#93; The identifier of the language and locale of the bot recommendation to
#' update. The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html)
#' @param botRecommendationId &#91;required&#93; The unique identifier of the bot recommendation to be updated.
#' @param encryptionSetting &#91;required&#93; The object representing the passwords that will be used to encrypt the
#' data related to the bot recommendation results, as well as the KMS key
#' ARN used to encrypt the associated metadata.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_bot_recommendation
lexmodelsv2_update_bot_recommendation <- function(botId, botVersion, localeId, botRecommendationId, encryptionSetting) {
  op <- new_operation(
    name = "UpdateBotRecommendation",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_bot_recommendation_input(botId = botId, botVersion = botVersion, localeId = localeId, botRecommendationId = botRecommendationId, encryptionSetting = encryptionSetting)
  output <- .lexmodelsv2$update_bot_recommendation_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_bot_recommendation <- lexmodelsv2_update_bot_recommendation

#' Updates the password used to protect an export zip archive
#'
#' @description
#' Updates the password used to protect an export zip archive.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_export/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_export/) for full documentation.
#'
#' @param exportId &#91;required&#93; The unique identifier Amazon Lex assigned to the export.
#' @param filePassword The new password to use to encrypt the export zip archive.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_export
lexmodelsv2_update_export <- function(exportId, filePassword = NULL) {
  op <- new_operation(
    name = "UpdateExport",
    http_method = "PUT",
    http_path = "/exports/{exportId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_export_input(exportId = exportId, filePassword = filePassword)
  output <- .lexmodelsv2$update_export_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_export <- lexmodelsv2_update_export

#' Updates the settings for an intent
#'
#' @description
#' Updates the settings for an intent.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_intent/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_intent/) for full documentation.
#'
#' @param intentId &#91;required&#93; The unique identifier of the intent to update.
#' @param intentName &#91;required&#93; The new name for the intent.
#' @param description The new description of the intent.
#' @param parentIntentSignature The signature of the new built-in intent to use as the parent of this
#' intent.
#' @param sampleUtterances New utterances used to invoke the intent.
#' @param dialogCodeHook The new Lambda function to use between each turn of the conversation
#' with the bot.
#' @param fulfillmentCodeHook The new Lambda function to call when all of the intents required slots
#' are provided and the intent is ready for fulfillment.
#' @param slotPriorities A new list of slots and their priorities that are contained by the
#' intent.
#' @param intentConfirmationSetting New prompts that Amazon Lex sends to the user to confirm the completion
#' of an intent.
#' @param intentClosingSetting The new response that Amazon Lex sends the user when the intent is
#' closed.
#' @param inputContexts A new list of contexts that must be active in order for Amazon Lex to
#' consider the intent.
#' @param outputContexts A new list of contexts that Amazon Lex activates when the intent is
#' fulfilled.
#' @param kendraConfiguration New configuration settings for connecting to an Amazon Kendra index.
#' @param botId &#91;required&#93; The identifier of the bot that contains the intent.
#' @param botVersion &#91;required&#93; The version of the bot that contains the intent. Must be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale where this intent is used. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param initialResponseSetting Configuration settings for a response sent to the user before Amazon Lex
#' starts eliciting slots.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_intent
lexmodelsv2_update_intent <- function(intentId, intentName, description = NULL, parentIntentSignature = NULL, sampleUtterances = NULL, dialogCodeHook = NULL, fulfillmentCodeHook = NULL, slotPriorities = NULL, intentConfirmationSetting = NULL, intentClosingSetting = NULL, inputContexts = NULL, outputContexts = NULL, kendraConfiguration = NULL, botId, botVersion, localeId, initialResponseSetting = NULL) {
  op <- new_operation(
    name = "UpdateIntent",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_intent_input(intentId = intentId, intentName = intentName, description = description, parentIntentSignature = parentIntentSignature, sampleUtterances = sampleUtterances, dialogCodeHook = dialogCodeHook, fulfillmentCodeHook = fulfillmentCodeHook, slotPriorities = slotPriorities, intentConfirmationSetting = intentConfirmationSetting, intentClosingSetting = intentClosingSetting, inputContexts = inputContexts, outputContexts = outputContexts, kendraConfiguration = kendraConfiguration, botId = botId, botVersion = botVersion, localeId = localeId, initialResponseSetting = initialResponseSetting)
  output <- .lexmodelsv2$update_intent_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_intent <- lexmodelsv2_update_intent

#' Replaces the existing resource policy for a bot or bot alias with a new
#' one
#'
#' @description
#' Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_resource_policy/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_resource_policy/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the bot or bot alias that the resource
#' policy is attached to.
#' @param policy &#91;required&#93; A resource policy to add to the resource. The policy is a JSON structure
#' that contains one or more statements that define the policy. The policy
#' must follow the IAM syntax. For more information about the contents of a
#' JSON policy document, see [IAM JSON policy
#' reference](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html)
#' .
#' 
#' If the policy isn't valid, Amazon Lex returns a validation exception.
#' @param expectedRevisionId The identifier of the revision of the policy to update. If this revision
#' ID doesn't match the current revision ID, Amazon Lex throws an
#' exception.
#' 
#' If you don't specify a revision, Amazon Lex overwrites the contents of
#' the policy with the new values.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_resource_policy
lexmodelsv2_update_resource_policy <- function(resourceArn, policy, expectedRevisionId = NULL) {
  op <- new_operation(
    name = "UpdateResourcePolicy",
    http_method = "PUT",
    http_path = "/policy/{resourceArn}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_resource_policy_input(resourceArn = resourceArn, policy = policy, expectedRevisionId = expectedRevisionId)
  output <- .lexmodelsv2$update_resource_policy_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_resource_policy <- lexmodelsv2_update_resource_policy

#' Updates the settings for a slot
#'
#' @description
#' Updates the settings for a slot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_slot/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_slot/) for full documentation.
#'
#' @param slotId &#91;required&#93; The unique identifier for the slot to update.
#' @param slotName &#91;required&#93; The new name for the slot.
#' @param description The new description for the slot.
#' @param slotTypeId The unique identifier of the new slot type to associate with this slot.
#' @param valueElicitationSetting &#91;required&#93; A new set of prompts that Amazon Lex sends to the user to elicit a
#' response the provides a value for the slot.
#' @param obfuscationSetting New settings that determine how slot values are formatted in Amazon
#' CloudWatch logs.
#' @param botId &#91;required&#93; The unique identifier of the bot that contains the slot.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot. Must always be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale that contains the slot. The
#' string must match one of the supported locales. For more information,
#' see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param intentId &#91;required&#93; The identifier of the intent that contains the slot.
#' @param multipleValuesSetting Determines whether the slot accepts multiple values in one response.
#' Multiple value slots are only available in the en-US locale. If you set
#' this value to `true` in any other locale, Amazon Lex throws a
#' `ValidationException`.
#' 
#' If the `multipleValuesSetting` is not set, the default value is `false`.
#' @param subSlotSetting Specifications for the constituent sub slots and the expression for the
#' composite slot.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_slot
lexmodelsv2_update_slot <- function(slotId, slotName, description = NULL, slotTypeId = NULL, valueElicitationSetting, obfuscationSetting = NULL, botId, botVersion, localeId, intentId, multipleValuesSetting = NULL, subSlotSetting = NULL) {
  op <- new_operation(
    name = "UpdateSlot",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_slot_input(slotId = slotId, slotName = slotName, description = description, slotTypeId = slotTypeId, valueElicitationSetting = valueElicitationSetting, obfuscationSetting = obfuscationSetting, botId = botId, botVersion = botVersion, localeId = localeId, intentId = intentId, multipleValuesSetting = multipleValuesSetting, subSlotSetting = subSlotSetting)
  output <- .lexmodelsv2$update_slot_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_slot <- lexmodelsv2_update_slot

#' Updates the configuration of an existing slot type
#'
#' @description
#' Updates the configuration of an existing slot type.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_slot_type/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_slot_type/) for full documentation.
#'
#' @param slotTypeId &#91;required&#93; The unique identifier of the slot type to update.
#' @param slotTypeName &#91;required&#93; The new name of the slot type.
#' @param description The new description of the slot type.
#' @param slotTypeValues A new list of values and their optional synonyms that define the values
#' that the slot type can take.
#' @param valueSelectionSetting The strategy that Amazon Lex should use when deciding on a value from
#' the list of slot type values.
#' @param parentSlotTypeSignature The new built-in slot type that should be used as the parent of this
#' slot type.
#' @param botId &#91;required&#93; The identifier of the bot that contains the slot type.
#' @param botVersion &#91;required&#93; The version of the bot that contains the slot type. Must be `DRAFT`.
#' @param localeId &#91;required&#93; The identifier of the language and locale that contains the slot type.
#' The string must match one of the supported locales. For more
#' information, see [Supported
#' languages](https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html).
#' @param externalSourceSetting 
#' @param compositeSlotTypeSetting Specifications for a composite slot type.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_slot_type
lexmodelsv2_update_slot_type <- function(slotTypeId, slotTypeName, description = NULL, slotTypeValues = NULL, valueSelectionSetting = NULL, parentSlotTypeSignature = NULL, botId, botVersion, localeId, externalSourceSetting = NULL, compositeSlotTypeSetting = NULL) {
  op <- new_operation(
    name = "UpdateSlotType",
    http_method = "PUT",
    http_path = "/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}/",
    paginator = list()
  )
  input <- .lexmodelsv2$update_slot_type_input(slotTypeId = slotTypeId, slotTypeName = slotTypeName, description = description, slotTypeValues = slotTypeValues, valueSelectionSetting = valueSelectionSetting, parentSlotTypeSignature = parentSlotTypeSignature, botId = botId, botVersion = botVersion, localeId = localeId, externalSourceSetting = externalSourceSetting, compositeSlotTypeSetting = compositeSlotTypeSetting)
  output <- .lexmodelsv2$update_slot_type_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_slot_type <- lexmodelsv2_update_slot_type

#' The action to update the test set
#'
#' @description
#' The action to update the test set.
#'
#' See [https://www.paws-r-sdk.com/docs/lexmodelsv2_update_test_set/](https://www.paws-r-sdk.com/docs/lexmodelsv2_update_test_set/) for full documentation.
#'
#' @param testSetId &#91;required&#93; The test set Id for which update test operation to be performed.
#' @param testSetName &#91;required&#93; The new test set name.
#' @param description The new test set description.
#'
#' @keywords internal
#'
#' @rdname lexmodelsv2_update_test_set
lexmodelsv2_update_test_set <- function(testSetId, testSetName, description = NULL) {
  op <- new_operation(
    name = "UpdateTestSet",
    http_method = "PUT",
    http_path = "/testsets/{testSetId}",
    paginator = list()
  )
  input <- .lexmodelsv2$update_test_set_input(testSetId = testSetId, testSetName = testSetName, description = description)
  output <- .lexmodelsv2$update_test_set_output()
  config <- get_config()
  svc <- .lexmodelsv2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexmodelsv2$operations$update_test_set <- lexmodelsv2_update_test_set
