% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_pipeline_executions}
\alias{sagemaker_list_pipeline_executions}
\title{Gets a list of the pipeline executions}
\usage{
sagemaker_list_pipeline_executions(
  PipelineName,
  CreatedAfter = NULL,
  CreatedBefore = NULL,
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{PipelineName}{[required] The name or Amazon Resource Name (ARN) of the pipeline.}

\item{CreatedAfter}{A filter that returns the pipeline executions that were created after a
specified time.}

\item{CreatedBefore}{A filter that returns the pipeline executions that were created before a
specified time.}

\item{SortBy}{The field by which to sort results. The default is \code{CreatedTime}.}

\item{SortOrder}{The sort order for results.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_pipeline_executions]{list_pipeline_executions}} request
was truncated, the response includes a \code{NextToken}. To retrieve the next
set of pipeline executions, use the token in the next request.}

\item{MaxResults}{The maximum number of pipeline executions to return in the response.}
}
\description{
Gets a list of the pipeline executions.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_pipeline_executions/} for full documentation.
}
\keyword{internal}
