# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include bedrockagentruntime_service.R
NULL

#' Deletes memory from the specified memory identifier
#'
#' @description
#' Deletes memory from the specified memory identifier.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_delete_agent_memory/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_delete_agent_memory/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The unique identifier of an alias of an agent.
#' @param agentId &#91;required&#93; The unique identifier of the agent to which the alias belongs.
#' @param memoryId The unique identifier of the memory.
#' @param sessionId The unique session identifier of the memory.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_delete_agent_memory
bedrockagentruntime_delete_agent_memory <- function(agentAliasId, agentId, memoryId = NULL, sessionId = NULL) {
  op <- new_operation(
    name = "DeleteAgentMemory",
    http_method = "DELETE",
    http_path = "/agents/{agentId}/agentAliases/{agentAliasId}/memories",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$delete_agent_memory_input(agentAliasId = agentAliasId, agentId = agentId, memoryId = memoryId, sessionId = sessionId)
  output <- .bedrockagentruntime$delete_agent_memory_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$delete_agent_memory <- bedrockagentruntime_delete_agent_memory

#' Generates an SQL query from a natural language query
#'
#' @description
#' Generates an SQL query from a natural language query. For more information, see [Generate a query for structured data](https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-generate-query.html) in the Amazon Bedrock User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_generate_query/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_generate_query/) for full documentation.
#'
#' @param queryGenerationInput &#91;required&#93; Specifies information about a natural language query to transform into
#' SQL.
#' @param transformationConfiguration &#91;required&#93; Specifies configurations for transforming the natural language query
#' into SQL.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_generate_query
bedrockagentruntime_generate_query <- function(queryGenerationInput, transformationConfiguration) {
  op <- new_operation(
    name = "GenerateQuery",
    http_method = "POST",
    http_path = "/generateQuery",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$generate_query_input(queryGenerationInput = queryGenerationInput, transformationConfiguration = transformationConfiguration)
  output <- .bedrockagentruntime$generate_query_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$generate_query <- bedrockagentruntime_generate_query

#' Gets the sessions stored in the memory of the agent
#'
#' @description
#' Gets the sessions stored in the memory of the agent.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_get_agent_memory/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_get_agent_memory/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The unique identifier of an alias of an agent.
#' @param agentId &#91;required&#93; The unique identifier of the agent to which the alias belongs.
#' @param maxItems The maximum number of items to return in the response. If the total
#' number of results is greater than this value, use the token returned in
#' the response in the `nextToken` field when making another request to
#' return the next batch of results.
#' @param memoryId &#91;required&#93; The unique identifier of the memory.
#' @param memoryType &#91;required&#93; The type of memory.
#' @param nextToken If the total number of results is greater than the maxItems value
#' provided in the request, enter the token returned in the `nextToken`
#' field in the response in this field to return the next batch of results.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_get_agent_memory
bedrockagentruntime_get_agent_memory <- function(agentAliasId, agentId, maxItems = NULL, memoryId, memoryType, nextToken = NULL) {
  op <- new_operation(
    name = "GetAgentMemory",
    http_method = "GET",
    http_path = "/agents/{agentId}/agentAliases/{agentAliasId}/memories",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxItems", result_key = "memoryContents"),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$get_agent_memory_input(agentAliasId = agentAliasId, agentId = agentId, maxItems = maxItems, memoryId = memoryId, memoryType = memoryType, nextToken = nextToken)
  output <- .bedrockagentruntime$get_agent_memory_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$get_agent_memory <- bedrockagentruntime_get_agent_memory

#' Sends a prompt for the agent to process and respond to
#'
#' @description
#' Sends a prompt for the agent to process and respond to. Note the following fields for the request:
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_agent/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_agent/) for full documentation.
#'
#' @param agentAliasId &#91;required&#93; The alias of the agent to use.
#' @param agentId &#91;required&#93; The unique identifier of the agent to use.
#' @param bedrockModelConfigurations Model performance settings for the request.
#' @param enableTrace Specifies whether to turn on the trace or not to track the agent's
#' reasoning process. For more information, see [Trace
#' enablement](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-test.html#trace-events).
#' @param endSession Specifies whether to end the session with the agent or not.
#' @param inputText The prompt text to send the agent.
#' 
#' If you include `returnControlInvocationResults` in the `sessionState`
#' field, the `inputText` field will be ignored.
#' @param memoryId The unique identifier of the agent memory.
#' @param sessionId &#91;required&#93; The unique identifier of the session. Use the same value across requests
#' to continue the same conversation.
#' @param sessionState Contains parameters that specify various attributes of the session. For
#' more information, see [Control session
#' context](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
#' 
#' If you include `returnControlInvocationResults` in the `sessionState`
#' field, the `inputText` field will be ignored.
#' @param sourceArn The ARN of the resource making the request.
#' @param streamingConfigurations Specifies the configurations for streaming.
#' 
#' To use agent streaming, you need permissions to perform the
#' `bedrock:InvokeModelWithResponseStream` action.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_invoke_agent
bedrockagentruntime_invoke_agent <- function(agentAliasId, agentId, bedrockModelConfigurations = NULL, enableTrace = NULL, endSession = NULL, inputText = NULL, memoryId = NULL, sessionId, sessionState = NULL, sourceArn = NULL, streamingConfigurations = NULL) {
  op <- new_operation(
    name = "InvokeAgent",
    http_method = "POST",
    http_path = "/agents/{agentId}/agentAliases/{agentAliasId}/sessions/{sessionId}/text",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockagentruntime$invoke_agent_input(agentAliasId = agentAliasId, agentId = agentId, bedrockModelConfigurations = bedrockModelConfigurations, enableTrace = enableTrace, endSession = endSession, inputText = inputText, memoryId = memoryId, sessionId = sessionId, sessionState = sessionState, sourceArn = sourceArn, streamingConfigurations = streamingConfigurations)
  output <- .bedrockagentruntime$invoke_agent_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$invoke_agent <- bedrockagentruntime_invoke_agent

#' Invokes an alias of a flow to run the inputs that you specify and return
#' the output of each node as a stream
#'
#' @description
#' Invokes an alias of a flow to run the inputs that you specify and return the output of each node as a stream. If there's an error, the error is returned. For more information, see [Test a flow in Amazon Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-test.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_flow/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_flow/) for full documentation.
#'
#' @param enableTrace Specifies whether to return the trace for the flow or not. Traces track
#' inputs and outputs for nodes in the flow. For more information, see
#' [Track each step in your prompt flow by viewing its trace in Amazon
#' Bedrock](https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html).
#' @param executionId The unique identifier for the current flow execution. If you don't
#' provide a value, Amazon Bedrock creates the identifier for you.
#' @param flowAliasIdentifier &#91;required&#93; The unique identifier of the flow alias.
#' @param flowIdentifier &#91;required&#93; The unique identifier of the flow.
#' @param inputs &#91;required&#93; A list of objects, each containing information about an input into the
#' flow.
#' @param modelPerformanceConfiguration Model performance settings for the request.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_invoke_flow
bedrockagentruntime_invoke_flow <- function(enableTrace = NULL, executionId = NULL, flowAliasIdentifier, flowIdentifier, inputs, modelPerformanceConfiguration = NULL) {
  op <- new_operation(
    name = "InvokeFlow",
    http_method = "POST",
    http_path = "/flows/{flowIdentifier}/aliases/{flowAliasIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockagentruntime$invoke_flow_input(enableTrace = enableTrace, executionId = executionId, flowAliasIdentifier = flowAliasIdentifier, flowIdentifier = flowIdentifier, inputs = inputs, modelPerformanceConfiguration = modelPerformanceConfiguration)
  output <- .bedrockagentruntime$invoke_flow_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$invoke_flow <- bedrockagentruntime_invoke_flow

#' Invokes an inline Amazon Bedrock agent using the configurations you
#' provide with the request
#'
#' @description
#' Invokes an inline Amazon Bedrock agent using the configurations you provide with the request.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_inline_agent/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_invoke_inline_agent/) for full documentation.
#'
#' @param actionGroups A list of action groups with each action group defining the action the
#' inline agent needs to carry out.
#' @param bedrockModelConfigurations Model settings for the request.
#' @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the Amazon Web Services KMS key to use
#' to encrypt your inline agent.
#' @param enableTrace Specifies whether to turn on the trace or not to track the agent's
#' reasoning process. For more information, see [Using
#' trace](https://docs.aws.amazon.com/bedrock/latest/userguide/trace-events.html).
#' 
#'      </p> 
#' @param endSession Specifies whether to end the session with the inline agent or not.
#' @param foundationModel &#91;required&#93; The [model identifier
#' (ID)](https://docs.aws.amazon.com/bedrock/latest/userguide/models-supported.html#model-ids-arns)
#' of the model to use for orchestration by the inline agent. For example,
#' `meta.llama3-1-70b-instruct-v1:0`.
#' @param guardrailConfiguration The
#' [guardrails](https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html)
#' to assign to the inline agent.
#' @param idleSessionTTLInSeconds The number of seconds for which the inline agent should maintain session
#' information. After this time expires, the subsequent
#' [`invoke_inline_agent`][bedrockagentruntime_invoke_inline_agent] request
#' begins a new session.
#' 
#' A user interaction remains active for the amount of time specified. If
#' no conversation occurs during this time, the session expires and the
#' data provided before the timeout is deleted.
#' @param inlineSessionState Parameters that specify the various attributes of a sessions. You can
#' include attributes for the session or prompt or, if you configured an
#' action group to return control, results from invocation of the action
#' group. For more information, see [Control session
#' context](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-session-state.html).
#' 
#' If you include `returnControlInvocationResults` in the `sessionState`
#' field, the `inputText` field will be ignored.
#' @param inputText The prompt text to send to the agent.
#' 
#' If you include `returnControlInvocationResults` in the `sessionState`
#' field, the `inputText` field will be ignored.
#' @param instruction &#91;required&#93; The instructions that tell the inline agent what it should do and how it
#' should interact with users.
#' @param knowledgeBases Contains information of the knowledge bases to associate with.
#' @param promptOverrideConfiguration Configurations for advanced prompts used to override the default prompts
#' to enhance the accuracy of the inline agent.
#' @param sessionId &#91;required&#93; The unique identifier of the session. Use the same value across requests
#' to continue the same conversation.
#' @param streamingConfigurations Specifies the configurations for streaming.
#' 
#' To use agent streaming, you need permissions to perform the
#' `bedrock:InvokeModelWithResponseStream` action.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_invoke_inline_agent
bedrockagentruntime_invoke_inline_agent <- function(actionGroups = NULL, bedrockModelConfigurations = NULL, customerEncryptionKeyArn = NULL, enableTrace = NULL, endSession = NULL, foundationModel, guardrailConfiguration = NULL, idleSessionTTLInSeconds = NULL, inlineSessionState = NULL, inputText = NULL, instruction, knowledgeBases = NULL, promptOverrideConfiguration = NULL, sessionId, streamingConfigurations = NULL) {
  op <- new_operation(
    name = "InvokeInlineAgent",
    http_method = "POST",
    http_path = "/agents/{sessionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockagentruntime$invoke_inline_agent_input(actionGroups = actionGroups, bedrockModelConfigurations = bedrockModelConfigurations, customerEncryptionKeyArn = customerEncryptionKeyArn, enableTrace = enableTrace, endSession = endSession, foundationModel = foundationModel, guardrailConfiguration = guardrailConfiguration, idleSessionTTLInSeconds = idleSessionTTLInSeconds, inlineSessionState = inlineSessionState, inputText = inputText, instruction = instruction, knowledgeBases = knowledgeBases, promptOverrideConfiguration = promptOverrideConfiguration, sessionId = sessionId, streamingConfigurations = streamingConfigurations)
  output <- .bedrockagentruntime$invoke_inline_agent_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$invoke_inline_agent <- bedrockagentruntime_invoke_inline_agent

#' Optimizes a prompt for the task that you specify
#'
#' @description
#' Optimizes a prompt for the task that you specify. For more information, see [Optimize a prompt](https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management-optimize.html) in the [Amazon Bedrock User Guide](https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_optimize_prompt/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_optimize_prompt/) for full documentation.
#'
#' @param input &#91;required&#93; Contains the prompt to optimize.
#' @param targetModelId &#91;required&#93; The unique identifier of the model that you want to optimize the prompt
#' for.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_optimize_prompt
bedrockagentruntime_optimize_prompt <- function(input, targetModelId) {
  op <- new_operation(
    name = "OptimizePrompt",
    http_method = "POST",
    http_path = "/optimize-prompt",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockagentruntime$optimize_prompt_input(input = input, targetModelId = targetModelId)
  output <- .bedrockagentruntime$optimize_prompt_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$optimize_prompt <- bedrockagentruntime_optimize_prompt

#' Reranks the relevance of sources based on queries
#'
#' @description
#' Reranks the relevance of sources based on queries. For more information, see [Improve the relevance of query responses with a reranker model](https://docs.aws.amazon.com/bedrock/latest/userguide/rerank.html).
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_rerank/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_rerank/) for full documentation.
#'
#' @param nextToken If the total number of results was greater than could fit in a response,
#' a token is returned in the `nextToken` field. You can enter that token
#' in this field to return the next batch of results.
#' @param queries &#91;required&#93; An array of objects, each of which contains information about a query to
#' submit to the reranker model.
#' @param rerankingConfiguration &#91;required&#93; Contains configurations for reranking.
#' @param sources &#91;required&#93; An array of objects, each of which contains information about the
#' sources to rerank.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_rerank
bedrockagentruntime_rerank <- function(nextToken = NULL, queries, rerankingConfiguration, sources) {
  op <- new_operation(
    name = "Rerank",
    http_method = "POST",
    http_path = "/rerank",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "results"),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$rerank_input(nextToken = nextToken, queries = queries, rerankingConfiguration = rerankingConfiguration, sources = sources)
  output <- .bedrockagentruntime$rerank_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$rerank <- bedrockagentruntime_rerank

#' Queries a knowledge base and retrieves information from it
#'
#' @description
#' Queries a knowledge base and retrieves information from it.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve/) for full documentation.
#'
#' @param guardrailConfiguration Guardrail settings.
#' @param knowledgeBaseId &#91;required&#93; The unique identifier of the knowledge base to query.
#' @param nextToken If there are more results than can fit in the response, the response
#' returns a `nextToken`. Use this token in the `nextToken` field of
#' another request to retrieve the next batch of results.
#' @param retrievalConfiguration Contains configurations for the knowledge base query and retrieval
#' process. For more information, see [Query
#' configurations](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
#' @param retrievalQuery &#91;required&#93; Contains the query to send the knowledge base.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_retrieve
bedrockagentruntime_retrieve <- function(guardrailConfiguration = NULL, knowledgeBaseId, nextToken = NULL, retrievalConfiguration = NULL, retrievalQuery) {
  op <- new_operation(
    name = "Retrieve",
    http_method = "POST",
    http_path = "/knowledgebases/{knowledgeBaseId}/retrieve",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", result_key = "retrievalResults"),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$retrieve_input(guardrailConfiguration = guardrailConfiguration, knowledgeBaseId = knowledgeBaseId, nextToken = nextToken, retrievalConfiguration = retrievalConfiguration, retrievalQuery = retrievalQuery)
  output <- .bedrockagentruntime$retrieve_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$retrieve <- bedrockagentruntime_retrieve

#' Queries a knowledge base and generates responses based on the retrieved
#' results and using the specified foundation model or inference profile
#'
#' @description
#' Queries a knowledge base and generates responses based on the retrieved results and using the specified foundation model or [inference profile](https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html). The response only cites sources that are relevant to the query.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve_and_generate/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve_and_generate/) for full documentation.
#'
#' @param input &#91;required&#93; Contains the query to be made to the knowledge base.
#' @param retrieveAndGenerateConfiguration Contains configurations for the knowledge base query and retrieval
#' process. For more information, see [Query
#' configurations](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
#' @param sessionConfiguration Contains details about the session with the knowledge base.
#' @param sessionId The unique identifier of the session. When you first make a
#' [`retrieve_and_generate`][bedrockagentruntime_retrieve_and_generate]
#' request, Amazon Bedrock automatically generates this value. You must
#' reuse this value for all subsequent requests in the same conversational
#' session. This value allows Amazon Bedrock to maintain context and
#' knowledge from previous interactions. You can't explicitly set the
#' `sessionId` yourself.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_retrieve_and_generate
bedrockagentruntime_retrieve_and_generate <- function(input, retrieveAndGenerateConfiguration = NULL, sessionConfiguration = NULL, sessionId = NULL) {
  op <- new_operation(
    name = "RetrieveAndGenerate",
    http_method = "POST",
    http_path = "/retrieveAndGenerate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .bedrockagentruntime$retrieve_and_generate_input(input = input, retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration, sessionConfiguration = sessionConfiguration, sessionId = sessionId)
  output <- .bedrockagentruntime$retrieve_and_generate_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$retrieve_and_generate <- bedrockagentruntime_retrieve_and_generate

#' Queries a knowledge base and generates responses based on the retrieved
#' results, with output in streaming format
#'
#' @description
#' Queries a knowledge base and generates responses based on the retrieved results, with output in streaming format.
#'
#' See [https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve_and_generate_stream/](https://www.paws-r-sdk.com/docs/bedrockagentruntime_retrieve_and_generate_stream/) for full documentation.
#'
#' @param input &#91;required&#93; Contains the query to be made to the knowledge base.
#' @param retrieveAndGenerateConfiguration Contains configurations for the knowledge base query and retrieval
#' process. For more information, see [Query
#' configurations](https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html).
#' @param sessionConfiguration Contains details about the session with the knowledge base.
#' @param sessionId The unique identifier of the session. When you first make a
#' [`retrieve_and_generate`][bedrockagentruntime_retrieve_and_generate]
#' request, Amazon Bedrock automatically generates this value. You must
#' reuse this value for all subsequent requests in the same conversational
#' session. This value allows Amazon Bedrock to maintain context and
#' knowledge from previous interactions. You can't explicitly set the
#' `sessionId` yourself.
#'
#' @keywords internal
#'
#' @rdname bedrockagentruntime_retrieve_and_generate_stream
bedrockagentruntime_retrieve_and_generate_stream <- function(input, retrieveAndGenerateConfiguration = NULL, sessionConfiguration = NULL, sessionId = NULL) {
  op <- new_operation(
    name = "RetrieveAndGenerateStream",
    http_method = "POST",
    http_path = "/retrieveAndGenerateStream",
    host_prefix = "",
    paginator = list(),
    stream_api = TRUE
  )
  input <- .bedrockagentruntime$retrieve_and_generate_stream_input(input = input, retrieveAndGenerateConfiguration = retrieveAndGenerateConfiguration, sessionConfiguration = sessionConfiguration, sessionId = sessionId)
  output <- .bedrockagentruntime$retrieve_and_generate_stream_output()
  config <- get_config()
  svc <- .bedrockagentruntime$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.bedrockagentruntime$operations$retrieve_and_generate_stream <- bedrockagentruntime_retrieve_and_generate_stream
