% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_workforce}
\alias{sagemaker_update_workforce}
\title{Use this operation to update your workforce}
\usage{
sagemaker_update_workforce(
  WorkforceName,
  SourceIpConfig = NULL,
  OidcConfig = NULL,
  WorkforceVpcConfig = NULL
)
}
\arguments{
\item{WorkforceName}{[required] The name of the private workforce that you want to update. You can find
your workforce name by using the
\code{\link[=sagemaker_list_workforces]{list_workforces}} operation.}

\item{SourceIpConfig}{A list of one to ten worker IP address ranges
(\href{https://docs.aws.amazon.com/vpc/latest/userguide/how-it-works.html}{CIDRs})
that can be used to access tasks assigned to this workforce.

Maximum: Ten CIDR values}

\item{OidcConfig}{Use this parameter to update your OIDC Identity Provider (IdP)
configuration for a workforce made using your own IdP.}

\item{WorkforceVpcConfig}{Use this parameter to update your VPC configuration for a workforce.}
}
\description{
Use this operation to update your workforce. You can use this operation to require that workers use specific IP addresses to work on tasks and to update your OpenID Connect (OIDC) Identity Provider (IdP) workforce configuration.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_workforce/} for full documentation.
}
\keyword{internal}
